/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CGlobalVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CVariableFactory {
    public static CVariable createVariable(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject) {
        return new CVariable(parent, cdiVariableObject);
    }

    public static CVariable createVariableWithError(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject, String message) {
        return new CVariable(parent, cdiVariableObject, message);
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(final String name, final IPath path) {
        return new IGlobalVariableDescriptor(){

            public String getName() {
                return name;
            }

            public IPath getPath() {
                return path;
            }

            public String toString() {
                return MessageFormat.format("{0}::{1}", this.getPath().toOSString(), this.getName());
            }
        };
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(IVariable var) {
        Path path = new Path("");
        ICElement parent = var.getParent();
        if (parent instanceof IBinaryModule) {
            path = ((IBinaryModule)parent).getPath();
        }
        return CVariableFactory.createGlobalVariableDescriptor(var.getElementName(), (IPath)path);
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(IBinaryParser.ISymbol symbol) {
        return CVariableFactory.createGlobalVariableDescriptor(symbol.getName(), symbol.getFilename());
    }

    public static CGlobalVariable createGlobalVariable(CDebugElement parent, IGlobalVariableDescriptor descriptor, ICDIVariableDescriptor cdiVariableObject) {
        return new CGlobalVariable(parent, descriptor, cdiVariableObject);
    }
}

