/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.dialogs.TabFolderOptionBlock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractPathOptionBlock
extends TabFolderOptionBlock
implements ICOptionContainer {
    private StatusInfo fCPathStatus;
    private StatusInfo fBuildPathStatus;
    private ICProject fCurrCProject;
    private String fUserSettingsTimeStamp;
    private long fFileTimeStamp;
    private int fPageIndex;
    private int fPageCount;
    private CPathBasePage fCurrPage;
    private IStatusChangeListener fContext;

    public AbstractPathOptionBlock(IStatusChangeListener context, int pageToShow) {
        super(false);
        this.fContext = context;
        this.fPageIndex = pageToShow;
        this.fCPathStatus = new StatusInfo();
        this.fBuildPathStatus = new StatusInfo();
        this.setOptionContainer(this);
    }

    public IPathEntry[] getRawCPath() throws CModelException {
        List elements = this.getCPaths();
        IPathEntry[] entries = this.fCurrCProject.getRawPathEntries();
        ArrayList<IPathEntry> cpath = new ArrayList<IPathEntry>(elements.size() + entries.length);
        int[] applyTypes = this.getAppliedFilteredTypes();
        int i = 0;
        while (i < elements.size()) {
            CPElement entry = (CPElement)elements.get(i);
            int j = 0;
            while (j < applyTypes.length) {
                if (entry.getEntryKind() == applyTypes[j]) {
                    cpath.add(entry.getPathEntry());
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < entries.length) {
            int pathType = entries[i].getEntryKind();
            boolean found = false;
            int j = 0;
            while (j < applyTypes.length) {
                if (pathType == applyTypes[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                cpath.add(entries[i]);
            }
            ++i;
        }
        return cpath.toArray(new IPathEntry[cpath.size()]);
    }

    public void init(ICElement element, IPathEntry[] cpathEntries) {
        this.setCProject(element.getCProject());
        ArrayList newCPath = null;
        if (cpathEntries == null) {
            try {
                cpathEntries = this.getCProject().getRawPathEntries();
            }
            catch (CModelException cModelException) {}
        }
        newCPath = cpathEntries != null ? this.getFilteredElements(cpathEntries, this.getFilteredTypes()) : new ArrayList();
        this.initialize(element, newCPath);
    }

    protected abstract int[] getFilteredTypes();

    protected abstract int[] getAppliedFilteredTypes();

    protected abstract void initialize(ICElement var1, List var2);

    protected ArrayList getFilteredElements(IPathEntry[] cPathEntries, int[] types) {
        ArrayList<CPElement> newCPath = new ArrayList<CPElement>();
        int i = 0;
        while (i < cPathEntries.length) {
            IPathEntry curr = cPathEntries[i];
            if (this.contains(types, curr.getEntryKind())) {
                newCPath.add(CPElement.createFromExisting(curr, this.fCurrCProject));
            }
            ++i;
        }
        return newCPath;
    }

    private boolean contains(int[] set, int elem) {
        if (set == null) {
            return false;
        }
        int i = 0;
        while (i < set.length) {
            if (set[i] == elem) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract List getCPaths();

    private String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        List elements = this.getCPaths();
        int nElements = elements.size();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            CPElement elem = (CPElement)elements.get(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public boolean hasChangesInCPathFile() {
        IFile file = this.fCurrCProject.getProject().getFile(".cdtproject");
        return this.fFileTimeStamp != file.getModificationStamp();
    }

    public void initializeTimeStamps() {
        IFile file = this.fCurrCProject.getProject().getFile(".cdtproject");
        this.fFileTimeStamp = file.getModificationStamp();
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    protected abstract void addTabs();

    protected void setCProject(ICProject project) {
        this.fCurrCProject = project;
    }

    protected ICProject getCProject() {
        return this.fCurrCProject;
    }

    public IProject getProject() {
        return this.fCurrCProject.getProject();
    }

    protected void doStatusLineUpdate() {
        IStatus res = this.findMostSevereStatus();
        this.fContext.statusChanged(res);
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fCPathStatus, this.fBuildPathStatus});
    }

    protected StatusInfo getPathStatus() {
        return this.fCPathStatus;
    }

    public void setCurrentPage(ICOptionPage page) {
        List selection;
        super.setCurrentPage(page);
        CPathBasePage newPage = (CPathBasePage)page;
        if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
            newPage.setSelection(selection);
        }
        this.fCurrPage = (CPathBasePage)page;
    }

    public void updateContainer() {
        this.update();
    }

    protected void updateBuildPathStatus() {
        List elements = this.getCPaths();
        IPathEntry[] entries = new IPathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPElement currElement = (CPElement)elements.get(i);
            entries[i] = currElement.getPathEntry();
            --i;
        }
        ICModelStatus status = CoreModel.validatePathEntries((ICProject)this.fCurrCProject, (IPathEntry[])entries);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    public Preferences getPreferences() {
        return null;
    }

    protected void addPage(CPathBasePage page) {
        this.addTab(page);
        if (this.fPageIndex == this.fPageCount) {
            this.fCurrPage = page;
        }
        ++this.fPageCount;
    }

    protected ICOptionPage getStartPage() {
        if (this.fCurrPage == null) {
            return super.getStartPage();
        }
        return this.fCurrPage;
    }

    protected void internalConfigureCProject(List cPathEntries, IProgressMonitor monitor) throws CoreException, InterruptedException {
        monitor.worked(2);
        IPathEntry[] entries = this.fCurrCProject.getRawPathEntries();
        ArrayList<IPathEntry> cpath = new ArrayList<IPathEntry>(cPathEntries.size() + entries.length);
        int[] applyTypes = this.getAppliedFilteredTypes();
        int i = 0;
        while (i < cPathEntries.size()) {
            CPElement entry = (CPElement)cPathEntries.get(i);
            int j = 0;
            while (j < applyTypes.length) {
                if (entry.getEntryKind() == applyTypes[j]) {
                    IResource res = entry.getResource();
                    if (res instanceof IFolder && !res.exists()) {
                        CoreUtility.createFolder((IFolder)res, true, true, null);
                    }
                    cpath.add(entry.getPathEntry());
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < entries.length) {
            int pathType = entries[i].getEntryKind();
            boolean found = false;
            int j = 0;
            while (j < applyTypes.length) {
                if (pathType == applyTypes[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                cpath.add(entries[i]);
            }
            ++i;
        }
        monitor.worked(1);
        this.getCProject().setRawPathEntries(cpath.toArray(new IPathEntry[cpath.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 7));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureCProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(CPathEntryMessages.getString("CPathsBlock.operationdesc_c"));
        monitor.beginTask("", 10);
        try {
            this.internalConfigureCProject(this.getCPaths(), monitor);
            this.initializeTimeStamps();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }
}

