/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Tool
extends BuildObject
implements ITool,
IOptionCategory {
    public static final String DEFAULT_PATTERN = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
    private static final String DEFAULT_SEPARATOR = ",";
    private static final IOptionCategory[] EMPTY_CATEGORIES = new IOptionCategory[0];
    private static final IOption[] EMPTY_OPTIONS = new IOption[0];
    private static final String EMPTY_STRING = new String();
    private ITool superClass;
    private String superClassId;
    private IBuildObject parent;
    private Vector categoryIds;
    private Map categoryMap;
    private List childOptionCategories;
    private Vector optionList;
    private Map optionMap;
    private String unusedChildren;
    private Boolean isAbstract;
    private String command;
    private List inputExtensions;
    private List interfaceExtensions;
    private Integer natureFilter;
    private String outputExtensions;
    private String outputFlag;
    private String outputPrefix;
    private String errorParserIds;
    private String commandLinePattern;
    private IConfigurationElement commandLineGeneratorElement = null;
    private IManagedCommandLineGenerator commandLineGenerator = null;
    private IConfigurationElement dependencyGeneratorElement = null;
    private IManagedDependencyGenerator dependencyGenerator = null;
    private boolean isExtensionTool = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public Tool(IManagedConfigElement element) {
        this.isExtensionTool = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionTool(this);
        this.addOptionCategory(this);
        IManagedConfigElement[] toolElements = element.getChildren();
        int l = 0;
        while (l < toolElements.length) {
            IManagedConfigElement toolElement = toolElements[l];
            if (toolElement.getName().equals("option")) {
                Option option = new Option(this, toolElement);
                this.addOption(option);
            } else if (toolElement.getName().equals("optionCategory")) {
                new OptionCategory(this, toolElement);
            }
            ++l;
        }
    }

    public Tool(IBuildObject parent, IManagedConfigElement element) {
        this(element);
        this.parent = parent;
    }

    public Tool(ToolChain parent, ITool superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionTool = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionTool(this);
        } else {
            this.setDirty(true);
        }
    }

    public Tool(ResourceConfiguration parent, ITool superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionTool = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionTool(this);
        } else {
            this.setDirty(true);
        }
    }

    public Tool(IBuildObject parent, Element element) {
        this.parent = parent;
        this.isExtensionTool = false;
        this.loadFromProject(element);
        this.addOptionCategory(this);
        NodeList toolElements = element.getChildNodes();
        int i = 0;
        while (i < toolElements.getLength()) {
            Node toolElement = toolElements.item(i);
            if (toolElement.getNodeName().equals("option")) {
                Option option = new Option(this, (Element)toolElement);
                this.addOption(option);
            } else if (toolElement.getNodeName().equals("optionCategory")) {
                new OptionCategory(this, (Element)toolElement);
            }
            ++i;
        }
    }

    public Tool(IBuildObject parent, ITool toolSuperClass, String Id, String name, Tool tool) {
        this.parent = parent;
        this.superClass = toolSuperClass != null ? toolSuperClass : tool.superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionTool = false;
        if (tool.unusedChildren != null) {
            this.unusedChildren = new String(tool.unusedChildren);
        }
        if (tool.errorParserIds != null) {
            this.errorParserIds = new String(tool.errorParserIds);
        }
        if (tool.isAbstract != null) {
            this.isAbstract = new Boolean(tool.isAbstract);
        }
        if (tool.command != null) {
            this.command = new String(tool.command);
        }
        if (tool.inputExtensions != null) {
            this.inputExtensions = new ArrayList(tool.inputExtensions);
        }
        if (tool.interfaceExtensions != null) {
            this.interfaceExtensions = new ArrayList(tool.interfaceExtensions);
        }
        if (tool.natureFilter != null) {
            this.natureFilter = new Integer(tool.natureFilter);
        }
        if (tool.outputExtensions != null) {
            this.outputExtensions = new String(tool.outputExtensions);
        }
        if (tool.outputFlag != null) {
            this.outputFlag = new String(tool.outputFlag);
        }
        if (tool.outputPrefix != null) {
            this.outputPrefix = new String(tool.outputPrefix);
        }
        this.commandLineGeneratorElement = tool.commandLineGeneratorElement;
        this.commandLineGenerator = tool.commandLineGenerator;
        this.dependencyGeneratorElement = tool.dependencyGeneratorElement;
        this.dependencyGenerator = tool.dependencyGenerator;
        if (tool.optionList != null) {
            ListIterator iter = tool.getOptionList().listIterator();
            while (iter.hasNext()) {
                String subName;
                String subId;
                Option option = (Option)iter.next();
                int nnn = ManagedBuildManager.getRandomNumber();
                if (option.getSuperClass() != null) {
                    subId = String.valueOf(option.getSuperClass().getId()) + "." + nnn;
                    subName = option.getSuperClass().getName();
                } else {
                    subId = String.valueOf(option.getId()) + "." + nnn;
                    subName = option.getName();
                }
                Option newOption = new Option(this, subId, subName, option);
                this.addOption(newOption);
            }
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String depGenerator;
        String headers;
        String inputs;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.errorParserIds = element.getAttribute("errorParsers");
        String nature = element.getAttribute("natureFilter");
        if (nature != null) {
            this.natureFilter = "both".equals(nature) ? new Integer(2) : ("cnature".equals(nature) ? new Integer(0) : ("ccnature".equals(nature) ? new Integer(1) : new Integer(2)));
        }
        if ((inputs = element.getAttribute("sources")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(tokenizer.nextElement());
            }
        }
        if ((headers = element.getAttribute("headerExtensions")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInterfaceExtensionsList().add(tokenizer.nextElement());
            }
        }
        this.outputExtensions = element.getAttribute("outputs");
        this.command = element.getAttribute("command");
        this.outputFlag = element.getAttribute("outputFlag");
        this.outputPrefix = element.getAttribute("outputPrefix");
        this.commandLinePattern = element.getAttribute("commandLinePattern");
        String commandLineGenerator = element.getAttribute("commandLineGenerator");
        if (commandLineGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.commandLineGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((depGenerator = element.getAttribute("dependencyCalculator")) != null && element instanceof DefaultManagedConfigElement) {
            this.dependencyGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    protected void loadFromProject(Element element) {
        String headers;
        StringTokenizer tokenizer;
        String inputs;
        String nature;
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            if (this.getParent() instanceof IResourceConfiguration) {
                IResourceConfiguration resConfig = (IResourceConfiguration)this.getParent();
                this.superClass = resConfig.getParent().getTool(this.superClassId);
            } else {
                this.superClass = ManagedBuildManager.getExtensionTool(this.superClassId);
            }
        }
        if (element.hasAttribute("unusedChildren")) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.hasAttribute("isAbstract") && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.hasAttribute("natureFilter") && (nature = element.getAttribute("natureFilter")) != null) {
            this.natureFilter = "both".equals(nature) ? new Integer(2) : ("cnature".equals(nature) ? new Integer(0) : ("ccnature".equals(nature) ? new Integer(1) : new Integer(2)));
        }
        if (element.hasAttribute("sources") && (inputs = element.getAttribute("sources")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(tokenizer.nextElement());
            }
        }
        if (element.hasAttribute("headerExtensions") && (headers = element.getAttribute("headerExtensions")) != null) {
            tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInterfaceExtensionsList().add(tokenizer.nextElement());
            }
        }
        if (element.hasAttribute("outputs")) {
            this.outputExtensions = element.getAttribute("outputs");
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        if (element.hasAttribute("outputFlag")) {
            this.outputFlag = element.getAttribute("outputFlag");
        }
        if (element.hasAttribute("outputPrefix")) {
            this.outputPrefix = element.getAttribute("outputPrefix");
        }
        if (element.hasAttribute("commandLinePattern")) {
            this.commandLinePattern = element.getAttribute("commandLinePattern");
        }
    }

    public void serialize(Document doc, Element element) {
        try {
            ListIterator iter;
            List list;
            if (this.superClass != null) {
                element.setAttribute("superClass", this.superClass.getId());
            }
            element.setAttribute("id", this.id);
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.unusedChildren != null) {
                element.setAttribute("unusedChildren", this.unusedChildren);
            }
            if (this.isAbstract != null) {
                element.setAttribute("isAbstract", this.isAbstract.toString());
            }
            if (this.errorParserIds != null) {
                element.setAttribute("errorParsers", this.errorParserIds);
            }
            if (this.natureFilter != null) {
                String nature = this.natureFilter == 0 ? "cnature" : (this.natureFilter == 1 ? "ccnature" : "both");
                element.setAttribute("natureFilter", nature);
            }
            if (this.getInputExtensionsList().size() > 0) {
                list = this.getInputExtensionsList();
                iter = list.listIterator();
                String inputs = (String)iter.next();
                while (iter.hasNext()) {
                    inputs = String.valueOf(inputs) + DEFAULT_SEPARATOR;
                    inputs = String.valueOf(inputs) + iter.next();
                }
                element.setAttribute("sources", inputs);
            }
            if (this.getInterfaceExtensionsList().size() > 0) {
                list = this.getInterfaceExtensionsList();
                iter = list.listIterator();
                String headers = (String)iter.next();
                while (iter.hasNext()) {
                    headers = String.valueOf(headers) + DEFAULT_SEPARATOR;
                    headers = String.valueOf(headers) + iter.next();
                }
                element.setAttribute("headerExtensions", headers);
            }
            if (this.outputExtensions != null) {
                element.setAttribute("outputs", this.outputExtensions);
            }
            if (this.command != null) {
                element.setAttribute("command", this.command);
            }
            if (this.outputFlag != null) {
                element.setAttribute("outputFlag", this.outputFlag);
            }
            if (this.outputPrefix != null) {
                element.setAttribute("outputPrefix", this.outputPrefix);
            }
            if (this.commandLinePattern != null) {
                element.setAttribute("commandLinePattern", this.commandLinePattern);
            }
            if (this.childOptionCategories != null) {
                ListIterator iter2 = this.childOptionCategories.listIterator();
                while (iter2.hasNext()) {
                    OptionCategory optCat = (OptionCategory)iter2.next();
                    Element optCatElement = doc.createElement("option");
                    element.appendChild(optCatElement);
                    optCat.serialize(doc, optCatElement);
                }
            }
            Vector optionElements = this.getOptionList();
            ListIterator iter3 = optionElements.listIterator();
            while (iter3.hasNext()) {
                Option option = (Option)iter3.next();
                Element optionElement = doc.createElement("option");
                element.appendChild(optionElement);
                option.serialize(doc, optionElement);
            }
            this.isDirty = false;
        }
        catch (Exception exception) {}
    }

    public IBuildObject getParent() {
        return this.parent;
    }

    public void setToolParent(IBuildObject newParent) {
        this.parent = newParent;
    }

    public IOption createOption(IOption superClass, String Id, String name, boolean isExtensionElement) {
        Option option = new Option(this, superClass, Id, name, isExtensionElement);
        this.addOption(option);
        this.setDirty(true);
        return option;
    }

    public void removeOption(IOption option) {
        this.getOptionList().remove(option);
        this.getOptionMap().remove(option.getId());
        this.setDirty(true);
    }

    public IOption[] getOptions() {
        IOption[] options = null;
        if (this.superClass != null) {
            options = this.superClass.getOptions();
        }
        Vector ourOpts = this.getOptionList();
        if (options != null) {
            int i = 0;
            while (i < ourOpts.size()) {
                IOption ourOpt = (IOption)ourOpts.get(i);
                int j = 0;
                while (j < options.length) {
                    if (options[j].overridesOnlyValue()) {
                        if (ourOpt.getSuperClass().getId().equals(options[j].getSuperClass().getId())) {
                            options[j] = ourOpt;
                            break;
                        }
                    } else if (ourOpt.getSuperClass().getId().equals(options[j].getId())) {
                        options[j] = ourOpt;
                        break;
                    }
                    ++j;
                }
                if (j == options.length) {
                    IOption[] newOptions = new IOption[options.length + 1];
                    int k = 0;
                    while (k < options.length) {
                        newOptions[k] = options[k];
                        ++k;
                    }
                    newOptions[j] = ourOpt;
                    options = newOptions;
                }
                ++i;
            }
        } else {
            options = ourOpts.toArray(new IOption[ourOpts.size()]);
        }
        return options;
    }

    public IOptionCategory getTopOptionCategory() {
        return this;
    }

    public IOption getOption(String id) {
        return this.getOptionById(id);
    }

    public IOption getOptionById(String id) {
        IOption opt = (IOption)this.getOptionMap().get(id);
        if (opt == null && this.superClass != null) {
            return this.superClass.getOptionById(id);
        }
        return opt;
    }

    public IOptionCategory[] getChildCategories() {
        if (this.childOptionCategories != null) {
            return this.childOptionCategories.toArray(new IOptionCategory[this.childOptionCategories.size()]);
        }
        if (this.superClass != null) {
            return this.superClass.getChildCategories();
        }
        return EMPTY_CATEGORIES;
    }

    public IOptionCategory getOwner() {
        return null;
    }

    public Object[][] getOptions(IConfiguration configuration) {
        if (configuration != null) {
            ITool[] tools = configuration.getTools();
            return this.getOptions(tools);
        }
        return this.getAllOptions(this);
    }

    public Object[][] getOptions(IResourceConfiguration resConfig) {
        ITool[] tools = resConfig.getTools();
        return this.getOptions(tools);
    }

    private Object[][] getOptions(ITool[] tools) {
        Tool catTool = this;
        ITool tool = null;
        int i = 0;
        while (i < tools.length) {
            ITool current = tools[i];
            do {
                if (catTool != current) continue;
                tool = tools[i];
                break;
            } while ((current = current.getSuperClass()) != null);
            if (tool != null) break;
            ++i;
        }
        if (tool == null) {
            return null;
        }
        return this.getAllOptions(tool);
    }

    private Object[][] getAllOptions(ITool tool) {
        IOption[] allOptions = tool.getOptions();
        Object[][] myOptions = new Object[allOptions.length][2];
        int index = 0;
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            IOptionCategory optCat = option.getCategory();
            if (optCat instanceof ITool) {
                ITool current = this;
                boolean match = false;
                do {
                    if (optCat != current) continue;
                    match = true;
                    break;
                } while ((current = current.getSuperClass()) != null);
                if (match) {
                    myOptions[index] = new Object[2];
                    myOptions[index][0] = tool;
                    myOptions[index][1] = option;
                    ++index;
                }
            }
            ++i;
        }
        return myOptions;
    }

    public ITool getTool() {
        return this;
    }

    private Vector getCategoryIds() {
        if (this.categoryIds == null) {
            this.categoryIds = new Vector();
        }
        return this.categoryIds;
    }

    public void addChildCategory(IOptionCategory category) {
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(category);
    }

    public void addOption(Option option) {
        this.getOptionList().add(option);
        this.getOptionMap().put(option.getId(), option);
    }

    protected void addOptionCategory(IOptionCategory category) {
        this.getCategoryIds().add(category.getId());
        this.getCategoryMap().put(category.getId(), category);
    }

    public IOptionCategory getOptionCategory(String id) {
        return (IOptionCategory)this.getCategoryMap().get(id);
    }

    private Map getCategoryMap() {
        if (this.categoryMap == null) {
            this.categoryMap = new HashMap();
        }
        return this.categoryMap;
    }

    private Vector getOptionList() {
        if (this.optionList == null) {
            this.optionList = new Vector();
        }
        return this.optionList;
    }

    private Map getOptionMap() {
        if (this.optionMap == null) {
            this.optionMap = new HashMap();
        }
        return this.optionMap;
    }

    public ITool getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.superClass != null) {
            ids = this.superClass.getErrorParserIds();
        }
        return ids;
    }

    public String[] getErrorParserList() {
        String[] errorParsers;
        String parserIDs = this.getErrorParserIds();
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public List getInputExtensions() {
        if (this.inputExtensions == null || this.inputExtensions.size() == 0) {
            if (this.superClass != null) {
                return this.superClass.getInputExtensions();
            }
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    private List getInputExtensionsList() {
        if (this.inputExtensions == null) {
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    public List getInterfaceExtensions() {
        if (this.interfaceExtensions == null || this.interfaceExtensions.size() == 0) {
            if (this.superClass != null) {
                return this.superClass.getInterfaceExtensions();
            }
            if (this.interfaceExtensions == null) {
                this.interfaceExtensions = new ArrayList();
            }
        }
        return this.interfaceExtensions;
    }

    private List getInterfaceExtensionsList() {
        if (this.interfaceExtensions == null) {
            this.interfaceExtensions = new ArrayList();
        }
        return this.interfaceExtensions;
    }

    public String getOutputFlag() {
        if (this.outputFlag == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputFlag();
            }
            return EMPTY_STRING;
        }
        return this.outputFlag;
    }

    public String getOutputPrefix() {
        if (this.outputPrefix == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputPrefix();
            }
            return EMPTY_STRING;
        }
        return this.outputPrefix;
    }

    public String getToolCommand() {
        if (this.command == null) {
            if (this.superClass != null) {
                return this.superClass.getToolCommand();
            }
            return EMPTY_STRING;
        }
        return this.command;
    }

    public String getCommandLinePattern() {
        if (this.commandLinePattern == null) {
            if (this.superClass != null) {
                return this.superClass.getCommandLinePattern();
            }
            return new String(DEFAULT_PATTERN);
        }
        return this.commandLinePattern;
    }

    public IConfigurationElement getCommandLineGeneratorElement() {
        if (this.commandLineGeneratorElement == null && this.superClass != null) {
            return this.superClass.getCommandLineGeneratorElement();
        }
        return this.commandLineGeneratorElement;
    }

    public void setCommandLineGeneratorElement(IConfigurationElement element) {
        this.commandLineGeneratorElement = element;
        this.setDirty(true);
    }

    public IManagedCommandLineGenerator getCommandLineGenerator() {
        if (this.commandLineGenerator != null) {
            return this.commandLineGenerator;
        }
        IConfigurationElement element = this.getCommandLineGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("commandLineGenerator") != null) {
                    this.commandLineGenerator = (IManagedCommandLineGenerator)element.createExecutableExtension("commandLineGenerator");
                    return this.commandLineGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return ManagedCommandLineGenerator.getCommandLineGenerator();
    }

    public IConfigurationElement getDependencyGeneratorElement() {
        if (this.dependencyGeneratorElement == null && this.superClass != null) {
            return this.superClass.getDependencyGeneratorElement();
        }
        return this.dependencyGeneratorElement;
    }

    public void setDependencyGeneratorElement(IConfigurationElement element) {
        this.dependencyGeneratorElement = element;
        this.setDirty(true);
    }

    public IManagedDependencyGenerator getDependencyGenerator() {
        if (this.dependencyGenerator != null) {
            return this.dependencyGenerator;
        }
        IConfigurationElement element = this.getDependencyGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("dependencyCalculator") != null) {
                    this.dependencyGenerator = (IManagedDependencyGenerator)element.createExecutableExtension("dependencyCalculator");
                    return this.dependencyGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public int getNatureFilter() {
        if (this.natureFilter == null) {
            if (this.superClass != null) {
                return this.superClass.getNatureFilter();
            }
            return 2;
        }
        return this.natureFilter;
    }

    public String[] getOutputExtensions() {
        if (this.outputExtensions == null) {
            if (this.superClass != null) {
                return this.superClass.getOutputExtensions();
            }
            return null;
        }
        return this.outputExtensions.split(DEFAULT_SEPARATOR);
    }

    public String getOutputExtension(String inputExtension) {
        ListIterator iter = this.getInputExtensions().listIterator();
        int i = 0;
        while (iter.hasNext()) {
            String[] exts;
            if (((String)iter.next()).equals(inputExtension) && (exts = this.getOutputExtensions()) != null) {
                if (i < exts.length) {
                    return exts[i];
                }
                return exts[exts.length - 1];
            }
            ++i;
        }
        return null;
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public boolean setToolCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return false;
        }
        if (cmd == null || this.command == null || !cmd.equals(this.command)) {
            this.command = cmd;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    public void setCommandLinePattern(String pattern) {
        if (pattern == null && this.commandLinePattern == null) {
            return;
        }
        if (pattern == null || this.commandLinePattern == null || !pattern.equals(this.commandLinePattern)) {
            this.commandLinePattern = pattern;
            this.isDirty = true;
        }
    }

    public void setOutputFlag(String flag) {
        if (flag == null && this.outputFlag == null) {
            return;
        }
        if (this.outputFlag == null || flag == null || !flag.equals(this.outputFlag)) {
            this.outputFlag = flag;
            this.isDirty = true;
        }
    }

    public void setOutputPrefix(String prefix) {
        if (prefix == null && this.outputPrefix == null) {
            return;
        }
        if (this.outputPrefix == null || prefix == null || !prefix.equals(this.outputPrefix)) {
            this.outputPrefix = prefix;
            this.isDirty = true;
        }
    }

    public void setOutputExtensions(String ext) {
        if (ext == null && this.outputExtensions == null) {
            return;
        }
        if (this.outputExtensions == null || ext == null || !ext.equals(this.outputExtensions)) {
            this.outputExtensions = ext;
            this.isDirty = true;
        }
    }

    public String[] getCommandFlags() throws BuildException {
        IOption[] opts = this.getOptions();
        ArrayList<String> flags = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < opts.length) {
            IOption option = opts[index];
            sb.setLength(0);
            switch (option.getValueType()) {
                case 0: {
                    String boolCmd = option.getBooleanValue() ? option.getCommand() : option.getCommandFalse();
                    if (boolCmd == null || boolCmd.length() <= 0) break;
                    sb.append(boolCmd);
                    break;
                }
                case 1: {
                    String string = option.getEnumCommand(option.getSelectedEnum());
                    if (string.length() <= 0) break;
                    sb.append(string);
                    break;
                }
                case 2: {
                    String strCmd = option.getCommand();
                    String val = option.getStringValue();
                    if (val.length() <= 0) break;
                    sb.append(this.evaluateCommand(strCmd, val));
                    break;
                }
                case 3: {
                    String listCmd = option.getCommand();
                    String[] list = option.getStringListValue();
                    int j = 0;
                    while (j < list.length) {
                        String temp = list[j];
                        sb.append(String.valueOf(this.evaluateCommand(listCmd, temp)) + " ");
                        ++j;
                    }
                    break;
                }
                case 4: {
                    String incCmd = option.getCommand();
                    String[] paths = option.getIncludePaths();
                    int j = 0;
                    while (j < paths.length) {
                        String temp = paths[j];
                        sb.append(String.valueOf(this.evaluateCommand(incCmd, temp)) + " ");
                        ++j;
                    }
                    break;
                }
                case 5: {
                    String defCmd = option.getCommand();
                    String[] symbols = option.getDefinedSymbols();
                    int j = 0;
                    while (j < symbols.length) {
                        String temp = symbols[j];
                        sb.append(String.valueOf(this.evaluateCommand(defCmd, temp)) + " ");
                        ++j;
                    }
                    break;
                }
            }
            if (sb.toString().trim().length() > 0) {
                flags.add(sb.toString().trim());
            }
            ++index;
        }
        String[] f = new String[flags.size()];
        return flags.toArray(f);
    }

    public String getToolFlags() throws BuildException {
        StringBuffer buf = new StringBuffer();
        String[] flags = this.getCommandFlags();
        int index = 0;
        while (index < flags.length) {
            if (flags[index] != null) {
                buf.append(String.valueOf(flags[index]) + " ");
            }
            ++index;
        }
        return buf.toString().trim();
    }

    public boolean isHeaderFile(String ext) {
        if (ext == null) {
            return false;
        }
        return this.getInterfaceExtensions().contains(ext);
    }

    public boolean buildsFileType(String extension) {
        if (extension == null) {
            return false;
        }
        return this.getInputExtensions().contains(extension);
    }

    public boolean producesFileType(String outputExtension) {
        String[] exts = this.getOutputExtensions();
        if (exts != null) {
            int i = 0;
            while (i < exts.length) {
                if (exts[i].equals(outputExtension)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isExtensionElement() {
        return this.isExtensionTool;
    }

    public boolean isDirty() {
        if (this.isExtensionTool) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        Vector optionElements = this.getOptionList();
        ListIterator iter = optionElements.listIterator();
        while (iter.hasNext()) {
            Option option = (Option)iter.next();
            if (!option.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            Vector optionElements = this.getOptionList();
            ListIterator iter = optionElements.listIterator();
            while (iter.hasNext()) {
                Option option = (Option)iter.next();
                option.setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionTool(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "tool", this.getId());
                }
            }
            Iterator optionIter = this.getOptionList().iterator();
            while (optionIter.hasNext()) {
                Option current = (Option)optionIter.next();
                current.resolveReferences();
            }
            Iterator catIter = this.getCategoryIds().iterator();
            while (catIter.hasNext()) {
                String id = (String)catIter.next();
                IOptionCategory current = (IOptionCategory)this.getCategoryMap().get(id);
                if (current instanceof Tool) {
                    ((Tool)current).resolveReferences();
                    continue;
                }
                if (!(current instanceof OptionCategory)) continue;
                ((OptionCategory)current).resolveReferences();
            }
        }
    }

    private String evaluateCommand(String command, String values) {
        if (command == null) {
            return values.trim();
        }
        if (command.indexOf("${") >= 0) {
            return command.replaceAll("\\$\\{[vV][aA][lL][uU][eE]\\}", values.trim()).trim();
        }
        return new String(String.valueOf(command) + values).trim();
    }
}

