/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class Breakpoint
extends CObject
implements ICDILocationBreakpoint {
    ICDILocation fLocation;
    ICDICondition condition;
    MIBreakpoint[] miBreakpoints;
    int type;
    boolean enable;

    public Breakpoint(Target target, int kind, ICDILocation loc, ICDICondition cond) {
        super(target);
        this.type = kind;
        this.fLocation = loc;
        this.condition = cond;
        this.enable = true;
    }

    public MIBreakpoint[] getMIBreakpoints() {
        return this.miBreakpoints;
    }

    public void setMIBreakpoints(MIBreakpoint[] newMIBreakpoints) {
        this.miBreakpoints = newMIBreakpoints;
    }

    public boolean isDeferred() {
        return this.miBreakpoints == null || this.miBreakpoints.length == 0;
    }

    public ICDICondition getCondition() throws CDIException {
        if (this.condition == null) {
            if (this.miBreakpoints != null && this.miBreakpoints.length > 0) {
                ArrayList<String> list = new ArrayList<String>(this.miBreakpoints.length);
                int i = 0;
                while (i < this.miBreakpoints.length) {
                    String tid = this.miBreakpoints[i].getThreadId();
                    if (tid != null && tid.length() > 0) {
                        list.add(this.miBreakpoints[i].getThreadId());
                    }
                    ++i;
                }
                String[] tids = list.toArray(new String[list.size()]);
                int icount = this.miBreakpoints[0].getIgnoreCount();
                String exp = this.miBreakpoints[0].getCondition();
                this.condition = new Condition(icount, exp, tids);
            } else {
                this.condition = new Condition(0, new String(), null);
            }
        }
        return this.condition;
    }

    public boolean isEnabled() throws CDIException {
        return this.enable;
    }

    public boolean isHardware() {
        return this.type == 2;
    }

    public boolean isTemporary() {
        return this.type == 1;
    }

    public void setCondition(ICDICondition newCondition) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        BreakpointManager mgr = session.getBreakpointManager();
        mgr.setCondition((ICDIBreakpoint)this, newCondition);
        this.setCondition0(newCondition);
    }

    public void setCondition0(ICDICondition newCondition) {
        this.condition = newCondition;
    }

    public void setEnabled(boolean on) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        BreakpointManager mgr = session.getBreakpointManager();
        if (!on && this.isEnabled()) {
            mgr.disableBreakpoint(this);
        } else if (on && !this.isEnabled()) {
            mgr.enableBreakpoint(this);
        }
        this.setEnabled0(on);
    }

    public void setEnabled0(boolean on) {
        this.enable = on;
    }

    public ICDILocation getLocation() throws CDIException {
        if (this.fLocation == null && this.miBreakpoints != null && this.miBreakpoints.length > 0) {
            BigInteger addr = BigInteger.ZERO;
            String a = this.miBreakpoints[0].getAddress();
            if (a != null) {
                addr = MIFormat.getBigInteger(a);
            }
            this.fLocation = new Location(this.miBreakpoints[0].getFile(), this.miBreakpoints[0].getFunction(), this.miBreakpoints[0].getLine(), addr);
        }
        return this.fLocation;
    }

    public void setLocation(ICDILocation loc) {
        this.fLocation = loc;
    }
}

