/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.wizards.CProjectPlatformPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectOptionPage;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewManagedProjectWizard
extends NewCProjectWizard {
    protected static final String PREFIX = "MngMakeProjectWizard";
    protected static final String OP_ERROR = "MngMakeProjectWizard.op_error";
    protected static final String WZ_TITLE = "MngMakeProjectWizard.title";
    protected static final String WZ_DESC = "MngMakeProjectWizard.description";
    protected static final String CONF_TITLE = "MngMakeProjectWizard.config.title";
    protected static final String CONF_DESC = "MngMakeProjectWizard.config.desc";
    protected static final String OPTIONS_TITLE = "MngMakeProjectWizard.options.title";
    protected static final String OPTIONS_DESC = "MngMakeProjectWizard.options.desc";
    protected static final String MSG_ADD_NATURE = "MngMakeProjectWizard.message.add_nature";
    protected static final String MSG_ADD_BUILDER = "MngMakeProjectWizard.message.add_builder";
    protected static final String MSG_SAVE = "MngMakeProjectWizard.message.save";
    protected static final String SETTINGS_TITLE = "MngMakeWizardSettings.title";
    protected static final String SETTINGS_DESC = "MngMakeWizardSettings.description";
    protected CProjectPlatformPage projectConfigurationPage;
    protected NewManagedProjectOptionPage optionPage;

    public NewManagedProjectWizard() {
        this(ManagedBuilderUIMessages.getResourceString(WZ_TITLE), ManagedBuilderUIMessages.getResourceString(WZ_DESC));
    }

    public NewManagedProjectWizard(String title, String description) {
        super(title, description);
    }

    public void addPages() {
        super.addPages();
        this.projectConfigurationPage = new CProjectPlatformPage(PREFIX, this);
        this.projectConfigurationPage.setTitle(ManagedBuilderUIMessages.getResourceString(CONF_TITLE));
        this.projectConfigurationPage.setDescription(ManagedBuilderUIMessages.getResourceString(CONF_DESC));
        this.addPage((IWizardPage)this.projectConfigurationPage);
        this.optionPage = new NewManagedProjectOptionPage(PREFIX, this);
        this.optionPage.setTitle(ManagedBuilderUIMessages.getResourceString(OPTIONS_TITLE));
        this.optionPage.setDescription(ManagedBuilderUIMessages.getResourceString(OPTIONS_DESC));
        this.addPage((IWizardPage)this.optionPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IWizardPage[] pages = this.getPages();
        if (pages != null && pages.length == 3) {
            WorkbenchHelp.setHelp((Control)pages[0].getControl(), (String)"org.eclipse.cdt.ui.new_proj_wiz_m_name");
            NewManagedProjectOptionPage optionPage = (NewManagedProjectOptionPage)pages[2];
            optionPage.setupHelpContextIds();
        }
    }

    public void updateProjectTypeProperties() {
        this.optionPage.updateProjectTypeProperties();
    }

    protected void doRun(IProgressMonitor monitor) throws CoreException {
        ManagedBuildInfo info;
        block12: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            super.doRun((IProgressMonitor)new SubProgressMonitor(monitor, 5));
            try {
                monitor.subTask(ManagedBuilderUIMessages.getResourceString(MSG_ADD_NATURE));
                ManagedCProjectNature.addManagedNature((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.subTask(ManagedBuilderUIMessages.getResourceString(MSG_ADD_BUILDER));
                ManagedCProjectNature.addManagedBuilder((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (CoreException e) {
                ManagedBuilderUIPlugin.log(e);
            }
            IManagedProject newManagedProject = null;
            info = null;
            try {
                info = ManagedBuildManager.createBuildInfo((IResource)this.newProject);
                IProjectType parent = this.projectConfigurationPage.getSelectedProjectType();
                newManagedProject = ManagedBuildManager.createManagedProject((IResource)this.newProject, (IProjectType)parent);
                if (newManagedProject == null) break block12;
                IConfiguration[] selectedConfigs = this.projectConfigurationPage.getSelectedConfigurations();
                int i = 0;
                while (i < selectedConfigs.length) {
                    IConfiguration config = selectedConfigs[i];
                    int id = ManagedBuildManager.getRandomNumber();
                    IConfiguration newConfig = newManagedProject.createConfiguration(config, String.valueOf(config.getId()) + "." + id);
                    newConfig.setArtifactName(newManagedProject.getDefaultArtifactName());
                    ++i;
                }
                IConfiguration[] newConfigs = newManagedProject.getConfigurations();
                if (newConfigs.length > 0) {
                    ManagedBuildManager.setDefaultConfiguration((IProject)this.newProject, (IConfiguration)newConfigs[0]);
                    ManagedBuildManager.setSelectedConfiguration((IProject)this.newProject, (IConfiguration)newConfigs[0]);
                }
                ManagedBuildManager.setNewProjectVersion((IProject)this.newProject);
                ICDescriptor desc = null;
                try {
                    desc = CCorePlugin.getDefault().getCProjectDescription(this.newProject, true);
                    desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                    if (newConfigs.length > 0) {
                        IToolChain tc = newConfigs[0].getToolChain();
                        ITargetPlatform targetPlatform = tc.getTargetPlatform();
                        desc.create("org.eclipse.cdt.core.BinaryParser", targetPlatform.getBinaryParserId());
                    }
                }
                catch (CoreException e) {
                    ManagedBuilderUIPlugin.log(e);
                }
            }
            catch (BuildException e) {
                ManagedBuilderUIPlugin.log(e);
            }
        }
        if (this.newProject != null) {
            this.optionPage.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        monitor.subTask(ManagedBuilderUIMessages.getResourceString(MSG_SAVE));
        if (info != null) {
            info.setValid(true);
            ManagedBuildManager.saveBuildInfo((IProject)this.newProject, (boolean)true);
        }
        monitor.done();
    }

    protected void doRunPrologue(IProgressMonitor monitor) {
    }

    protected void doRunEpilogue(IProgressMonitor monitor) {
        IStatus initResult = ManagedBuildManager.initBuildInfoContainer((IResource)this.newProject);
        if (initResult.getCode() != 0) {
            ManagedBuilderUIPlugin.log(initResult);
        }
    }

    public String getProjectID() {
        return ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID;
    }

    public IProjectType getSelectedProjectType() {
        return this.projectConfigurationPage.getSelectedProjectType();
    }
}

