/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.projectconverter;

import java.util.HashMap;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.projectconverter.ConverterMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class UpdateManagedProjectManager {
    private static HashMap fUpdateManagers = new HashMap();
    private static IOverwriteQuery fBackupFileOverwriteQuery = null;
    private static IOverwriteQuery fOpenQuestionQuery = null;
    private static IOverwriteQuery fUpdateProjectQuery = null;
    private ManagedBuildInfo fConvertedInfo = null;
    private boolean fIsInfoReadOnly = false;
    private final IProject fProject;

    private UpdateManagedProjectManager(IProject project) {
        this.fProject = project;
    }

    public static void setBackupFileOverwriteQuery(IOverwriteQuery backupFileOverwriteQuery) {
        fBackupFileOverwriteQuery = backupFileOverwriteQuery;
    }

    public static void setUpdateProjectQuery(IOverwriteQuery updateProjectQuery) {
        fUpdateProjectQuery = updateProjectQuery;
    }

    private static boolean getBooleanFromQueryAnswer(String answer) {
        return "ALL".equalsIgnoreCase(answer) || "YES".equalsIgnoreCase(answer);
    }

    private static synchronized UpdateManagedProjectManager getUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            mngr = UpdateManagedProjectManager.createUpdateManager(project);
        }
        return mngr;
    }

    private static UpdateManagedProjectManager getExistingUpdateManager(IProject project) {
        return (UpdateManagedProjectManager)fUpdateManagers.get(project.getName());
    }

    private static UpdateManagedProjectManager createUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = new UpdateManagedProjectManager(project);
        fUpdateManagers.put(project.getName(), mngr);
        return mngr;
    }

    private static void removeUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            return;
        }
        fUpdateManagers.remove(project.getName());
    }

    protected static PluginVersionIdentifier getManagedBuildInfoVersion(String version) {
        if (version == null) {
            version = "1.2";
        }
        return new PluginVersionIdentifier(version);
    }

    public static boolean isCompatibleProject(IManagedBuildInfo info) {
        PluginVersionIdentifier compVersion;
        if (info == null) {
            return false;
        }
        PluginVersionIdentifier projVersion = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
        return projVersion.isEquivalentTo(compVersion = ManagedBuildManager.getBuildInfoVersion());
    }

    static void backupFile(IFile settingsFile, String suffix, IProgressMonitor monitor, IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null || mngr.fIsInfoReadOnly) {
            return;
        }
        IProject destFolder = project;
        IFile dstFile = destFolder.getFile((IPath)new Path(String.valueOf(settingsFile.getName()) + suffix));
        mngr.backupFile(settingsFile, dstFile, monitor, project, fBackupFileOverwriteQuery);
    }

    private void backupFile(IFile srcFile, IFile dstFile, IProgressMonitor monitor, IProject project, IOverwriteQuery query) {
        try {
            if (dstFile.exists()) {
                boolean shouldUpdate = query != null ? UpdateManagedProjectManager.getBooleanFromQueryAnswer(query.queryOverwrite(dstFile.getFullPath().toString())) : UpdateManagedProjectManager.openQuestion(ConverterMessages.getResourceString("UpdateManagedProjectManager.0"), ConverterMessages.getFormattedString("UpdateManagedProjectManager.1", new String[]{dstFile.getName(), project.getName()}));
                if (shouldUpdate) {
                    dstFile.delete(true, monitor);
                } else {
                    throw new OperationCanceledException(ConverterMessages.getFormattedString("UpdateManagedProjectManager.2", project.getName()));
                }
            }
            srcFile.copy(dstFile.getFullPath(), true, monitor);
        }
        catch (Exception exception) {
            this.fIsInfoReadOnly = true;
        }
    }

    private void restoreFile(String backupFileName, String restoreFileName, IProgressMonitor monitor, IProject project) {
        IProject destFolder = project;
        IFile restoreFile = destFolder.getFile((IPath)new Path(restoreFileName));
        IFile backupFile = destFolder.getFile((IPath)new Path(backupFileName));
        try {
            if (restoreFile.exists()) {
                restoreFile.delete(true, monitor);
            }
            backupFile.copy(restoreFile.getFullPath(), true, monitor);
        }
        catch (Exception exception) {
            this.fIsInfoReadOnly = true;
        }
    }

    private static boolean openQuestion(final String title, final String message) {
        if (fOpenQuestionQuery != null) {
            return UpdateManagedProjectManager.getBooleanFromQueryAnswer(fOpenQuestionQuery.queryOverwrite(message));
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            window = windows[0];
        }
        final Shell shell = window.getShell();
        final boolean[] answer = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                answer[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return answer[0];
    }

    public static ManagedBuildInfo getConvertedManagedBuildInfo(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            return null;
        }
        return mngr.getConvertedManagedBuildInfo();
    }

    private ManagedBuildInfo getConvertedManagedBuildInfo() {
        return this.fConvertedInfo;
    }

    /*
     * Exception decompiling
     */
    private void doProjectUpdate(ManagedBuildInfo info) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 405->409)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateProject(IProject project, ManagedBuildInfo info) throws CoreException {
        try {
            UpdateManagedProjectManager.getUpdateManager(project).doProjectUpdate(info);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            UpdateManagedProjectManager.removeUpdateManager(project);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        UpdateManagedProjectManager.removeUpdateManager(project);
    }
}

