/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControlFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;

public class BuildOptionSettingsPage
extends BuildSettingsPage {
    private Map fieldsMap = new HashMap();
    private IOptionCategory category;
    private boolean isItResourceConfigPage;

    public BuildOptionSettingsPage(IConfiguration configuration, IOptionCategory category) {
        super(configuration);
        this.category = category;
        this.isItResourceConfigPage = false;
    }

    public BuildOptionSettingsPage(IResourceConfiguration resConfig, IOptionCategory category) {
        super(resConfig);
        this.category = category;
        this.isItResourceConfigPage = true;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Object[][] options = this.isItResourceConfigPage ? this.category.getOptions(this.resConfig) : this.category.getOptions(this.configuration);
        int index = 0;
        while (index < options.length) {
            ITool tool = (ITool)options[index][0];
            if (tool == null) break;
            IOption opt = (IOption)options[index][1];
            try {
                switch (opt.getValueType()) {
                    case 2: {
                        StringFieldEditor stringField = new StringFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent());
                        this.addField((FieldEditor)stringField);
                        this.fieldsMap.put(opt.getId(), stringField);
                        break;
                    }
                    case 0: {
                        BooleanFieldEditor booleanField = new BooleanFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent());
                        this.addField((FieldEditor)booleanField);
                        this.fieldsMap.put(opt.getId(), booleanField);
                        break;
                    }
                    case 1: {
                        String sel;
                        try {
                            String selId = opt.getSelectedEnum();
                            sel = opt.getEnumName(selId);
                        }
                        catch (BuildException buildException) {
                            break;
                        }
                        BuildOptionComboFieldEditor comboField = new BuildOptionComboFieldEditor(opt.getId(), opt.getName(), opt.getApplicableValues(), sel, this.getFieldEditorParent());
                        this.addField(comboField);
                        this.fieldsMap.put(opt.getId(), comboField);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        FileListControlFieldEditor listField = new FileListControlFieldEditor(opt.getId(), opt.getName(), this.getFieldEditorParent(), opt.getBrowseType());
                        this.addField(listField);
                        this.fieldsMap.put(opt.getId(), listField);
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
            ++index;
        }
    }

    public boolean isForCategory(IOptionCategory category) {
        if (category != null) {
            return category.equals(this.category);
        }
        return false;
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        Object[][] options = this.isItResourceConfigPage ? this.category.getOptions(this.resConfig) : this.category.getOptions(this.configuration);
        int i = 0;
        while (i < options.length) {
            ITool tool = (ITool)options[i][0];
            if (tool == null) break;
            IOption option = (IOption)options[i][1];
            try {
                switch (option.getValueType()) {
                    case 0: {
                        boolean boolVal = this.getToolSettingsPreferenceStore().getBoolean(option.getId());
                        IOption setOption = this.isItResourceConfigPage ? ManagedBuildManager.setOption((IResourceConfiguration)this.resConfig, (ITool)tool, (IOption)option, (boolean)boolVal) : ManagedBuildManager.setOption((IConfiguration)this.configuration, (ITool)tool, (IOption)option, (boolean)boolVal);
                        if (setOption != option) {
                            this.getToolSettingsPreferenceStore().setValue(setOption.getId(), boolVal);
                            FieldEditor fe = (FieldEditor)this.fieldsMap.get(option.getId());
                            fe.setPreferenceName(setOption.getId());
                        }
                        break;
                    }
                    case 1: {
                        String enumVal = this.getToolSettingsPreferenceStore().getString(option.getId());
                        String enumId = option.getEnumeratedId(enumVal);
                        IOption setOption = this.isItResourceConfigPage ? ManagedBuildManager.setOption((IResourceConfiguration)this.resConfig, (ITool)tool, (IOption)option, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal)) : ManagedBuildManager.setOption((IConfiguration)this.configuration, (ITool)tool, (IOption)option, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                        if (setOption != option) {
                            this.getToolSettingsPreferenceStore().setValue(setOption.getId(), enumVal);
                            FieldEditor fe = (FieldEditor)this.fieldsMap.get(option.getId());
                            fe.setPreferenceName(setOption.getId());
                        }
                        break;
                    }
                    case 2: {
                        String strVal = this.getToolSettingsPreferenceStore().getString(option.getId());
                        IOption setOption = this.isItResourceConfigPage ? ManagedBuildManager.setOption((IResourceConfiguration)this.resConfig, (ITool)tool, (IOption)option, (String)strVal) : ManagedBuildManager.setOption((IConfiguration)this.configuration, (ITool)tool, (IOption)option, (String)strVal);
                        if (setOption != option) {
                            this.getToolSettingsPreferenceStore().setValue(setOption.getId(), strVal);
                            FieldEditor fe = (FieldEditor)this.fieldsMap.get(option.getId());
                            fe.setPreferenceName(setOption.getId());
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        String listStr = this.getToolSettingsPreferenceStore().getString(option.getId());
                        String[] listVal = BuildToolsSettingsStore.parseString(listStr);
                        IOption setOption = this.isItResourceConfigPage ? ManagedBuildManager.setOption((IResourceConfiguration)this.resConfig, (ITool)tool, (IOption)option, (String[])listVal) : ManagedBuildManager.setOption((IConfiguration)this.configuration, (ITool)tool, (IOption)option, (String[])listVal);
                        if (setOption != option) {
                            this.getToolSettingsPreferenceStore().setValue(setOption.getId(), listStr);
                            FieldEditor fe = (FieldEditor)this.fieldsMap.get(option.getId());
                            fe.setPreferenceName(setOption.getId());
                        }
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
            ++i;
        }
        return ok;
    }

    public void updateFields() {
        Collection fieldsList = this.fieldsMap.values();
        Iterator iter = fieldsList.iterator();
        while (iter.hasNext()) {
            FieldEditor editor = (FieldEditor)iter.next();
            editor.load();
        }
    }

    public void storeSettings() {
        super.performOk();
    }
}

