/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ElfBinaryArchive
extends BinaryFile
implements IBinaryParser.IBinaryArchive {
    ArrayList children;

    public ElfBinaryArchive(IBinaryParser parser, IPath p) throws IOException {
        super(parser, p, 8);
        new AR(p.toOSString()).dispose();
        this.children = new ArrayList(5);
    }

    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            AR ar = null;
            try {
                ar = new AR(this.getPath().toOSString());
                AR.ARHeader[] headers = ar.getHeaders();
                this.addArchiveMembers(headers, this.children);
            }
            catch (IOException iOException) {}
            if (ar != null) {
                ar.dispose();
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }

    protected void addArchiveMembers(AR.ARHeader[] headers, ArrayList children2) {
        int i = 0;
        while (i < headers.length) {
            ElfBinaryObject bin = new ElfBinaryObject(this.getBinaryParser(), this.getPath(), headers[i]);
            this.children.add(bin);
            ++i;
        }
    }
}

