/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICThread;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;

public abstract class CBreakpoint
extends Breakpoint
implements ICBreakpoint,
IDebugEventSetListener {
    private Map fFilteredThreadsByTarget = new HashMap(10);

    public CBreakpoint() {
    }

    public CBreakpoint(final IResource resource, final String markerType, final Map attributes, final boolean add) throws CoreException {
        this();
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CBreakpoint.this.setMarker(resource.createMarker(markerType));
                CBreakpoint.this.ensureMarker().setAttributes(attributes);
                CBreakpoint.this.setAttribute("message", CBreakpoint.this.getMarkerMessage());
                CBreakpoint.this.register(add);
            }
        };
        this.run(wr);
    }

    public void createMarker(final IResource resource, final String markerType, final Map attributes, final boolean add) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CBreakpoint.this.setMarker(resource.createMarker(markerType));
                CBreakpoint.this.ensureMarker().setAttributes(attributes);
                CBreakpoint.this.setAttribute("message", CBreakpoint.this.getMarkerMessage());
                CBreakpoint.this.register(add);
            }
        };
        this.run(wr);
    }

    public String getModelIdentifier() {
        return CDIDebugModel.getPluginIdentifier();
    }

    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.installCount", 0) > 0;
    }

    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.condition", "");
    }

    public void setCondition(String condition) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.condition", condition);
        this.setAttribute("message", this.getMarkerMessage());
    }

    public int getIgnoreCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.ignoreCount", 0);
    }

    public void setIgnoreCount(int ignoreCount) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.ignoreCount", ignoreCount);
        this.setAttribute("message", this.getMarkerMessage());
    }

    public String getThreadId() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.threadId", null);
    }

    public void setThreadId(String threadId) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.threadId", threadId);
    }

    public String getSourceHandle() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.sourceHandle", null);
    }

    public void setSourceHandle(String sourceHandle) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
    }

    public void handleDebugEvents(DebugEvent[] events) {
    }

    protected void run(IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        }
    }

    protected abstract String getMarkerMessage() throws CoreException;

    public synchronized void resetInstallCount() throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.installCount", 0);
    }

    public synchronized int incrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        this.setAttribute("org.eclipse.cdt.debug.core.installCount", ++count);
        return count;
    }

    public int getInstallCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.installCount", 0);
    }

    public synchronized int decrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        if (count > 0) {
            this.setAttribute("org.eclipse.cdt.debug.core.installCount", --count);
        }
        return count;
    }

    protected IMarker ensureMarker() throws DebugException {
        return super.ensureMarker();
    }

    protected void setAttribute(String attributeName, Object value) throws CoreException {
        super.setAttribute(attributeName, value);
    }

    public boolean isConditional() throws CoreException {
        return this.getCondition() != null && this.getCondition().trim().length() > 0 || this.getIgnoreCount() > 0;
    }

    protected String getConditionText() throws CoreException {
        String condition;
        StringBuffer sb = new StringBuffer();
        int ignoreCount = this.getIgnoreCount();
        if (ignoreCount > 0) {
            sb.append(MessageFormat.format(BreakpointMessages.getString("CBreakpoint.1"), new Integer(ignoreCount)));
        }
        if ((condition = this.getCondition()) != null && condition.length() > 0) {
            sb.append(MessageFormat.format(BreakpointMessages.getString("CBreakpoint.2"), condition));
        }
        return sb.toString();
    }

    public ICDebugTarget[] getTargetFilters() throws CoreException {
        Set set = this.fFilteredThreadsByTarget.keySet();
        return set.toArray(new ICDebugTarget[set.size()]);
    }

    public ICThread[] getThreadFilters(ICDebugTarget target) throws CoreException {
        Set set = (Set)this.fFilteredThreadsByTarget.get(target);
        return set != null ? set.toArray(new ICThread[set.size()]) : null;
    }

    public void removeTargetFilter(ICDebugTarget target) throws CoreException {
        if (this.fFilteredThreadsByTarget.containsKey(target)) {
            this.fFilteredThreadsByTarget.remove(target);
        }
    }

    public void removeThreadFilters(ICThread[] threads) throws CoreException {
        Set set;
        IDebugTarget target;
        if (threads != null && threads.length > 0 && this.fFilteredThreadsByTarget.containsKey(target = threads[0].getDebugTarget()) && (set = (Set)this.fFilteredThreadsByTarget.get(target)) != null) {
            set.removeAll(Arrays.asList(threads));
            if (set.isEmpty()) {
                this.fFilteredThreadsByTarget.remove(target);
            }
        }
    }

    public void setTargetFilter(ICDebugTarget target) throws CoreException {
        this.fFilteredThreadsByTarget.put(target, null);
    }

    public void setThreadFilters(ICThread[] threads) throws CoreException {
        if (threads != null && threads.length > 0) {
            this.fFilteredThreadsByTarget.put(threads[0].getDebugTarget(), new HashSet<ICThread>(Arrays.asList(threads)));
        }
    }

    public void fireChanged() {
        if (this.markerExists()) {
            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this);
        }
    }
}

