/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.opentype;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeDialog;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeAction
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        String message;
        String title;
        Object[] elements;
        TypeSearchScope fScope = new TypeSearchScope(true);
        if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)fScope)) {
            IRunnableWithProgress runnable = new IRunnableWithProgress((ITypeSearchScope)fScope){
                private final /* synthetic */ ITypeSearchScope val$fScope;
                {
                    this.val$fScope = iTypeSearchScope;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.updateCache((ITypeSearchScope)this.val$fScope, (IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                String title2 = OpenTypeMessages.getString("OpenTypeAction.exception.title");
                String message2 = OpenTypeMessages.getString("OpenTypeAction.exception.message");
                ExceptionHandler.handle(e, title2, message2);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if ((elements = AllTypesCache.getAllTypes()).length == 0) {
            String title3 = OpenTypeMessages.getString("OpenTypeAction.notypes.title");
            String message3 = OpenTypeMessages.getString("OpenTypeAction.notypes.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title3, (String)message3);
            return;
        }
        OpenTypeDialog dialog = new OpenTypeDialog(this.getShell());
        dialog.setElements(elements);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        ITypeInfo info = (ITypeInfo)dialog.getFirstResult();
        if (info == null) {
            return;
        }
        ITypeReference location = info.getResolvedReference();
        if (location == null) {
            final ITypeInfo[] typesToResolve = new ITypeInfo[]{info};
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.resolveTypeLocation((ITypeInfo)typesToResolve[0], (IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                String title4 = OpenTypeMessages.getString("OpenTypeAction.exception.title");
                String message4 = OpenTypeMessages.getString("OpenTypeAction.exception.message");
                ExceptionHandler.handle(e, title4, message4);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            location = info.getResolvedReference();
        }
        if (location == null) {
            title = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            message = OpenTypeMessages.getFormattedString("OpenTypeAction.errorTypeNotFound", info.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else if (!this.openTypeInEditor(location)) {
            title = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            message = OpenTypeMessages.getFormattedString("OpenTypeAction.errorOpenEditor", location.getPath().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected Shell getShell() {
        return CUIPlugin.getActiveWorkbenchShell();
    }

    private boolean openTypeInEditor(ITypeReference location) {
        ITranslationUnit unit = location.getTranslationUnit();
        IEditorPart editorPart = null;
        try {
            IPath path;
            if (unit != null) {
                editorPart = EditorUtility.openInEditor(unit);
            }
            if (editorPart == null && (path = location.getLocation()) != null) {
                FileStorage storage = new FileStorage(path);
                editorPart = EditorUtility.openInEditor(storage);
            }
            if (editorPart != null && editorPart instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)editorPart;
                editor.selectAndReveal(location.getOffset(), location.getLength());
                return true;
            }
        }
        catch (CModelException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
            return false;
        }
        return false;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

