/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.wizards.NewElementWizardPage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.ui.wizards.IPathEntryContainerPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CPathContainerDefaultPage
extends NewElementWizardPage
implements IPathEntryContainerPage {
    private StringDialogField fEntryField;
    private ArrayList fUsedPaths;

    public CPathContainerDefaultPage() {
        super("CPathContainerDefaultPage");
        this.setTitle(CPathEntryMessages.getString("CPathContainerDefaultPage.title"));
        this.setDescription(CPathEntryMessages.getString("CPathContainerDefaultPage.description"));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fUsedPaths = new ArrayList();
        this.fEntryField = new StringDialogField();
        this.fEntryField.setLabelText(CPathEntryMessages.getString("CPathContainerDefaultPage.path.label"));
        this.fEntryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CPathContainerDefaultPage.this.validatePath();
            }
        });
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo status = new StatusInfo();
        String str = this.fEntryField.getText();
        if (str.length() == 0) {
            status.setError(CPathEntryMessages.getString("CPathContainerDefaultPage.path.error.enterpath"));
        } else if (!Path.ROOT.isValidPath(str)) {
            status.setError(CPathEntryMessages.getString("CPathContainerDefaultPage.path.error.invalidpath"));
        } else {
            Path path = new Path(str);
            if (path.segmentCount() == 0) {
                status.setError(CPathEntryMessages.getString("CPathContainerDefaultPage.path.error.needssegment"));
            } else if (this.fUsedPaths.contains(path)) {
                status.setError(CPathEntryMessages.getString("CPathContainerDefaultPage.path.error.alreadyexists"));
            }
        }
        this.updateStatus(status);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fEntryField.doFillIntoGrid(composite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fEntryField.getTextControl(null));
        this.fEntryField.setFocus();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public boolean finish() {
        return true;
    }

    public IContainerEntry[] getNewContainers() {
        return new IContainerEntry[]{CoreModel.newContainerEntry((IPath)new Path(this.fEntryField.getText()))};
    }

    public void initialize(ICProject project, IPathEntry[] currentEntries) {
        int i = 0;
        while (i < currentEntries.length) {
            IPathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    public void setSelection(IContainerEntry containerEntry) {
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
            this.fEntryField.setText(containerEntry.getPath().toString());
        } else {
            this.fEntryField.setText("");
        }
    }
}

