/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.codemanipulation.AddIncludesOperation;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class AddIncludeOnSelectionAction
extends Action
implements IUpdate {
    private ITextEditor fEditor;
    private IRequiredInclude[] fRequiredIncludes;
    private String[] fUsings;

    public AddIncludeOnSelectionAction(ITextEditor editor) {
        super(CEditorMessages.getString("AddIncludeOnSelection.label"));
        this.setToolTipText(CEditorMessages.getString("AddIncludeOnSelection.tooltip"));
        this.setDescription(CEditorMessages.getString("AddIncludeOnSelection.description"));
        this.fEditor = editor;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.add_includes_on_selection_action_context");
    }

    private void addInclude(ITranslationUnit tu) {
        AddIncludesOperation op = new AddIncludesOperation(tu, this.fRequiredIncludes, this.fUsings, false);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(op), op.getScheduleRule());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.getString("AddIncludeOnSelection.error.message1"), null);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected ITranslationUnit getTranslationUnit() {
        IWorkingCopy unit = null;
        if (this.fEditor != null) {
            IEditorInput editorInput = this.fEditor.getEditorInput();
            unit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        }
        return unit;
    }

    private Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    public void run() {
        ITranslationUnit tu = this.getTranslationUnit();
        if (tu != null) {
            this.extractIncludes(this.fEditor);
            this.addInclude(tu);
        }
        this.fUsings = null;
        this.fRequiredIncludes = null;
    }

    private void extractIncludes(ITextEditor editor) {
        if (editor == null) {
            return;
        }
        ISelection s = editor.getSelectionProvider().getSelection();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (s.isEmpty() || !(s instanceof ITextSelection) || doc == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)s;
        try {
            IMatch[] matches;
            ITypeInfo[] typeInfos;
            IRegion region = CWordFinder.findWord(doc, selection.getOffset());
            if (region == null || region.getLength() == 0) {
                return;
            }
            String name = doc.get(region.getOffset(), region.getLength());
            if (name.length() == 0) {
                return;
            }
            IFunctionSummary fs = this.findContribution(name);
            if (fs != null) {
                this.fRequiredIncludes = fs.getIncludes();
                String ns = fs.getNamespace();
                if (ns != null && ns.length() > 0) {
                    this.fUsings = new String[]{fs.getNamespace()};
                }
            }
            if (this.fRequiredIncludes == null && this.fUsings == null && (typeInfos = this.findTypeInfos(name)) != null && typeInfos.length > 0) {
                this.selectResult(typeInfos, name, this.getShell());
            }
            if (this.fRequiredIncludes == null && this.fUsings == null && (matches = this.findMatches(name)) != null && matches.length > 0) {
                this.selectResult(matches, name, this.getShell());
            }
        }
        catch (BadLocationException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message3"), (String)(String.valueOf(CEditorMessages.getString("AddIncludeOnSelection.error.message4")) + e.getMessage()));
        }
    }

    private IFunctionSummary findContribution(final String name) {
        final IFunctionSummary[] fs = new IFunctionSummary[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ICHelpInvocationContext context = new ICHelpInvocationContext(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IProject getProject() {
                        ITranslationUnit u = this.getTranslationUnit();
                        if (u != null) {
                            return u.getCProject().getProject();
                        }
                        return null;
                    }

                    public ITranslationUnit getTranslationUnit() {
                        return 1.access$0(this.this$1).getTranslationUnit();
                    }
                };
                fs[0] = CHelpProviderManager.getDefault().getFunctionInfo(context, name);
            }

            static /* synthetic */ AddIncludeOnSelectionAction access$0(1 var0) {
                return var0.AddIncludeOnSelectionAction.this;
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.getString("AddIncludeOnSelection.error.message1"), null);
        }
        catch (InterruptedException interruptedException) {}
        return fs[0];
    }

    private ITypeInfo[] findTypeInfos(final String name) {
        final ITypeInfo[][] infos = new ITypeInfo[1][];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ITranslationUnit unit = AddIncludeOnSelectionAction.this.getTranslationUnit();
                int[] types = new int[]{64, 66, 65, 63, 78};
                TypeSearchScope scope = new TypeSearchScope();
                scope.add(unit.getCProject().getProject());
                if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)scope)) {
                    AllTypesCache.updateCache((ITypeSearchScope)scope, (IProgressMonitor)monitor);
                }
                ITypeInfo[] results = null;
                if (!monitor.isCanceled()) {
                    results = AllTypesCache.getTypes((ITypeSearchScope)scope, (IQualifiedTypeName)new QualifiedTypeName(name), (int[])types, (boolean)true);
                    if (!monitor.isCanceled()) {
                        int i = 0;
                        while (i < results.length) {
                            ITypeInfo info = results[i];
                            AllTypesCache.resolveTypeLocation((ITypeInfo)info, (IProgressMonitor)monitor);
                            if (monitor.isCanceled()) break;
                            ++i;
                        }
                    }
                }
                infos[0] = results;
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.getString("AddIncludeOnSelection.error.message1"), null);
        }
        catch (InterruptedException interruptedException) {}
        return infos[0];
    }

    private IMatch[] findMatches(final String name) {
        final BasicSearchResultCollector searchResultCollector = new BasicSearchResultCollector();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ICProject cproject = AddIncludeOnSelectionAction.this.getTranslationUnit().getCProject();
                ICSearchScope scope = SearchEngine.createCSearchScope((ICElement[])new ICElement[]{cproject}, (boolean)true);
                OrPattern orPattern = new OrPattern();
                orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                SearchEngine searchEngine = new SearchEngine();
                searchEngine.setWaitingPolicy(1);
                searchEngine.search(CUIPlugin.getWorkspace(), (ICSearchPattern)orPattern, scope, (ICSearchResultCollector)searchResultCollector, true);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.getString("AddIncludeOnSelection.error.message1"), null);
        }
        catch (InterruptedException interruptedException) {}
        Set set = searchResultCollector.getSearchResults();
        if (set != null) {
            IMatch[] matches = new IMatch[set.size()];
            set.toArray(matches);
            return matches;
        }
        return null;
    }

    private void selectResult(ITypeInfo[] results, String name, Shell shell) {
        int nResults = results.length;
        ITranslationUnit unit = this.getTranslationUnit();
        if (nResults == 0) {
            return;
        }
        int occurences = 0;
        int index = 0;
        int i = 0;
        while (i < results.length) {
            if (name.equals(results[i].getName())) {
                ++occurences;
                index = i;
            }
            ++i;
        }
        if (occurences == 1 || results.length == 1) {
            ITypeInfo curr = results[index];
            IRequiredInclude include = this.getRequiredInclude(curr, unit);
            if (include != null) {
                this.fRequiredIncludes = new IRequiredInclude[]{include};
            }
            if (curr.hasEnclosedTypes()) {
                ITypeInfo[] ns = curr.getEnclosedTypes();
                this.fUsings = new String[ns.length];
                int j = 0;
                while (j < this.fUsings.length) {
                    this.fUsings[j] = ns[j].getName();
                    ++j;
                }
            }
            return;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new TypeInfoLabelProvider(1));
        dialog.setElements((Object[])results);
        dialog.setTitle(CEditorMessages.getString("AddIncludeOnSelection.label"));
        dialog.setMessage(CEditorMessages.getString("AddIncludeOnSelection.description"));
        if (dialog.open() == 0) {
            ITypeInfo[] selects = (ITypeInfo[])dialog.getResult();
            this.fRequiredIncludes = new IRequiredInclude[selects.length];
            ArrayList<String> usings = new ArrayList<String>(selects.length);
            int i2 = 0;
            while (i2 < this.fRequiredIncludes.length) {
                IRequiredInclude include = this.getRequiredInclude(selects[i2], unit);
                if (include != null) {
                    this.fRequiredIncludes[i2] = include;
                    if (selects[i2].hasEnclosedTypes()) {
                        ITypeInfo[] ns = results[0].getEnclosedTypes();
                        int j = 0;
                        while (j < ns.length) {
                            usings.add(ns[j].getName());
                            ++j;
                        }
                    }
                } else {
                    this.fRequiredIncludes[i2] = new RequiredIncludes("");
                }
                ++i2;
            }
            if (!usings.isEmpty()) {
                this.fUsings = new String[usings.size()];
                usings.toArray(this.fUsings);
            }
        }
    }

    private IRequiredInclude getRequiredInclude(ITypeInfo curr, ITranslationUnit tu) {
        ITypeReference ref = curr.getResolvedReference();
        if (ref != null) {
            IPath typeLocation = ref.getLocation();
            IProject project = tu.getCProject().getProject();
            IPath projectLocation = project.getLocation();
            IPath headerLocation = tu.getResource().getLocation();
            boolean isSystemIncludePath = false;
            IPath includePath = PathUtil.makeRelativePathToProjectIncludes((IPath)typeLocation, (IProject)project);
            if (includePath != null && !projectLocation.isPrefixOf(typeLocation)) {
                isSystemIncludePath = true;
            } else if (projectLocation.isPrefixOf(typeLocation) && projectLocation.isPrefixOf(headerLocation)) {
                includePath = PathUtil.makeRelativePath((IPath)typeLocation, (IPath)headerLocation.removeLastSegments(1));
            }
            if (includePath == null) {
                includePath = typeLocation;
            }
            return new RequiredIncludes(includePath.toString(), isSystemIncludePath);
        }
        return null;
    }

    private void selectResult(IMatch[] results, String name, Shell shell) {
        int nResults = results.length;
        if (nResults == 0) {
            return;
        }
        int occurences = 0;
        int index = 0;
        int i = 0;
        while (i < results.length) {
            IMatch curr = results[i];
            if (curr.getName().startsWith(name)) {
                ++occurences;
                index = i;
            }
            ++i;
        }
        if (occurences == 1 || results.length == 1) {
            IMatch curr = results[index];
            this.fRequiredIncludes = new IRequiredInclude[1];
            this.fRequiredIncludes[0] = new RequiredIncludes(curr.getLocation().lastSegment());
            String parentName = curr.getParentName();
            if (parentName != null && parentName.length() > 0) {
                this.fUsings = new String[]{parentName};
            }
            return;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new CSearchResultLabelProvider(null));
        dialog.setElements((Object[])results);
        dialog.setTitle(CEditorMessages.getString("AddIncludeOnSelection.label"));
        dialog.setMessage(CEditorMessages.getString("AddIncludeOnSelection.description"));
        if (dialog.open() == 0) {
            IMatch[] selects = (IMatch[])dialog.getResult();
            this.fRequiredIncludes = new IRequiredInclude[selects.length];
            ArrayList<String> usings = new ArrayList<String>(selects.length);
            int i2 = 0;
            while (i2 < this.fRequiredIncludes.length) {
                this.fRequiredIncludes[i2] = new RequiredIncludes(selects[i2].getLocation().lastSegment());
                String parentName = selects[i2].getParentName();
                if (parentName != null && parentName.length() > 0) {
                    usings.add(parentName);
                }
                ++i2;
            }
            if (!usings.isEmpty()) {
                this.fUsings = new String[usings.size()];
                usings.toArray(this.fUsings);
            }
        }
    }

    public void setContentEditor(ITextEditor editor) {
        this.fEditor = editor;
    }

    public void update() {
        this.setEnabled(true);
    }

    class RequiredIncludes
    implements IRequiredInclude {
        String name;
        boolean isStandard;

        RequiredIncludes(String n) {
            this.name = n;
            this.isStandard = true;
        }

        RequiredIncludes(String n, boolean isStandard) {
            this.name = n;
            this.isStandard = isStandard;
        }

        public String getIncludeName() {
            return this.name;
        }

        public boolean isStandard() {
            return this.isStandard;
        }
    }
}

