/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplatePosition;
import org.eclipse.core.runtime.CoreException;

public class TemplateTranslator {
    private static final int TEXT = 0;
    private static final int ESCAPE = 1;
    private static final int IDENTIFIER = 2;
    private static final char ESCAPE_CHARACTER = '$';
    private static final char IDENTIFIER_BEGIN = '{';
    private static final char IDENTIFIER_END = '}';
    private final StringBuffer fBuffer = new StringBuffer();
    private final Vector fOffsets = new Vector();
    private final Vector fLengths = new Vector();
    private int fState;
    private String fErrorMessage;

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public TemplateBuffer translate(String string) throws CoreException {
        this.fBuffer.setLength(0);
        this.fOffsets.clear();
        this.fLengths.clear();
        this.fState = 0;
        this.fErrorMessage = null;
        if (!this.parse(string)) {
            return null;
        }
        switch (this.fState) {
            case 0: {
                break;
            }
            case 1: {
                this.fErrorMessage = TemplateMessages.getString("TemplateTranslator.error.incomplete.variable");
                this.fBuffer.append('$');
                return null;
            }
            case 2: {
                this.fErrorMessage = TemplateMessages.getString("TemplateTranslator.error.incomplete.variable");
                this.fBuffer.append('$');
                return null;
            }
        }
        int[] offsets = new int[this.fOffsets.size()];
        int[] lengths = new int[this.fLengths.size()];
        int i = 0;
        while (i < this.fOffsets.size()) {
            offsets[i] = (Integer)this.fOffsets.get(i);
            lengths[i] = (Integer)this.fLengths.get(i);
            ++i;
        }
        String translatedString = this.fBuffer.toString();
        TemplatePosition[] variables = TemplateTranslator.findVariables(translatedString, offsets, lengths);
        return new TemplateBuffer(translatedString, variables);
    }

    private static TemplatePosition[] findVariables(String string, int[] offsets, int[] lengths) {
        HashMap<String, Vector<Integer>> map = new HashMap<String, Vector<Integer>>();
        int i = 0;
        while (i != offsets.length) {
            int offset = offsets[i];
            int length = lengths[i];
            String content = string.substring(offset, offset + length);
            Vector<Integer> vector = (Vector<Integer>)map.get(content);
            if (vector == null) {
                vector = new Vector<Integer>();
                map.put(content, vector);
            }
            vector.add(new Integer(offset));
            ++i;
        }
        TemplatePosition[] variables = new TemplatePosition[map.size()];
        int k = 0;
        Set keys = map.keySet();
        Iterator i2 = keys.iterator();
        while (i2.hasNext()) {
            String name = (String)i2.next();
            Vector vector = (Vector)map.get(name);
            int[] offsets_ = new int[vector.size()];
            int j = 0;
            while (j != offsets_.length) {
                offsets_[j] = (Integer)vector.get(j);
                ++j;
            }
            variables[k] = new TemplatePosition(name, name, offsets_, name.length());
            ++k;
        }
        return variables;
    }

    private boolean parse(String string) {
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            block0 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case '$': {
                            this.fState = 1;
                            break block0;
                        }
                    }
                    this.fBuffer.append(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case '$': {
                            this.fBuffer.append(ch);
                            this.fState = 0;
                            break block0;
                        }
                        case '{': {
                            this.fOffsets.add(new Integer(this.fBuffer.length()));
                            this.fState = 2;
                            break block0;
                        }
                    }
                    this.fErrorMessage = TemplateMessages.getString("TemplateTranslator.error.incomplete.variable");
                    this.fBuffer.append('$');
                    this.fBuffer.append(ch);
                    this.fState = 0;
                    return false;
                }
                case 2: {
                    switch (ch) {
                        case '}': {
                            int offset = (Integer)this.fOffsets.get(this.fOffsets.size() - 1);
                            this.fLengths.add(new Integer(this.fBuffer.length() - offset));
                            this.fState = 0;
                            break block0;
                        }
                    }
                    if (!Character.isUnicodeIdentifierStart(ch) && !Character.isUnicodeIdentifierPart(ch)) {
                        this.fErrorMessage = TemplateMessages.getString("TemplateTranslator.error.invalid.identifier");
                        return false;
                    }
                    this.fBuffer.append(ch);
                }
            }
            ++i;
        }
        return true;
    }
}

