/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Control;

public class LevelTreeContentProvider
extends CSearchContentProvider
implements ITreeContentProvider {
    private AbstractTreeViewer fTreeViewer;
    private Map fChildrenMap;
    private CElementContentProvider fContentProvider;
    private static int[][] C_ELEMENT_TYPES = new int[][]{{64}, {60, 61}, {12}, {11}, {10}};
    private static int[][] RESOURCE_TYPES = new int[][]{new int[0], {1}, {2}, {4}, {8}};
    private static final int MAX_LEVEL = C_ELEMENT_TYPES.length - 1;
    private int fCurrentLevel;
    public static final int LEVEL_CLASS = 1;
    public static final int LEVEL_FILE = 2;
    public static final int LEVEL_FOLDER = 3;
    public static final int LEVEL_PROJECT = 4;

    public LevelTreeContentProvider(AbstractTreeViewer viewer, int level) {
        this.fTreeViewer = viewer;
        this.fCurrentLevel = level;
        this.fContentProvider = new CElementContentProvider();
    }

    public Object getParent(Object child) {
        Object possibleParent;
        block13: {
            block12: {
                possibleParent = null;
                if (child instanceof CSearchMatch) {
                    BasicSearchMatch tempMatch = ((CSearchMatch)((Object)child)).getSearchMatch();
                    ICElement cTransUnit = CCorePlugin.getDefault().getCoreModel().create(tempMatch.getResource());
                    if (cTransUnit instanceof ITranslationUnit) {
                        try {
                            child = ((ITranslationUnit)cTransUnit).getElementAtOffset(tempMatch.startOffset);
                        }
                        catch (CModelException cModelException) {}
                    }
                    if (child == null) {
                        possibleParent = cTransUnit;
                    }
                }
                if (child != null) {
                    possibleParent = this.internalGetParent(child);
                }
                if (!(possibleParent instanceof ICElement)) break block12;
                ICElement cElement = (ICElement)possibleParent;
                int j = this.fCurrentLevel;
                while (j < MAX_LEVEL + 1) {
                    int i = 0;
                    while (i < C_ELEMENT_TYPES[j].length) {
                        if (cElement.getElementType() == C_ELEMENT_TYPES[j][i]) {
                            return null;
                        }
                        ++i;
                    }
                    ++j;
                }
                break block13;
            }
            if (!(possibleParent instanceof IResource)) break block13;
            IResource resource = (IResource)possibleParent;
            int j = this.fCurrentLevel;
            while (j < MAX_LEVEL + 1) {
                int i = 0;
                while (i < RESOURCE_TYPES[j].length) {
                    if (resource.getType() == RESOURCE_TYPES[j][i]) {
                        return null;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return possibleParent;
    }

    private Object internalGetParent(Object child) {
        Object parent = this.fContentProvider.getParent(child);
        if (parent == null && child instanceof CSearchMatch) {
            BasicSearchMatch match = ((CSearchMatch)((Object)child)).getSearchMatch();
            IPath location = match.getLocation();
            return location;
        }
        return parent;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    protected synchronized void initialize(CSearchResult result) {
        super.initialize(result);
        this.fChildrenMap = new HashMap();
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                this.insert(elements[i], false);
                ++i;
            }
        }
    }

    protected void insert(Object child, boolean refreshViewer) {
        Object parent = this.getMatchParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.fTreeViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fTreeViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild((Object)this._result, child) && refreshViewer) {
            this.fTreeViewer.add((Object)this._result, child);
        }
    }

    private Object getMatchParent(Object child) {
        Match[] m = null;
        if (child instanceof String) {
            m = this._result.getMatches(child);
        }
        if (m.length > 0) {
            return this.getParent(m[0]);
        }
        return null;
    }

    private boolean insertChild(Object parent, Object child) {
        HashSet<Object> children = (HashSet<Object>)this.fChildrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.fChildrenMap.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.fTreeViewer.refresh(element);
            }
        } else if (this._result.getMatchCount(element) == 0) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, (Object)this._result);
                if (refreshViewer) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.fTreeViewer.refresh(element);
        }
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        if (this._result == null) {
            return;
        }
        int i = 0;
        while (i < updatedElements.length) {
            if (this._result.getMatchCount(updatedElements[i]) > 0) {
                this.insert(updatedElements[i], true);
            } else {
                this.remove(updatedElements[i], true);
            }
            ++i;
        }
    }

    public void clear() {
        this.initialize(this._result);
        this.fTreeViewer.refresh();
    }

    public void setLevel(int level) {
        this.fCurrentLevel = level;
        Control control = this.fTreeViewer.getControl();
        if (control != null) {
            control.setRedraw(false);
        }
        this.initialize(this._result);
        this.fTreeViewer.refresh();
        if (control != null) {
            control.setRedraw(true);
        }
    }
}

