/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MakeTargetDialog
extends Dialog {
    protected MessageLine fStatusLine;
    private static final String TARGET_PREFIX = "TargetBlock";
    private static final String TARGET_NAME_LABEL = "TargetBlock.target.label";
    private static final String BUILD_ARGUMENT_PREFIX = "BuildTarget";
    private static final String BUILD_ARGUMENT_GROUP = "BuildTarget.target.group_label";
    private static final String BUILD_ARGUMENT_LABEL = "BuildTarget.target.label";
    private static final String SETTING_PREFIX = "SettingsBlock";
    private static final String MAKE_SETTING_GROUP = "SettingsBlock.makeSetting.group_label";
    private static final String MAKE_SETTING_STOP_ERROR = "SettingsBlock.makeSetting.stopOnError";
    private static final String MAKE_CMD_GROUP = "SettingsBlock.makeCmd.group_label";
    private static final String MAKE_CMD_USE_DEFAULT = "SettingsBlock.makeCmd.use_default";
    private static final String MAKE_CMD_LABEL = "SettingsBlock.makeCmd.label";
    Text targetNameText;
    Button stopOnErrorButton;
    Button runAllBuildersButton;
    Text commandText;
    Button defButton;
    Text targetText;
    IMakeTargetManager fTargetManager;
    IContainer fContainer;
    private IPath buildCommand;
    private boolean isDefaultCommand;
    private boolean isStopOnError;
    private boolean runAllBuilders = true;
    private String buildArguments;
    private String targetString;
    private String targetName;
    private String targetBuildID;
    protected IMakeTarget fTarget;
    private boolean initializing = true;

    public MakeTargetDialog(Shell parentShell, IMakeTarget target) throws CoreException {
        this(parentShell, target.getContainer());
        this.fTarget = target;
        this.isStopOnError = target.isStopOnError();
        this.isDefaultCommand = target.isDefaultBuildCmd();
        this.buildCommand = target.getBuildCommand();
        this.buildArguments = target.getBuildArguments();
        this.targetName = target.getName();
        this.targetString = target.getBuildTarget();
        this.targetBuildID = target.getTargetBuilderID();
        this.runAllBuilders = target.runAllBuilders();
    }

    public MakeTargetDialog(Shell parentShell, IContainer container) throws CoreException {
        super(parentShell);
        this.fContainer = container;
        this.fTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        String[] id = this.fTargetManager.getTargetBuilders(container.getProject());
        if (id.length == 0) {
            throw new CoreException((IStatus)new Status(4, MakeUIPlugin.getUniqueIdentifier(), -1, MakeUIPlugin.getResourceString("MakeTargetDialog.exception.noTargetBuilderOnProject"), null));
        }
        this.targetBuildID = id[0];
        IMakeBuilderInfo buildInfo = MakeCorePlugin.createBuildInfo((IProject)container.getProject(), (String)this.fTargetManager.getBuilderID(this.targetBuildID));
        this.isStopOnError = buildInfo.isStopOnError();
        this.isDefaultCommand = buildInfo.isDefaultBuildCmd();
        this.buildCommand = buildInfo.getBuildCommand();
        this.buildArguments = buildInfo.getBuildArguments();
        this.targetString = buildInfo.getIncrementalBuildTarget();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.getTitle());
        super.configureShell(newShell);
    }

    private String getTitle() {
        String title = this.fTarget == null ? MakeUIPlugin.getResourceString("MakeTargetDialog.title.createMakeTarget") : MakeUIPlugin.getResourceString("MakeTargetDialog.title.modifyMakeTarget");
        return title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createNameControl(composite);
        this.createTargetControl(composite);
        this.createBuildCmdControls(composite);
        this.createSettingControls(composite);
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fStatusLine.setLayoutData(gd);
        this.initializing = false;
        return composite;
    }

    protected void createNameControl(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)2);
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        composite.setLayoutData((Object)gd);
        Label label = ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString(TARGET_NAME_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.targetNameText = ControlFactory.createTextField((Composite)composite, (int)2052);
        ((GridData)this.targetNameText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetNameText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.targetNameText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                String newName = MakeTargetDialog.this.targetNameText.getText().trim();
                if (newName.equals("")) {
                    MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.mustSpecifyName"));
                } else {
                    try {
                        if (MakeTargetDialog.this.fTarget != null && MakeTargetDialog.this.fTarget.getName().equals(newName) || MakeTargetDialog.this.fTargetManager.findTarget(MakeTargetDialog.this.fContainer, newName) == null) {
                            MakeTargetDialog.this.fStatusLine.setErrorMessage(null);
                        } else {
                            MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.targetWithNameExists"));
                        }
                    }
                    catch (CoreException ex) {
                        MakeTargetDialog.this.fStatusLine.setErrorMessage(ex.getLocalizedMessage());
                    }
                }
                MakeTargetDialog.this.updateButtons();
            }
        });
    }

    protected void createSettingControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_SETTING_GROUP), (int)1);
        this.stopOnErrorButton = new Button((Composite)group, 32);
        this.stopOnErrorButton.setText(MakeUIPlugin.getResourceString(MAKE_SETTING_STOP_ERROR));
        this.stopOnErrorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MakeTargetDialog.this.updateButtons();
            }
        });
        if (this.isStopOnError) {
            this.stopOnErrorButton.setSelection(true);
        }
        if (this.isDefaultCommand) {
            this.stopOnErrorButton.setEnabled(true);
        } else {
            this.stopOnErrorButton.setEnabled(false);
        }
        this.runAllBuildersButton = new Button((Composite)group, 32);
        this.runAllBuildersButton.setText(MakeUIPlugin.getResourceString("SettingsBlock.makeSetting.runAllBuilders"));
        this.runAllBuildersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MakeTargetDialog.this.updateButtons();
            }
        });
        if (this.runAllBuilders) {
            this.runAllBuildersButton.setSelection(true);
        }
    }

    protected void createBuildCmdControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_CMD_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        group.setLayoutData((Object)gd);
        this.defButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_USE_DEFAULT));
        this.defButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MakeTargetDialog.this.defButton.getSelection()) {
                    MakeTargetDialog.this.commandText.setEnabled(false);
                    MakeTargetDialog.this.stopOnErrorButton.setEnabled(true);
                } else {
                    MakeTargetDialog.this.commandText.setEnabled(true);
                    MakeTargetDialog.this.stopOnErrorButton.setEnabled(false);
                }
                MakeTargetDialog.this.updateButtons();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.defButton.setLayoutData((Object)gd);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.commandText = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.commandText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.commandText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.commandText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (MakeTargetDialog.this.commandText.getText().equals("")) {
                    MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.mustSpecifyBuildCommand"));
                } else {
                    MakeTargetDialog.this.fStatusLine.setErrorMessage(null);
                }
                MakeTargetDialog.this.updateButtons();
            }
        });
        if (this.isDefaultCommand) {
            this.commandText.setEnabled(false);
        } else {
            this.commandText.setEnabled(true);
        }
        this.defButton.setSelection(this.isDefaultCommand);
    }

    private void createTargetControl(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(BUILD_ARGUMENT_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        group.setLayoutData((Object)gd);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(BUILD_ARGUMENT_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.targetText = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.targetText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.targetText.setText(this.targetString);
        this.targetText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                MakeTargetDialog.this.updateButtons();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.fTarget != null) {
            this.createButton(parent, 0, MakeUIPlugin.getResourceString("MakeTargetDialog.button.update"), true);
        } else {
            this.createButton(parent, 0, MakeUIPlugin.getResourceString("MakeTargetDialog.button.create"), true);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.targetNameText.setFocus();
        if (this.targetName != null) {
            this.targetNameText.setText(this.targetName);
        } else {
            this.targetNameText.setText(this.generateUniqueName(this.targetString));
        }
        this.targetNameText.selectAll();
        if (this.buildCommand != null) {
            String args;
            StringBuffer cmd = new StringBuffer(this.buildCommand.toOSString());
            if (!this.isDefaultCommand && (args = this.buildArguments) != null && !args.equals("")) {
                cmd.append(" ");
                cmd.append(args);
            }
            this.commandText.setText(cmd.toString());
        }
    }

    protected void updateButtons() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.targetHasChanged() && !this.fStatusLine.hasErrorMessage());
        }
    }

    protected boolean targetHasChanged() {
        if (this.initializing || this.fTarget == null) {
            return true;
        }
        if (this.isStopOnError != this.isStopOnError()) {
            return true;
        }
        if (this.runAllBuilders != this.runAllBuilders()) {
            return true;
        }
        if (this.isDefaultCommand != this.useDefaultBuildCmd()) {
            return true;
        }
        if (!this.targetName.equals(this.getTargetName())) {
            return true;
        }
        if (!this.targetString.equals(this.getTarget())) {
            return true;
        }
        if (!this.isDefaultCommand) {
            StringBuffer cmd = new StringBuffer(this.buildCommand.toOSString()).append(this.buildArguments);
            if (!this.getBuildLine().equals(cmd.toString())) {
                return true;
            }
        }
        return false;
    }

    private String generateUniqueName(String targetString) {
        String newName = targetString;
        int i = 0;
        try {
            while (this.fTargetManager.findTarget(this.fContainer, newName) != null) {
                newName = String.valueOf(targetString) + " (" + Integer.toString(++i) + ")";
            }
        }
        catch (CoreException coreException) {}
        return newName;
    }

    private boolean isStopOnError() {
        return this.stopOnErrorButton.getSelection();
    }

    private boolean runAllBuilders() {
        return this.runAllBuildersButton.getSelection();
    }

    private boolean useDefaultBuildCmd() {
        return this.defButton.getSelection();
    }

    private String getBuildLine() {
        String cmd;
        if (this.commandText != null && (cmd = this.commandText.getText()) != null) {
            return cmd.trim();
        }
        return null;
    }

    private String getTarget() {
        return this.targetText.getText().trim();
    }

    private String getTargetName() {
        return this.targetNameText.getText().trim();
    }

    protected void okPressed() {
        IMakeTarget target = this.fTarget;
        try {
            if (this.fTarget == null) {
                target = this.fTargetManager.createTarget(this.fContainer.getProject(), this.getTargetName(), this.targetBuildID);
            }
            target.setStopOnError(this.isStopOnError());
            target.setRunAllBuilders(this.runAllBuilders());
            target.setUseDefaultBuildCmd(this.useDefaultBuildCmd());
            if (!this.useDefaultBuildCmd()) {
                String bldLine = this.getBuildLine();
                int start = 0;
                int end = -1;
                if (!bldLine.startsWith("\"")) {
                    end = bldLine.indexOf(32);
                } else {
                    start = 1;
                    end = bldLine.indexOf(34, 1);
                }
                Path path = end == -1 ? new Path(bldLine) : new Path(bldLine.substring(start, end));
                target.setBuildCommand((IPath)path);
                String args = "";
                if (end != -1) {
                    args = bldLine.substring(end + 1);
                }
                target.setBuildArguments(args);
            }
            target.setBuildTarget(this.getTarget());
            if (this.fTarget == null) {
                this.fTargetManager.addTarget(this.fContainer, target);
            } else if (!target.getName().equals(this.getTargetName())) {
                this.fTargetManager.renameTarget(target, this.getTargetName());
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.errorDialog(this.getShell(), MakeUIPlugin.getResourceString("MakeTargetDialog.exception.makeTargetError"), MakeUIPlugin.getResourceString("MakeTargetDialog.exception.errorAddingTarget"), e);
        }
        super.okPressed();
    }
}

