/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;

public class Location
implements ICDILocation {
    BigInteger addr;
    String file = "";
    String function = "";
    int line;

    public Location(String f, String fnct, int l) {
        this(f, fnct, l, null);
    }

    public Location(String f, String fnct, int l, BigInteger a) {
        if (f != null) {
            this.file = f;
        }
        if (fnct != null) {
            this.function = fnct;
        }
        this.line = l;
        this.addr = a;
    }

    public Location(BigInteger address) {
        this.addr = address;
    }

    public BigInteger getAddress() {
        return this.addr;
    }

    public String getFile() {
        return this.file;
    }

    public String getFunction() {
        return this.function;
    }

    public int getLineNumber() {
        return this.line;
    }

    public boolean equals(ICDILocation location) {
        String ofile = location.getFile();
        if (this.file.length() > 0 && ofile.length() > 0 && this.file.equals(ofile)) {
            int oline = location.getLineNumber();
            if (this.line != 0 && oline != 0 && this.line == oline) {
                return true;
            }
            String ofunction = location.getFunction();
            if (this.function.length() > 0 && ofunction.length() > 0 && this.function.equals(ofunction)) {
                return true;
            }
        }
        BigInteger oaddr = location.getAddress();
        if (this.addr != null && oaddr != null && this.addr.equals(oaddr)) {
            return true;
        }
        return super.equals(location);
    }
}

