/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.SharedLibrary;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetAutoSolib;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetSolibSearchPath;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetStopOnSolibEvents;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShow;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowSolibSearchPath;
import org.eclipse.cdt.debug.mi.core.command.MIInfoSharedLibrary;
import org.eclipse.cdt.debug.mi.core.command.MISharedLibrary;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowInfo;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowSolibSearchPathInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoSharedLibraryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIShared;

public class SharedLibraryManager
extends Manager {
    ICDISharedLibrary[] EMPTY_SHAREDLIB = new ICDISharedLibrary[0];
    Map sharedMap = new Hashtable();
    boolean isDeferred = true;

    public SharedLibraryManager(Session session) {
        super(session, true);
        this.setAutoUpdate(MIPlugin.getDefault().getPluginPreferences().getBoolean(IMIConstants.PREF_SHARED_LIBRARIES_AUTO_REFRESH));
    }

    synchronized List getSharedList(Target target) {
        List sharedList = (List)this.sharedMap.get(target);
        if (sharedList == null) {
            sharedList = Collections.synchronizedList(new ArrayList());
            this.sharedMap.put(target, sharedList);
        }
        return sharedList;
    }

    MIShared[] getMIShareds(MISession miSession) throws CDIException {
        MIShared[] miLibs = new MIShared[]{};
        CommandFactory factory = miSession.getCommandFactory();
        MIInfoSharedLibrary infoShared = factory.createMIInfoSharedLibrary();
        try {
            miSession.postCommand(infoShared);
            MIInfoSharedLibraryInfo info = infoShared.getMIInfoSharedLibraryInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            miLibs = info.getMIShared();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return miLibs;
    }

    public void update(Target target) throws CDIException {
        MISession miSession = target.getMISession();
        Session session = (Session)target.getSession();
        List eventList = this.updateState(target);
        if (eventList.size() > 0) {
            BreakpointManager bpMgr = session.getBreakpointManager();
            ICDIBreakpoint[] bpoints = null;
            try {
                bpoints = bpMgr.getDeferredBreakpoints(target);
            }
            catch (CDIException cDIException) {
                bpoints = new ICDIBreakpoint[]{};
            }
            int i = 0;
            while (i < bpoints.length) {
                if (bpoints[i] instanceof Breakpoint) {
                    Breakpoint bkpt = (Breakpoint)bpoints[i];
                    try {
                        MIBreakpoint[] miBreakpoints;
                        boolean enable = bkpt.isEnabled();
                        bpMgr.setLocationBreakpoint(bkpt);
                        bpMgr.deleteFromDeferredList(bkpt);
                        bpMgr.addToBreakpointList(bkpt);
                        if (!enable) {
                            bpMgr.disableBreakpoint(bkpt);
                        }
                        if ((miBreakpoints = bkpt.getMIBreakpoints()) != null && miBreakpoints.length > 0) {
                            eventList.add(new MIBreakpointCreatedEvent(miSession, miBreakpoints[0].getNumber()));
                        }
                    }
                    catch (CDIException cDIException) {}
                }
                ++i;
            }
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        miSession.fireEvents(events);
    }

    private List updateState(Target target) throws CDIException {
        MISession miSession = target.getMISession();
        ICDITargetConfiguration conf = target.getConfiguration();
        if (!conf.supportsSharedLibrary()) {
            return Collections.EMPTY_LIST;
        }
        MIShared[] miLibs = this.getMIShareds(miSession);
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(miLibs.length);
        int i = 0;
        while (i < miLibs.length) {
            SharedLibrary sharedlib = this.getSharedLibrary(target, miLibs[i].getName());
            if (sharedlib != null) {
                if (this.hasSharedLibChanged(sharedlib, miLibs[i])) {
                    sharedlib.setMIShared(miLibs[i]);
                    eventList.add(new MISharedLibChangedEvent(miSession, miLibs[i].getName()));
                }
            } else {
                List sharedList = this.getSharedList(target);
                sharedList.add(new SharedLibrary(target, miLibs[i]));
                eventList.add(new MISharedLibCreatedEvent(miSession, miLibs[i].getName()));
            }
            ++i;
        }
        List sharedList = (List)this.sharedMap.get(target);
        if (sharedList != null) {
            SharedLibrary[] oldlibs = sharedList.toArray(new SharedLibrary[sharedList.size()]);
            int i2 = 0;
            while (i2 < oldlibs.length) {
                boolean found = false;
                int j = 0;
                while (j < miLibs.length) {
                    if (miLibs[j].getName().equals(oldlibs[i2].getFileName())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    eventList.add(new MISharedLibUnloadedEvent(miSession, oldlibs[i2].getFileName()));
                }
                ++i2;
            }
        }
        return eventList;
    }

    public boolean hasSharedLibChanged(SharedLibrary lib, MIShared miLib) {
        return !miLib.getName().equals(lib.getFileName()) || !MIFormat.getBigInteger(miLib.getFrom()).equals(lib.getStartAddress()) || !MIFormat.getBigInteger(miLib.getTo()).equals(lib.getEndAddress()) || miLib.isRead() != lib.areSymbolsLoaded();
    }

    public void deleteSharedLibrary(MISession miSession, SharedLibrary lib) {
        Target target = ((Session)this.getSession()).getTarget(miSession);
        List sharedList = (List)this.sharedMap.get(target);
        if (sharedList != null) {
            sharedList.remove(lib);
        }
    }

    public SharedLibrary getSharedLibrary(MISession miSession, String name) {
        Target target = ((Session)this.getSession()).getTarget(miSession);
        return this.getSharedLibrary(target, name);
    }

    public SharedLibrary getSharedLibrary(Target target, String name) {
        List sharedList = (List)this.sharedMap.get(target);
        if (sharedList != null) {
            SharedLibrary[] libs = sharedList.toArray(new SharedLibrary[sharedList.size()]);
            int i = 0;
            while (i < libs.length) {
                if (name.equals(libs[i].getFileName())) {
                    return libs[i];
                }
                ++i;
            }
        }
        return null;
    }

    public void setDeferredBreakpoint(boolean set) {
        this.isDeferred = set;
    }

    public boolean isDeferredBreakpoint() {
        return this.isDeferred;
    }

    public void setAutoLoadSymbols(Target target, boolean set) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBSetAutoSolib solib = factory.createMIGDBSetAutoSolib(set);
        try {
            mi.postCommand(solib);
            solib.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isAutoLoadSymbols(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShow show = factory.createMIGDBShow(new String[]{"auto-solib-add"});
        try {
            mi.postCommand(show);
            MIGDBShowInfo info = show.getMIGDBShowInfo();
            String value = info.getValue();
            if (value != null) {
                return value.equalsIgnoreCase("on");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return false;
    }

    public void setStopOnSolibEvents(Target target, boolean set) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBSetStopOnSolibEvents stop = factory.createMIGDBSetStopOnSolibEvents(set);
        try {
            mi.postCommand(stop);
            stop.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isStopOnSolibEvents(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShow show = factory.createMIGDBShow(new String[]{"stop-on-solib-events"});
        try {
            mi.postCommand(show);
            MIGDBShowInfo info = show.getMIGDBShowInfo();
            String value = info.getValue();
            if (value != null) {
                return value.equalsIgnoreCase("1");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return false;
    }

    public void setSharedLibraryPaths(Target target, String[] libPaths) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBSetSolibSearchPath solib = factory.createMIGDBSetSolibSearchPath(libPaths);
        try {
            mi.postCommand(solib);
            solib.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public String[] getSharedLibraryPaths(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShowSolibSearchPath dir = factory.createMIGDBShowSolibSearchPath();
        try {
            mi.postCommand(dir);
            MIGDBShowSolibSearchPathInfo info = dir.getMIGDBShowSolibSearchPathInfo();
            return info.getDirectories();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDISharedLibrary[] getSharedLibraries(Target target) throws CDIException {
        List sharedList = (List)this.sharedMap.get(target);
        if (sharedList != null) {
            return sharedList.toArray(new ICDISharedLibrary[sharedList.size()]);
        }
        return this.EMPTY_SHAREDLIB;
    }

    public void loadSymbols(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MISharedLibrary sharedlibrary = factory.createMISharedLibrary();
        try {
            mi.postCommand(sharedlibrary);
            MIInfo info = sharedlibrary.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.update(target);
    }

    public void loadSymbols(Target target, ICDISharedLibrary[] libs) throws CDIException {
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        int i = 0;
        while (i < libs.length) {
            if (!libs[i].areSymbolsLoaded()) {
                MISharedLibrary sharedlibrary = factory.createMISharedLibrary(libs[i].getFileName());
                try {
                    miSession.postCommand(sharedlibrary);
                    MIInfo info = sharedlibrary.getMIInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
                this.update(target);
            }
            ++i;
        }
    }

    public boolean supportsAutoLoadSymbols() {
        return true;
    }

    public boolean supportsStopOnSolibEvents() {
        return true;
    }
}

