/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExceptionpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.CoreProcess;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CoreFileConfiguration;
import org.eclipse.cdt.debug.mi.core.cdi.model.RuntimeOptions;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.TargetConfiguration;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecNext;
import org.eclipse.cdt.debug.mi.core.command.MIExecNextInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecRun;
import org.eclipse.cdt.debug.mi.core.command.MIExecStep;
import org.eclipse.cdt.debug.mi.core.command.MIExecStepInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecUntil;
import org.eclipse.cdt.debug.mi.core.command.MIInfoThreads;
import org.eclipse.cdt.debug.mi.core.command.MIJump;
import org.eclipse.cdt.debug.mi.core.command.MISignal;
import org.eclipse.cdt.debug.mi.core.command.MITargetDetach;
import org.eclipse.cdt.debug.mi.core.command.MIThreadSelect;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoThreadsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIThreadSelectInfo;

public class Target
extends SessionObject
implements ICDITarget {
    MISession miSession;
    ICDITargetConfiguration fConfiguration;
    Thread[] noThreads = new Thread[0];
    Thread[] currentThreads;
    int currentThreadId;

    public Target(Session s, MISession mi) {
        super(s);
        this.miSession = mi;
        this.currentThreads = this.noThreads;
    }

    public MISession getMISession() {
        return this.miSession;
    }

    public void setConfiguration(ICDITargetConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    public ICDITarget getTarget() {
        return this;
    }

    public void setCurrentThread(ICDIThread cthread) throws CDIException {
        if (!(cthread instanceof Thread)) {
            throw new CDIException(CdiResources.getString("cdi.model.Target.Unknown_thread"));
        }
        this.setCurrentThread(cthread, true);
    }

    public void setCurrentThread(ICDIThread cthread, boolean doUpdate) throws CDIException {
        if (!(cthread instanceof Thread)) {
            throw new CDIException(CdiResources.getString("cdi.model.Target.Unknown_thread"));
        }
        this.setCurrentThread((Thread)cthread, doUpdate);
    }

    public void setCurrentThread(Thread cthread, boolean doUpdate) throws CDIException {
        int id = cthread.getId();
        if (id == 0) {
            return;
        }
        if (this.currentThreadId != id) {
            CommandFactory factory = this.miSession.getCommandFactory();
            MIThreadSelect select = factory.createMIThreadSelect(id);
            try {
                this.miSession.postCommand(select);
                MIThreadSelectInfo info = select.getMIThreadSelectInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
                }
                this.currentThreadId = info.getNewThreadId();
                MIFrame miFrame = info.getFrame();
                if (miFrame != null) {
                    int depth = cthread.getStackFrameCount();
                    cthread.currentFrame = new StackFrame(cthread, miFrame, depth - miFrame.getLevel());
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Session session = (Session)this.getSession();
            if (doUpdate) {
                VariableManager varMgr;
                RegisterManager regMgr = session.getRegisterManager();
                if (regMgr.isAutoUpdate()) {
                    regMgr.update(this);
                }
                if ((varMgr = session.getVariableManager()).isAutoUpdate()) {
                    varMgr.update(this);
                }
            }
        }
        if (this.currentThreadId != id) {
            this.miSession.fireEvent(new MIThreadExitEvent(this.miSession, id));
            throw new CDIException(String.valueOf(CdiResources.getString("cdi.model.Target.Cannot_switch_to_thread")) + id);
        }
    }

    public void updateState(int newThreadId) {
        int j;
        Thread[] oldThreads = this.currentThreads;
        this.currentThreadId = newThreadId;
        try {
            this.currentThreads = this.getCThreads();
        }
        catch (CDIException cDIException) {
            this.currentThreads = this.noThreads;
        }
        ArrayList<Integer> cList = new ArrayList<Integer>(this.currentThreads.length);
        int i = 0;
        while (i < this.currentThreads.length) {
            boolean found = false;
            j = 0;
            while (j < oldThreads.length) {
                if (this.currentThreads[i].getId() == oldThreads[j].getId()) {
                    oldThreads[j].clearState();
                    this.currentThreads[i] = oldThreads[j];
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                cList.add(new Integer(this.currentThreads[i].getId()));
            }
            ++i;
        }
        if (!cList.isEmpty()) {
            MIEvent[] events = new MIThreadCreatedEvent[cList.size()];
            int j2 = 0;
            while (j2 < events.length) {
                int id = (Integer)cList.get(j2);
                events[j2] = new MIThreadCreatedEvent(this.miSession, id);
                ++j2;
            }
            this.miSession.fireEvents(events);
        }
        ArrayList<Integer> dList = new ArrayList<Integer>(oldThreads.length);
        int i2 = 0;
        while (i2 < oldThreads.length) {
            boolean found = false;
            int j3 = 0;
            while (j3 < this.currentThreads.length) {
                if (this.currentThreads[j3].getId() == oldThreads[i2].getId()) {
                    found = true;
                    break;
                }
                ++j3;
            }
            if (!found) {
                dList.add(new Integer(oldThreads[i2].getId()));
            }
            ++i2;
        }
        if (!dList.isEmpty()) {
            MIEvent[] events = new MIThreadExitEvent[dList.size()];
            j = 0;
            while (j < events.length) {
                int id = (Integer)dList.get(j);
                events[j] = new MIThreadExitEvent(this.miSession, id);
                ++j;
            }
            this.miSession.fireEvents(events);
        }
    }

    public Thread[] getCThreads() throws CDIException {
        Thread[] cthreads = this.noThreads;
        CommandFactory factory = this.miSession.getCommandFactory();
        MIInfoThreads tids = factory.createMIInfoThreads();
        try {
            String[] names;
            int[] ids;
            this.miSession.postCommand(tids);
            MIInfoThreadsInfo info = tids.getMIInfoThreadsInfo();
            if (info == null) {
                ids = new int[]{};
                names = new String[]{};
            } else {
                ids = info.getThreadIds();
                names = info.getThreadNames();
            }
            if (ids != null && ids.length > 0) {
                cthreads = new Thread[ids.length];
                if (names != null && names.length == ids.length) {
                    int i = 0;
                    while (i < ids.length) {
                        cthreads[i] = new Thread(this, ids[i], names[i]);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < ids.length) {
                        cthreads[i] = new Thread(this, ids[i]);
                        ++i;
                    }
                }
            } else {
                cthreads = new Thread[]{new Thread(this, 0)};
            }
            this.currentThreadId = info.getCurrentThread();
            if (this.currentThreadId == 0 && cthreads.length > 0) {
                this.currentThreadId = cthreads[0].getId();
            }
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
        return cthreads;
    }

    public ICDIThread getCurrentThread() throws CDIException {
        ICDIThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            Thread cthread = (Thread)threads[i];
            if (cthread.getId() == this.currentThreadId) {
                return cthread;
            }
            ++i;
        }
        return null;
    }

    public ICDIThread[] getThreads() throws CDIException {
        if (this.currentThreads.length == 0) {
            this.currentThreads = this.getCThreads();
        }
        return this.currentThreads;
    }

    public ICDIThread getThread(int tid) {
        Thread th = null;
        if (this.currentThreads != null) {
            int i = 0;
            while (i < this.currentThreads.length) {
                Thread cthread = this.currentThreads[i];
                if (cthread.getId() == tid) {
                    th = cthread;
                    break;
                }
                ++i;
            }
        }
        return th;
    }

    public void restart() throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecRun run = factory.createMIExecRun(new String[0]);
        try {
            this.miSession.postCommand(run);
            MIInfo info = run.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepInto() throws CDIException {
        this.stepInto(1);
    }

    public void stepInto(int count) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecStep step = factory.createMIExecStep(count);
        try {
            this.miSession.postCommand(step);
            MIInfo info = step.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepIntoInstruction() throws CDIException {
        this.stepIntoInstruction(1);
    }

    public void stepIntoInstruction(int count) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecStepInstruction stepi = factory.createMIExecStepInstruction(count);
        try {
            this.miSession.postCommand(stepi);
            MIInfo info = stepi.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepOver() throws CDIException {
        this.stepOver(1);
    }

    public void stepOver(int count) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecNext next = factory.createMIExecNext(count);
        try {
            this.miSession.postCommand(next);
            MIInfo info = next.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepOverInstruction() throws CDIException {
        this.stepOverInstruction(1);
    }

    public void stepOverInstruction(int count) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecNextInstruction nexti = factory.createMIExecNextInstruction(count);
        try {
            this.miSession.postCommand(nexti);
            MIInfo info = nexti.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepReturn() throws CDIException {
        ((Thread)this.getCurrentThread()).getCurrentStackFrame().stepReturn();
    }

    public void runUntil(ICDILocation location) throws CDIException {
        this.stepUntil(location);
    }

    public void stepUntil(ICDILocation location) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        String loc = "";
        if (location.getFile() != null && location.getFile().length() > 0) {
            loc = String.valueOf(location.getFile()) + ":" + location.getLineNumber();
        } else if (location.getFunction() != null && location.getFunction().length() > 0) {
            loc = location.getFunction();
        } else if (!location.getAddress().equals(BigInteger.ZERO)) {
            loc = "*" + location.getAddress().toString();
        }
        MIExecUntil until = factory.createMIExecUntil(loc);
        try {
            this.miSession.postCommand(until);
            MIInfo info = until.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void suspend() throws CDIException {
        try {
            this.miSession.getMIInferior().interrupt();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void disconnect() throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MITargetDetach detach = factory.createMITargetDetach();
        try {
            this.miSession.postCommand(detach);
            MIInfo info = detach.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.miSession.fireEvent(new MIDetachedEvent(this.miSession, detach.getToken()));
        this.miSession.getMIInferior().setDisconnected();
    }

    public void resume() throws CDIException {
        this.resume(false);
    }

    public void resume(ICDILocation location) throws CDIException {
        this.jump(location);
    }

    public void resume(ICDISignal signal) throws CDIException {
        this.signal(signal);
    }

    public void resume(boolean passSignal) throws CDIException {
        if (this.miSession.getMIInferior().isRunning()) {
            throw new CDIException(CdiResources.getString("cdi.model.Target.Inferior_already_running"));
        }
        if (this.miSession.getMIInferior().isSuspended()) {
            if (passSignal) {
                this.signal();
            } else {
                this.continuation();
            }
        } else if (this.miSession.getMIInferior().isTerminated()) {
            this.restart();
        } else {
            this.restart();
        }
    }

    public void continuation() throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MIExecContinue cont = factory.createMIExecContinue();
        try {
            this.miSession.postCommand(cont);
            MIInfo info = cont.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void jump(ICDILocation location) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        String loc = "";
        if (location.getFile() != null && location.getFile().length() > 0) {
            loc = String.valueOf(location.getFile()) + ":" + location.getLineNumber();
        } else if (location.getFunction() != null && location.getFunction().length() > 0) {
            loc = location.getFunction();
        } else if (!location.getAddress().equals(BigInteger.ZERO)) {
            loc = "*" + location.getAddress().toString();
        }
        MIJump jump = factory.createMIJump(loc);
        try {
            this.miSession.postCommand(jump);
            MIInfo info = jump.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void signal() throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MISignal signal = factory.createMISignal("0");
        try {
            this.miSession.postCommand(signal);
            MIInfo info = signal.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void signal(ICDISignal signal) throws CDIException {
        CommandFactory factory = this.miSession.getCommandFactory();
        MISignal sig = factory.createMISignal(signal.getName());
        try {
            this.miSession.postCommand(sig);
            MIInfo info = sig.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String evaluateExpressionToString(ICDIStackFrame frame, String expressionText) throws CDIException {
        String string;
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame((StackFrame)frame, false);
        try {
            try {
                CommandFactory factory = this.miSession.getCommandFactory();
                MIDataEvaluateExpression evaluate = factory.createMIDataEvaluateExpression(expressionText);
                this.miSession.postCommand(evaluate);
                MIDataEvaluateExpressionInfo info = evaluate.getMIDataEvaluateExpressionInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
                }
                string = info.getExpression();
                Object var9_11 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        return string;
    }

    public void terminate() throws CDIException {
        try {
            this.miSession.getMIInferior().terminate();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isTerminated() {
        return this.miSession.getMIInferior().isTerminated();
    }

    public boolean isDisconnected() {
        return !this.miSession.getMIInferior().isConnected();
    }

    public boolean isSuspended() {
        return this.miSession.getMIInferior().isSuspended();
    }

    public boolean isRunning() {
        return this.miSession.getMIInferior().isRunning();
    }

    public Process getProcess() {
        if (this.miSession.isCoreSession()) {
            return new CoreProcess();
        }
        return this.miSession.getMIInferior();
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.getBreakpoints(this);
    }

    public ICDILocationBreakpoint setLocationBreakpoint(int type, ICDILocation location, ICDICondition condition, boolean deferred) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.setLocationBreakpoint(this, type, location, condition, deferred);
    }

    public ICDIWatchpoint setWatchpoint(int type, int watchType, String expression, ICDICondition condition) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.setWatchpoint(this, type, watchType, expression, condition);
    }

    public void deleteBreakpoints(ICDIBreakpoint[] breakpoints) throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        bMgr.deleteBreakpoints(this, breakpoints);
    }

    public void deleteAllBreakpoints() throws CDIException {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        bMgr.deleteAllBreakpoints(this);
    }

    public ICDIExceptionpoint setExceptionBreakpoint(String clazz, boolean stopOnThrow, boolean stopOnCatch) throws CDIException {
        throw new CDIException(CdiResources.getString("cdi.Common.Not_implemented"));
    }

    public ICDICondition createCondition(int ignoreCount, String expression) {
        return this.createCondition(ignoreCount, expression, null);
    }

    public ICDICondition createCondition(int ignoreCount, String expression, String[] tids) {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.createCondition(ignoreCount, expression, tids);
    }

    public ICDILocation createLocation(String file, String function, int line) {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.createLocation(file, function, line);
    }

    public ICDILocation createLocation(BigInteger address) {
        BreakpointManager bMgr = ((Session)this.getSession()).getBreakpointManager();
        return bMgr.createLocation(address);
    }

    public ICDIRuntimeOptions getRuntimeOptions() {
        return new RuntimeOptions(this);
    }

    public ICDIExpression createExpression(String code) throws CDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        return expMgr.createExpression(this, code);
    }

    public ICDIExpression[] getExpressions() throws CDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        return expMgr.getExpressions(this);
    }

    public void destroyExpressions(ICDIExpression[] expressions) throws CDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        expMgr.destroyExpressions(this, expressions);
    }

    public void destroyAllExpressions() throws CDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        expMgr.destroyAllExpressions(this);
    }

    public ICDISignal[] getSignals() throws CDIException {
        SignalManager sigMgr = ((Session)this.getSession()).getSignalManager();
        return sigMgr.getSignals(this);
    }

    public void addSourcePaths(String[] srcPaths) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        srcMgr.addSourcePaths(this, srcPaths);
    }

    public String[] getSourcePaths() throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getSourcePaths(this);
    }

    public ICDIInstruction[] getInstructions(BigInteger startAddress, BigInteger endAddress) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getInstructions(this, startAddress, endAddress);
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getInstructions(this, filename, linenum);
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum, int lines) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getInstructions(this, filename, linenum, lines);
    }

    public ICDIMixedInstruction[] getMixedInstructions(BigInteger startAddress, BigInteger endAddress) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getMixedInstructions(this, startAddress, endAddress);
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getMixedInstructions(this, filename, linenum);
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum, int lines) throws CDIException {
        SourceManager srcMgr = ((Session)this.getSession()).getSourceManager();
        return srcMgr.getMixedInstructions(this, filename, linenum, lines);
    }

    public ICDIMemoryBlock createMemoryBlock(String address, int length) throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        return memMgr.createMemoryBlock(this, address, length);
    }

    public ICDIMemoryBlock createMemoryBlock(BigInteger address, int length) throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        return memMgr.createMemoryBlock(this, address, length);
    }

    public void removeBlocks(ICDIMemoryBlock[] memoryBlocks) throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        memMgr.removeBlocks(this, memoryBlocks);
    }

    public void removeAllBlocks() throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        memMgr.removeAllBlocks(this);
    }

    public ICDIMemoryBlock[] getMemoryBlocks() throws CDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        return memMgr.getMemoryBlocks(this);
    }

    public ICDISharedLibrary[] getSharedLibraries() throws CDIException {
        SharedLibraryManager sharedMgr = ((Session)this.getSession()).getSharedLibraryManager();
        return sharedMgr.getSharedLibraries(this);
    }

    public ICDIVariableDescriptor getGlobalVariableDescriptors(String filename, String function, String name) throws CDIException {
        VariableManager varMgr = ((Session)this.getSession()).getVariableManager();
        return varMgr.getGlobalVariableDescriptor(this, filename, function, name);
    }

    public ICDIRegisterGroup[] getRegisterGroups() throws CDIException {
        RegisterManager regMgr = ((Session)this.getSession()).getRegisterManager();
        return regMgr.getRegisterGroups(this);
    }

    public ICDITargetConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = this.miSession.isProgramSession() ? new TargetConfiguration(this) : (this.miSession.isAttachSession() ? new TargetConfiguration(this) : (this.miSession.isCoreSession() ? new CoreFileConfiguration(this) : new TargetConfiguration(this)));
        }
        return this.fConfiguration;
    }
}

