/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model.type;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntegralValue;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;

public abstract class IntegralValue
extends Value
implements ICDIIntegralValue {
    public IntegralValue(Variable v) {
        super(v);
    }

    public BigInteger bigIntegerValue() throws CDIException {
        String valueString = this.getValueString();
        int space = valueString.indexOf(32);
        if (space != -1) {
            valueString = valueString.substring(0, space).trim();
        }
        try {
            return MIFormat.getBigInteger(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            return BigInteger.ZERO;
        }
    }

    public long longValue() throws CDIException {
        long value = 0L;
        String valueString = this.getValueString();
        int space = valueString.indexOf(32);
        if (space != -1) {
            valueString = valueString.substring(0, space).trim();
        }
        try {
            value = MIFormat.getBigInteger(valueString).longValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public int intValue() throws CDIException {
        int value = 0;
        String valueString = this.getValueString();
        int space = valueString.indexOf(32);
        if (space != -1) {
            valueString = valueString.substring(0, space).trim();
        }
        try {
            value = MIFormat.getBigInteger(valueString).intValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public short shortValue() throws CDIException {
        short value = 0;
        String valueString = this.getValueString();
        int space = valueString.indexOf(32);
        if (space != -1) {
            valueString = valueString.substring(0, space).trim();
        }
        try {
            value = MIFormat.getBigInteger(valueString).shortValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public int byteValue() throws CDIException {
        byte value = 0;
        String valueString = this.getValueString();
        int space = valueString.indexOf(32);
        if (space != -1) {
            valueString = valueString.substring(0, space).trim();
        }
        try {
            value = MIFormat.getBigInteger(valueString).byteValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }
}

