/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ResolverChangeEvent;
import org.eclipse.cdt.core.filetype.ResolverDelta;
import org.eclipse.cdt.core.internal.filetype.CFileTypeResolver;
import org.eclipse.cdt.core.internal.filetype.ResolverModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomResolver
extends CFileTypeResolver {
    private static final String OLD_RESOLVER = "cdt_resolver";
    private static final String CDT_RESOLVER = "org.eclipse.cdt.core.resolver";
    private static final String TAG_CUSTOM = "custom";
    private static final String TAG_ASSOC = "associations";
    private static final String TAG_ENTRY = "entry";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_VALUE = "value";
    private ResolverModel fModel;

    public CustomResolver(ResolverModel model, IProject p) {
        super((IContainer)p);
        this.fModel = model;
    }

    public static boolean hasCustomResolver(IProject project) {
        Boolean custom = new Boolean(false);
        Element data = CustomResolver.getProjectOldResolverData(project, false);
        custom = CustomResolver.hasCustomTag(data);
        if (!custom.booleanValue()) {
            data = CustomResolver.getProjectResolverData(project, false);
            custom = CustomResolver.hasCustomTag(data);
        }
        return custom;
    }

    public static void removeCustomResover(IProject project) {
        Element root = CustomResolver.getProjectResolverData(project, false);
        if (root != null) {
            Node child = root.getFirstChild();
            while (child != null) {
                root.removeChild(child);
                child = root.getFirstChild();
            }
            try {
                CustomResolver.getProjectDescriptor(project, true).saveProjectData();
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
    }

    protected void doAdjustAssociations(ICFileTypeAssociation[] addAssocs, ICFileTypeAssociation[] delAssocs, boolean triggerEvent) {
        int i;
        IProject project = (IProject)this.getContainer();
        ArrayList<ResolverDelta> deltas = new ArrayList<ResolverDelta>();
        if (triggerEvent && addAssocs != null && addAssocs.length > 0) {
            i = 0;
            while (i < addAssocs.length) {
                deltas.add(new ResolverDelta(addAssocs[i], 16));
                ++i;
            }
        }
        if (triggerEvent && delAssocs != null && delAssocs.length > 0) {
            i = 0;
            while (i < delAssocs.length) {
                deltas.add(new ResolverDelta(delAssocs[i], 32));
                ++i;
            }
        }
        if (triggerEvent && !deltas.isEmpty()) {
            ResolverChangeEvent event = new ResolverChangeEvent(this.fModel, this);
            int i2 = 0;
            while (i2 < deltas.size()) {
                ResolverDelta delta = (ResolverDelta)deltas.get(i2);
                event.addDelta(delta);
                ++i2;
            }
            this.fModel.fireEvent(event);
        }
        Element root = CustomResolver.getProjectResolverData(project, true);
        Document doc = root.getOwnerDocument();
        Node child = root.getFirstChild();
        Element element = null;
        while (child != null) {
            root.removeChild(child);
            child = root.getFirstChild();
        }
        element = doc.createElement(TAG_CUSTOM);
        element.setAttribute(ATTR_VALUE, Boolean.TRUE.toString());
        root.appendChild(element);
        element = doc.createElement(TAG_ASSOC);
        root.appendChild(element);
        root = element;
        ICFileTypeAssociation[] assoc = this.getFileTypeAssociations();
        int i3 = 0;
        while (i3 < assoc.length) {
            element = doc.createElement(TAG_ENTRY);
            element.setAttribute(ATTR_PATTERN, assoc[i3].getPattern());
            element.setAttribute(ATTR_TYPE, assoc[i3].getType().getId());
            root.appendChild(element);
            ++i3;
        }
        try {
            CustomResolver.getProjectDescriptor(project, true).saveProjectData();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    protected ICFileTypeAssociation[] loadAssociations() {
        IProject project = (IProject)this.getContainer();
        CustomResolver.convert20(project);
        ArrayList<ICFileTypeAssociation> assocs = new ArrayList<ICFileTypeAssociation>();
        Element data = CustomResolver.getProjectResolverData(project, false);
        Node child = data != null ? data.getFirstChild() : null;
        while (child != null) {
            if (child.getNodeName().equals(TAG_ASSOC)) {
                Node assoc = child.getFirstChild();
                while (assoc != null) {
                    if (assoc.getNodeName().equals(TAG_ENTRY)) {
                        Element element = (Element)assoc;
                        String pattern = element.getAttribute(ATTR_PATTERN);
                        String typeId = element.getAttribute(ATTR_TYPE);
                        try {
                            assocs.add(this.fModel.createAssocation(pattern, this.fModel.getFileTypeById(typeId)));
                        }
                        catch (IllegalArgumentException e) {
                            CCorePlugin.log(e);
                        }
                    }
                    assoc = assoc.getNextSibling();
                }
            }
            child = child.getNextSibling();
        }
        return assocs.toArray(new ICFileTypeAssociation[assocs.size()]);
    }

    private static Element getProjectResolverData(IProject project, boolean create) {
        Element data = null;
        try {
            ICDescriptor desc = CustomResolver.getProjectDescriptor(project, create);
            if (desc != null) {
                data = desc.getProjectData(CDT_RESOLVER);
            }
        }
        catch (CoreException coreException) {}
        return data;
    }

    private static ICDescriptor getProjectDescriptor(IProject project, boolean create) throws CoreException {
        ICDescriptor descriptor = null;
        descriptor = CCorePlugin.getDefault().getCProjectDescription(project, create);
        return descriptor;
    }

    private static Element getProjectOldResolverData(IProject project, boolean create) {
        Element data = null;
        try {
            ICDescriptor desc = CustomResolver.getProjectDescriptor(project, create);
            if (desc != null) {
                data = desc.getProjectData(OLD_RESOLVER);
            }
        }
        catch (CoreException coreException) {}
        return data;
    }

    private static void convert20(IProject project) {
        Element root = CustomResolver.getProjectOldResolverData(project, false);
        if (root != null) {
            ResolverModel model = ResolverModel.getDefault();
            ArrayList<ICFileTypeAssociation> assocList = new ArrayList<ICFileTypeAssociation>();
            Node child = root.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals(TAG_ASSOC)) {
                    Node assoc = child.getFirstChild();
                    while (assoc != null) {
                        if (assoc.getNodeName().equals(TAG_ENTRY)) {
                            Element element = (Element)assoc;
                            String pattern = element.getAttribute(ATTR_PATTERN);
                            String typeId = element.getAttribute(ATTR_TYPE);
                            try {
                                assocList.add(model.createAssocation(pattern, model.getFileTypeById(typeId)));
                            }
                            catch (IllegalArgumentException e) {
                                CCorePlugin.log(e);
                            }
                        }
                        assoc = assoc.getNextSibling();
                    }
                }
                child = child.getNextSibling();
            }
            child = root.getFirstChild();
            while (child != null) {
                root.removeChild(child);
                child = root.getFirstChild();
            }
            ICFileTypeAssociation[] assocs = assocList.toArray(new ICFileTypeAssociation[assocList.size()]);
            if (assocs.length > 0 && (root = CustomResolver.getProjectResolverData(project, true)) != null) {
                Document doc = root.getOwnerDocument();
                child = root.getFirstChild();
                Element element = null;
                while (child != null) {
                    root.removeChild(child);
                    child = root.getFirstChild();
                }
                element = doc.createElement(TAG_CUSTOM);
                element.setAttribute(ATTR_VALUE, Boolean.TRUE.toString());
                root.appendChild(element);
                element = doc.createElement(TAG_ASSOC);
                root.appendChild(element);
                root = element;
                int i = 0;
                while (i < assocs.length) {
                    element = doc.createElement(TAG_ENTRY);
                    element.setAttribute(ATTR_PATTERN, assocs[i].getPattern());
                    element.setAttribute(ATTR_TYPE, assocs[i].getType().getId());
                    root.appendChild(element);
                    ++i;
                }
            }
            try {
                CustomResolver.getProjectDescriptor(project, true).saveProjectData();
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
    }

    private static Boolean hasCustomTag(Element data) {
        Node child = data != null ? data.getFirstChild() : null;
        new Boolean(false);
        while (child != null) {
            if (child.getNodeName().equals(TAG_CUSTOM)) {
                return Boolean.valueOf(((Element)child).getAttribute(ATTR_VALUE));
            }
            child = child.getNextSibling();
        }
        return Boolean.FALSE;
    }
}

