/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GnuMakefileGenerator
implements IManagedBuilderMakefileGenerator {
    private static final String COMMENT = "MakefileGenerator.comment";
    private static final String AUTO_DEP = "MakefileGenerator.comment.autodeps";
    private static final String MESSAGE = "ManagedMakeBuilder.message";
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String DEP_INCL = "MakefileGenerator.comment.module.dep.includes";
    private static final String HEADER = "MakefileGenerator.comment.header";
    protected static final String MESSAGE_FINISH_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.build");
    protected static final String MESSAGE_FINISH_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.file");
    protected static final String MESSAGE_START_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.build");
    protected static final String MESSAGE_START_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.file");
    private static final String MOD_INCL = "MakefileGenerator.comment.module.make.includes";
    private static final String MOD_LIST = "MakefileGenerator.comment.module.list";
    private static final String MOD_RULES = "MakefileGenerator.comment.build.rule";
    private static final String SRC_LISTS = "MakefileGenerator.comment.source.list";
    private String buildTargetName;
    private Vector buildTools;
    private Vector deletedFileList;
    private Vector dependencyMakefiles;
    private String extension;
    private IManagedBuildInfo info;
    private Vector invalidDirList;
    private Vector modifiedList;
    private IProgressMonitor monitor;
    private Set outputExtensionsSet;
    private IProject project;
    private Vector ruleList;
    private Vector subdirList;
    private IPath topBuildDir;

    protected StringBuffer addDefaultHeader() {
        StringBuffer buffer = new StringBuffer();
        this.outputCommentLine(buffer);
        buffer.append("# " + ManagedMakeMessages.getResourceString(HEADER) + IManagedBuilderMakefileGenerator.NEWLINE);
        this.outputCommentLine(buffer);
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer;
    }

    protected StringBuffer addFragmentDependenciesHeader() {
        return this.addDefaultHeader();
    }

    protected StringBuffer addFragmentMakefileHeader() {
        return this.addDefaultHeader();
    }

    private StringBuffer addMacros() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ROOT := .." + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(ROOT)/makefile.init" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("RM := ");
        buffer.append(String.valueOf(this.info.getCleanCommand()) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("# " + ManagedMakeMessages.getResourceString(SRC_LISTS) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include sources.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(SUBDIRS:%=%/subdir.mk)" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include objects.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(DEPS)" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(ROOT)/makefile.defs" + IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
    }

    private void addRule(String relativePath, StringBuffer buffer, IResource resource) {
        boolean doDepGen;
        String buildFlags = null;
        String resourceName = this.getFileName(resource);
        String inputExtension = resource.getFileExtension();
        String cmd = this.info.getToolForSource(inputExtension);
        String outputExtension = this.info.getOutputExtension(inputExtension);
        String outflag = null;
        String outputPrefix = null;
        IManagedDependencyGenerator depGen = this.info.getDependencyGenerator(inputExtension);
        boolean bl = doDepGen = depGen != null && depGen.getCalculatorType() == 1;
        if (doDepGen) {
            String depFile = String.valueOf(relativePath) + resourceName + "." + "d";
            this.getDependencyMakefiles().add(depFile);
        }
        IPath resourceLocation = resource.getLocation();
        String projectLocation = this.project.getLocation().toString();
        String resourcePath = null;
        String buildRule = null;
        String OptDotExt = "";
        boolean isItLinked = false;
        if (outputExtension != "") {
            OptDotExt = "." + outputExtension;
        }
        IConfiguration config = this.info.getDefaultConfiguration();
        IResourceConfiguration resConfig = null;
        if (config != null) {
            resConfig = config.getResourceConfiguration(resource.getFullPath().toString());
        }
        if (!resourceLocation.toString().startsWith(projectLocation)) {
            isItLinked = true;
            resourcePath = resourceLocation.toString();
            buildRule = String.valueOf(relativePath) + resourceName + OptDotExt + ":" + " " + resourcePath;
        } else {
            resourcePath = relativePath;
            buildRule = resConfig != null ? String.valueOf(resourcePath) + resourceName + OptDotExt + ":" + " " + "$(ROOT)" + "/" + resourcePath + resourceName + "." + inputExtension : String.valueOf(relativePath) + "%" + OptDotExt + ":" + " " + "$(ROOT)" + "/" + resourcePath + "%" + "." + inputExtension;
        }
        if (this.getRuleList().contains(buildRule)) {
            return;
        }
        this.getRuleList().add(buildRule);
        buffer.append(String.valueOf(buildRule) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t@echo '" + MESSAGE_START_FILE + " " + "$<" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
        IManagedCommandLineInfo cmdLInfo = null;
        String[] inputs = null;
        if (resConfig != null) {
            ITool[] tools = resConfig.getTools();
            try {
                buildFlags = tools[0].getToolFlags();
            }
            catch (BuildException buildException) {
                buildFlags = null;
            }
            outflag = tools[0].getOutputFlag();
            outputPrefix = tools[0].getOutputPrefix();
            cmd = tools[0].getToolCommand();
            String rootDir = "../";
            String fileName = isItLinked ? resourcePath : String.valueOf(rootDir) + relativePath + resConfig.getName();
            inputs = new String[]{fileName};
            String[] flags = null;
            try {
                flags = tools[0].getCommandFlags();
            }
            catch (BuildException buildException) {
                flags = null;
            }
            IManagedCommandLineGenerator cmdLGen = tools[0].getCommandLineGenerator();
            cmdLInfo = cmdLGen.generateCommandLineInfo(tools[0], cmd, flags, outflag, outputPrefix, "$@", inputs, tools[0].getCommandLinePattern());
            String buildCmd = cmdLInfo.getCommandLine();
            buffer.append("\t@echo " + buildCmd + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("\t@" + buildCmd);
        } else {
            buildFlags = this.info.getFlagsForSource(inputExtension);
            outflag = this.info.getOutputFlag(outputExtension);
            outputPrefix = this.info.getOutputPrefix(outputExtension);
            String[] flags = buildFlags.split("\\s");
            inputs = new String[]{"$<"};
            cmdLInfo = this.info.generateCommandLineInfo(inputExtension, flags, outflag, outputPrefix, "$@", inputs);
            String buildCmd = null;
            buildCmd = cmdLInfo == null ? String.valueOf(cmd) + " " + buildFlags + " " + outflag + " " + outputPrefix + "$@" + " " + "$<" : cmdLInfo.getCommandLine();
            buffer.append("\t@echo " + buildCmd + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("\t@" + buildCmd);
        }
        if (doDepGen && depGen.getCalculatorType() == 1) {
            buffer.append(" && \\\n");
            String depCmd = depGen.getDependencyCommand(resource, this.info);
            buffer.append(depCmd);
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t@echo '" + MESSAGE_FINISH_FILE + " " + "$<" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t@echo ' '" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
    }

    private StringBuffer addSources(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        String relativePath = moduleRelativePath.toString();
        relativePath = String.valueOf(relativePath) + (relativePath.length() == 0 ? "" : "/");
        relativePath = this.escapeWhitespaces(relativePath);
        HashMap<String, String> extensionToRuleStringMap = new HashMap<String, String>();
        this.getOutputExtensions();
        Iterator iter = this.buildTools.iterator();
        while (iter.hasNext()) {
            List extensionsList = ((ITool)iter.next()).getInputExtensions();
            Iterator exListIterator = extensionsList.iterator();
            while (exListIterator.hasNext()) {
                String extensionName = exListIterator.next().toString();
                if (extensionToRuleStringMap.containsKey(extensionName) || this.getOutputExtensions().contains(extensionName)) continue;
                StringBuffer macroName = this.getMacroName(extensionName);
                StringBuffer tempBuffer = new StringBuffer();
                tempBuffer.append(macroName + " " + "+=" + " " + "\\\n");
                tempBuffer.append("${addprefix $(ROOT)/" + relativePath + "," + " " + "\\\n");
                extensionToRuleStringMap.put(extensionName, tempBuffer.toString());
            }
        }
        StringBuffer buffer = new StringBuffer();
        StringBuffer ruleBuffer = new StringBuffer("# " + ManagedMakeMessages.getResourceString(MOD_RULES) + IManagedBuilderMakefileGenerator.NEWLINE);
        IResource[] resources = module.members();
        IConfiguration config = this.info.getDefaultConfiguration();
        int i = 0;
        while (i < resources.length) {
            String ext;
            IResourceConfiguration resConfig;
            IResource resource = resources[i];
            if (resource.getType() == 1 && ((resConfig = config.getResourceConfiguration(resource.getFullPath().toString())) == null || !resConfig.isExcluded()) && this.info.buildsFileType(ext = resource.getFileExtension())) {
                StringBuffer bufferForExtension = new StringBuffer();
                if (extensionToRuleStringMap.containsKey(ext)) {
                    bufferForExtension.append(extensionToRuleStringMap.get(ext).toString());
                }
                if (bufferForExtension != null && !this.getOutputExtensions().contains(bufferForExtension.toString())) {
                    bufferForExtension.append(String.valueOf(resource.getName()) + " " + "\\\n");
                    extensionToRuleStringMap.put(ext, bufferForExtension.toString());
                    this.addRule(relativePath, ruleBuffer, resource);
                }
            }
            ++i;
        }
        Collection bufferCollection = extensionToRuleStringMap.values();
        Iterator collectionIterator = bufferCollection.iterator();
        while (collectionIterator.hasNext()) {
            StringBuffer currentBuffer = new StringBuffer();
            currentBuffer.append(collectionIterator.next().toString());
            currentBuffer.append("}" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append(currentBuffer);
        }
        return buffer.append(ruleBuffer + IManagedBuilderMakefileGenerator.NEWLINE);
    }

    private StringBuffer addSubdirectories() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(MOD_LIST) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("SUBDIRS := \\\n");
        ListIterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer container = (IContainer)iter.next();
            this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.adding.source.folder", container.getFullPath().toString()));
            if (container.getFullPath() == this.project.getFullPath()) {
                buffer.append(". \\\n");
                continue;
            }
            IPath path = container.getProjectRelativePath();
            buffer.append(String.valueOf(path.toString()) + " " + "\\\n");
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer;
    }

    private StringBuffer addTargets(boolean rebuild) {
        StringBuffer buffer = new StringBuffer();
        String cmd = this.info.getToolForConfiguration(this.extension);
        String flags = this.info.getFlagsForConfiguration(this.extension);
        String outflag = this.info.getOutputFlag(this.extension);
        String outputPrefix = this.info.getOutputPrefix(this.extension);
        String targets = rebuild ? "clean all" : "all";
        IProject[] refdProjects = null;
        try {
            refdProjects = this.project.getReferencedProjects();
        }
        catch (CoreException coreException) {}
        String defaultTarget = "all:";
        buffer.append(String.valueOf(defaultTarget) + " " + outputPrefix + this.buildTargetName);
        if (this.extension.length() > 0) {
            buffer.append("." + this.extension);
        }
        buffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        Vector<String> managedProjectOutputs = new Vector<String>(refdProjects.length);
        if (refdProjects.length > 0) {
            boolean addDeps = true;
            if (refdProjects != null) {
                int i = 0;
                while (i < refdProjects.length) {
                    IProject dep = refdProjects[i];
                    if (dep.exists()) {
                        if (addDeps) {
                            buffer.append("dependents:" + IManagedBuilderMakefileGenerator.NEWLINE);
                            addDeps = false;
                        }
                        String buildDir = dep.getLocation().toString();
                        String depTargets = targets;
                        if (ManagedBuildManager.manages((IResource)dep)) {
                            IManagedBuildInfo depInfo = ManagedBuildManager.getBuildInfo((IResource)dep);
                            buildDir = String.valueOf(buildDir) + "/" + depInfo.getConfigurationName();
                            String depTarget = depInfo.getBuildArtifactName();
                            String depExt = depInfo.getBuildArtifactExtension();
                            String depPrefix = depInfo.getOutputPrefix(depExt);
                            if (depInfo.needsRebuild()) {
                                depTargets = "clean all";
                            }
                            String dependency = String.valueOf(buildDir) + "/" + depPrefix + depTarget;
                            if (depExt.length() > 0) {
                                dependency = String.valueOf(dependency) + "." + depExt;
                            }
                            dependency = this.escapeWhitespaces(dependency);
                            managedProjectOutputs.add(dependency);
                        }
                        buffer.append("\t-cd " + this.escapeWhitespaces(buildDir) + " " + "&&" + " " + "$(MAKE) " + depTargets + IManagedBuilderMakefileGenerator.NEWLINE);
                    }
                    ++i;
                }
            }
            buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        }
        buffer.append(String.valueOf(outputPrefix) + this.buildTargetName);
        if (this.extension.length() > 0) {
            buffer.append("." + this.extension);
        }
        buffer.append(": $(OBJS)");
        ListIterator refIter = managedProjectOutputs.listIterator();
        while (refIter.hasNext()) {
            buffer.append(" " + (String)refIter.next());
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t@echo '" + MESSAGE_START_BUILD + " " + "$@" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t" + cmd + " " + flags + " " + outflag + " " + "$@" + " " + "$(OBJS) $(USER_OBJS) $(LIBS)" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t@echo '" + MESSAGE_FINISH_FILE + " " + "$@" + "'" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("clean:" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t-$(RM) $(OBJS) $(DEPS) " + outputPrefix + this.buildTargetName);
        if (this.extension.length() > 0) {
            buffer.append("." + this.extension);
        }
        buffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append(".PHONY: all clean dependents" + IManagedBuilderMakefileGenerator.NEWLINE);
        refIter = managedProjectOutputs.listIterator();
        while (refIter.hasNext()) {
            buffer.append(String.valueOf((String)refIter.next()) + ":" + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(ROOT)/makefile.targets" + IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer;
    }

    protected StringBuffer addTopHeader() {
        return this.addDefaultHeader();
    }

    protected void appendBuildSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (resource.getProjectRelativePath().toString().indexOf(" ") != -1) {
            if (!this.getInvalidDirList().contains(container)) {
                this.getInvalidDirList().add(container);
            }
        } else if (!this.getSubdirList().contains(container)) {
            this.getSubdirList().add(container);
        }
    }

    protected void appendDeletedFile(IResource resource) {
        this.getDeletedFileList().add(resource);
    }

    protected void appendModifiedSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (resource.getProjectRelativePath().toString().indexOf(" ") != -1) {
            if (!this.getInvalidDirList().contains(container)) {
                this.getInvalidDirList().add(container);
            }
        } else if (!this.getModifiedList().contains(container)) {
            this.getModifiedList().add(container);
        }
    }

    protected void cancel(String message) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            throw new OperationCanceledException(message);
        }
    }

    protected void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true);
            }
        }
        return folder.getFullPath();
    }

    private IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    private void deleteBuildTarget(IResource deletedFile) {
        String fileName = this.getFileName(deletedFile);
        String srcExtension = deletedFile.getFileExtension();
        String targetExtension = this.info.getOutputExtension(srcExtension);
        if (targetExtension != "") {
            fileName = String.valueOf(fileName) + "." + targetExtension;
        }
        IPath projectRelativePath = deletedFile.getProjectRelativePath().removeLastSegments(1);
        IPath targetFilePath = this.getBuildWorkingDir().append(projectRelativePath).append(fileName);
        IResource depFile = this.project.findMember(targetFilePath);
        if (depFile != null && depFile.exists()) {
            try {
                depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    private void deleteDepFile(IResource deletedFile) {
        String fileName = this.getFileName(deletedFile);
        fileName = String.valueOf(fileName) + ".d";
        IPath projectRelativePath = deletedFile.getProjectRelativePath().removeLastSegments(1);
        IPath depFilePath = this.getBuildWorkingDir().append(projectRelativePath).append(fileName);
        IResource depFile = this.project.findMember(depFilePath);
        if (depFile != null && depFile.exists()) {
            try {
                depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    protected String escapeWhitespaces(String path) {
        String[] segments = path.split("\\s");
        if (segments.length > 1) {
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    public void generateDependencies() throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        ListIterator subDirs = this.getSubdirList().listIterator();
        while (subDirs.hasNext()) {
            IContainer subDir = (IContainer)subDirs.next();
            IPath projectRelativePath = subDir.getProjectRelativePath();
            IPath buildRelativePath = this.topBuildDir.append(projectRelativePath);
            IFolder buildFolder = root.getFolder(buildRelativePath);
            if (buildFolder == null) continue;
            IResource[] files = buildFolder.members();
            int index = 0;
            while (index < files.length) {
                IFile depFile;
                IResource file = files[index];
                if ("d".equals(file.getFileExtension()) && (depFile = root.getFile(file.getFullPath())) != null) {
                    try {
                        this.updateMonitor(ManagedMakeMessages.getFormattedString("GnuMakefileGenerator.message.postproc.dep.file", depFile.getName()));
                        this.populateDummyTargets(depFile, false);
                    }
                    catch (CoreException e) {
                        throw e;
                    }
                    catch (IOException iOException) {}
                }
                ++index;
            }
        }
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        MultiStatus status;
        IFolder folder = this.project.getFolder(this.info.getConfigurationName());
        if (!folder.exists()) {
            return this.regenerateMakefiles();
        }
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.calc.delta", this.project.getName()));
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this, this.info);
        delta.accept((IResourceDeltaVisitor)visitor);
        this.checkCancel();
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.finding.sources", this.project.getName()));
        ResourceProxyVisitor resourceVisitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)resourceVisitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null));
            return status2;
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        this.checkCancel();
        IPath srcsFilePath = this.topBuildDir.addTrailingSeparator().append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IPath fragmentPath;
            IFile makeFragment;
            IContainer subdirectory = (IContainer)iter.next();
            if (this.getModifiedList().contains(subdirectory) || (makeFragment = this.project.getFile(fragmentPath = this.getBuildWorkingDir().append(subdirectory.getProjectRelativePath()).addTrailingSeparator().append("subdir.mk"))).exists()) continue;
            this.getModifiedList().add(subdirectory);
        }
        iter = this.getDeletedFileList().listIterator();
        while (iter.hasNext()) {
            IResource deletedFile = (IResource)iter.next();
            this.deleteDepFile(deletedFile);
            this.deleteBuildTarget(deletedFile);
        }
        IPath makefilePath = this.topBuildDir.addTrailingSeparator().append("makefile");
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, false);
        this.checkCancel();
        iter = this.getModifiedList().listIterator();
        while (iter.hasNext()) {
            IContainer subDir = (IContainer)iter.next();
            this.populateFragmentMakefile(subDir);
            this.checkCancel();
        }
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iter = this.getInvalidDirList().iterator();
            while (iter.hasNext()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iter.next()).getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    public IPath getBuildWorkingDir() {
        if (this.topBuildDir != null) {
            return this.topBuildDir.removeFirstSegments(1);
        }
        return null;
    }

    private Vector getDeletedFileList() {
        if (this.deletedFileList == null) {
            this.deletedFileList = new Vector();
        }
        return this.deletedFileList;
    }

    private Vector getDependencyMakefiles() {
        if (this.dependencyMakefiles == null) {
            this.dependencyMakefiles = new Vector();
        }
        return this.dependencyMakefiles;
    }

    private String getFileName(IResource file) {
        String answer = new String();
        String lastSegment = file.getName();
        int extensionSeparator = lastSegment.lastIndexOf(".");
        if (extensionSeparator != -1) {
            answer = lastSegment.substring(0, extensionSeparator);
        }
        return answer;
    }

    private Vector getInvalidDirList() {
        if (this.invalidDirList == null) {
            this.invalidDirList = new Vector();
        }
        return this.invalidDirList;
    }

    protected StringBuffer getMacroName(String extensionName) {
        StringBuffer macroName = new StringBuffer();
        if (extensionName.equals(extensionName.toUpperCase())) {
            macroName.append(String.valueOf(extensionName.toUpperCase()) + "_UPPER");
        } else {
            macroName.append(extensionName.toUpperCase());
        }
        macroName.append("_SRCS");
        return macroName;
    }

    public String getMakefileName() {
        return new String("makefile");
    }

    private Vector getModifiedList() {
        if (this.modifiedList == null) {
            this.modifiedList = new Vector();
        }
        return this.modifiedList;
    }

    protected Set getOutputExtensions() {
        if (this.outputExtensionsSet == null) {
            this.outputExtensionsSet = new HashSet();
            Iterator iter = this.buildTools.iterator();
            while (iter.hasNext()) {
                ITool tool = (ITool)iter.next();
                String[] outputs = tool.getOutputExtensions();
                if (outputs == null) continue;
                this.outputExtensionsSet.addAll(Arrays.asList(outputs));
            }
        }
        return this.outputExtensionsSet;
    }

    private Vector getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new Vector();
        }
        return this.ruleList;
    }

    private Vector getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new Vector();
        }
        return this.subdirList;
    }

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
        this.info = info;
        this.buildTargetName = info.getBuildArtifactName();
        this.extension = info.getBuildArtifactExtension();
        if (this.extension == null) {
            this.extension = new String();
        }
        this.buildTools = new Vector<ITool>(Arrays.asList(info.getDefaultConfiguration().getFilteredTools()));
    }

    public boolean isGeneratedResource(IResource resource) {
        IPath path = resource.getProjectRelativePath();
        String[] configNames = this.info.getConfigurationNames();
        int i = 0;
        while (i < configNames.length) {
            String name = configNames[i];
            Path root = new Path(name);
            if (root.isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void outputCommentLine(StringBuffer buffer) {
        int i = 0;
        while (i < 80) {
            buffer.append("#");
            ++i;
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
    }

    protected void populateDummyTargets(IFile makefile, boolean force) throws CoreException, IOException {
        String firstLine;
        if (makefile == null || !makefile.exists()) {
            return;
        }
        InputStream contentStream = makefile.getContents(false);
        InputStreamReader in = new InputStreamReader(contentStream);
        StringBuffer inBuffer = null;
        int chunkSize = contentStream.available();
        inBuffer = new StringBuffer(chunkSize);
        char[] readBuffer = new char[chunkSize];
        int n = in.read(readBuffer);
        while (n > 0) {
            inBuffer.append(readBuffer);
            n = in.read(readBuffer);
        }
        contentStream.close();
        if (inBuffer == null) {
            return;
        }
        String inBufferString = inBuffer.toString();
        if (!force && inBufferString.startsWith("#")) {
            return;
        }
        Vector<String> bufferTokens = new Vector<String>(Arrays.asList(inBufferString.split("\\s")));
        Vector<String> deps = new Vector<String>(bufferTokens.size());
        Iterator<String> tokenIter = bufferTokens.iterator();
        while (tokenIter.hasNext()) {
            String token = tokenIter.next();
            if (token.lastIndexOf("\\") == token.length() - 1 && token.length() > 1) {
                while (tokenIter.hasNext()) {
                    String nextToken = tokenIter.next();
                    token = String.valueOf(token) + " " + nextToken;
                    if (!nextToken.endsWith("\\")) break;
                }
            }
            deps.add(token);
        }
        deps.trimToSize();
        boolean save = false;
        StringBuffer outBuffer = null;
        try {
            firstLine = (String)deps.get(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        outBuffer = !firstLine.startsWith("#") ? this.addDefaultHeader() : new StringBuffer();
        if (firstLine.startsWith("-n")) {
            String fourthLine;
            String thirdLine;
            String secondLine;
            try {
                secondLine = (String)deps.get(1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                secondLine = new String();
            }
            if (secondLine.startsWith("'")) {
                outBuffer.append(String.valueOf(secondLine.substring(1)) + " ");
            } else {
                outBuffer.append(String.valueOf(secondLine) + " ");
            }
            try {
                thirdLine = (String)deps.get(2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                thirdLine = new String();
            }
            int lastIndex = thirdLine.lastIndexOf("'");
            if (lastIndex != -1) {
                if (lastIndex == 0) {
                    outBuffer.append(" ");
                } else {
                    outBuffer.append(thirdLine.substring(0, lastIndex - 1));
                }
            } else {
                outBuffer.append(thirdLine);
            }
            try {
                fourthLine = (String)deps.get(3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                fourthLine = new String();
            }
            outBuffer.append(String.valueOf(fourthLine) + " ");
            try {
                ListIterator iter = deps.listIterator(4);
                while (iter.hasNext()) {
                    String nextElement = (String)iter.next();
                    if (nextElement.endsWith("\\")) {
                        outBuffer.append(String.valueOf(nextElement) + IManagedBuilderMakefileGenerator.NEWLINE + " ");
                        continue;
                    }
                    outBuffer.append(String.valueOf(nextElement) + " ");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            outBuffer.append(inBuffer);
        }
        outBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        save = true;
        Iterator dummyIter = deps.iterator();
        while (dummyIter.hasNext()) {
            String dummy = (String)dummyIter.next();
            Path dep = new Path(dummy);
            String extension = dep.getFileExtension();
            if (!this.info.isHeaderFile(extension)) continue;
            outBuffer.append(String.valueOf(dummy) + ":" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        if (save) {
            Util.save((StringBuffer)outBuffer, (IFile)makefile);
        }
    }

    protected void populateFragmentMakefile(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.gen.source.makefile", moduleOutputPath.toString()));
        IPath moduleOutputDir = this.createDirectory(moduleOutputPath.toString());
        IFile modMakefile = this.createFile(moduleOutputDir.addTrailingSeparator().append("subdir.mk"));
        StringBuffer makeBuf = new StringBuffer();
        makeBuf.append(this.addFragmentMakefileHeader());
        makeBuf.append(this.addSources(module));
        Util.save((StringBuffer)makeBuf, (IFile)modMakefile);
    }

    protected void populateObjectsMakefile(IFile fileHandle) throws CoreException {
        StringBuffer macroBuffer = new StringBuffer();
        macroBuffer.append(this.addDefaultHeader());
        StringBuffer objectsBuffer = new StringBuffer();
        objectsBuffer.append("OBJS := \\\n");
        StringBuffer depFilesBuffer = new StringBuffer();
        depFilesBuffer.append("DEPS := \\\n");
        macroBuffer.append("LIBS := ");
        String[] libs = this.info.getLibsForConfiguration(this.extension);
        int i = 0;
        while (i < libs.length) {
            String string = libs[i];
            macroBuffer.append("\\\n" + string);
            ++i;
        }
        macroBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        macroBuffer.append("USER_OBJS := ");
        String[] userObjs = this.info.getUserObjectsForConfiguration(this.extension);
        int j = 0;
        while (j < userObjs.length) {
            String string = userObjs[j];
            macroBuffer.append("\\\n" + string);
            ++j;
        }
        macroBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        HashSet<String> handledInputExtensions = new HashSet<String>();
        Iterator iter = this.buildTools.iterator();
        while (iter.hasNext()) {
            ITool tool = (ITool)iter.next();
            List extensionsList = tool.getInputExtensions();
            Iterator exListIterator = extensionsList.iterator();
            while (exListIterator.hasNext()) {
                String extensionName = exListIterator.next().toString();
                if (this.getOutputExtensions().contains(extensionName) || handledInputExtensions.contains(extensionName)) continue;
                handledInputExtensions.add(extensionName);
                StringBuffer macroName = this.getMacroName(extensionName);
                String OptDotExt = "";
                if (tool.getOutputExtension(extensionName) != "") {
                    OptDotExt = "." + tool.getOutputExtension(extensionName);
                }
                objectsBuffer.append(" $(" + macroName + ":" + "$(ROOT)" + "/" + "%" + "." + extensionName + "=" + "%" + OptDotExt + ")");
                depFilesBuffer.append(" $(" + macroName + ":" + "$(ROOT)" + "/" + "%" + "." + extensionName + "=" + "%" + "." + "d" + ")");
            }
        }
        macroBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE + objectsBuffer);
        macroBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE + depFilesBuffer);
        Util.save((StringBuffer)macroBuffer, (IFile)fileHandle);
    }

    protected void populateSourcesMakefile(IFile fileHandle) throws CoreException {
        StringBuffer buffer = this.addDefaultHeader();
        HashSet<String> handledInputExtensions = new HashSet<String>();
        Iterator iter = this.buildTools.iterator();
        while (iter.hasNext()) {
            List extensionsList = ((ITool)iter.next()).getInputExtensions();
            Iterator exListIterator = extensionsList.iterator();
            while (exListIterator.hasNext()) {
                String extensionName = exListIterator.next().toString();
                if (this.getOutputExtensions().contains(extensionName) || handledInputExtensions.contains(extensionName)) continue;
                handledInputExtensions.add(extensionName);
                StringBuffer macroName = this.getMacroName(extensionName);
                buffer.append(macroName + " " + ":=" + " " + IManagedBuilderMakefileGenerator.NEWLINE);
            }
        }
        buffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + this.addSubdirectories());
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addTopHeader());
        buffer.append(this.addMacros());
        buffer.append(this.addTargets(rebuild));
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    public void regenerateDependencies(boolean force) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        ListIterator iter = this.getDependencyMakefiles().listIterator();
        while (iter.hasNext()) {
            IPath relDepFilePath = this.topBuildDir.append((IPath)new Path((String)iter.next()));
            IFile depFile = root.getFile(relDepFilePath);
            if (depFile == null || !depFile.isAccessible()) continue;
            try {
                this.updateMonitor(ManagedMakeMessages.getFormattedString("GnuMakefileGenerator.message.postproc.dep.file", depFile.getName()));
                this.populateDummyTargets(depFile, true);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (IOException iOException) {}
        }
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus status;
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)visitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null));
            return status2;
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        this.checkCancel();
        IPath srcsFilePath = this.topBuildDir.addTrailingSeparator().append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer subDir = (IContainer)iter.next();
            try {
                this.populateFragmentMakefile(subDir);
            }
            catch (CoreException coreException) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        IPath makefilePath = this.topBuildDir.addTrailingSeparator().append("makefile");
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, true);
        this.checkCancel();
        IPath objFilePath = this.topBuildDir.addTrailingSeparator().append("objects.mk");
        IFile objsFileHandle = this.createFile(objFilePath);
        this.populateObjectsMakefile(objsFileHandle);
        this.checkCancel();
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iter = this.getInvalidDirList().iterator();
            while (iter.hasNext()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iter.next()).getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    protected void updateMonitor(String msg) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            this.monitor.subTask(msg);
            this.monitor.worked(1);
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private GnuMakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceDeltaVisitor(GnuMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.info = info;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean keepLooking = false;
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                String ext = resource.getFileExtension();
                switch (delta.getKind()) {
                    case 1: {
                        if (this.generator.isGeneratedResource(resource) || !this.info.buildsFileType(ext)) break;
                        this.generator.appendModifiedSubdirectory(resource);
                        break;
                    }
                    case 2: {
                        if (this.generator.isGeneratedResource(resource) || !this.info.buildsFileType(ext)) break;
                        this.generator.appendModifiedSubdirectory(resource);
                        this.generator.appendDeletedFile(resource);
                        break;
                    }
                    default: {
                        keepLooking = true;
                    }
                }
            }
            if (resource.getType() == 4) {
                IResourceDelta[] children = delta.getAffectedChildren();
                if (children != null && children.length > 0) {
                    keepLooking = true;
                }
            } else if (!this.generator.isGeneratedResource(resource)) {
                keepLooking = true;
            }
            return keepLooking;
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private GnuMakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceProxyVisitor(GnuMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.info = info;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            if (proxy.getType() == 1) {
                IResource resource = proxy.requestResource();
                String ext = resource.getFileExtension();
                if (this.info.buildsFileType(ext) && !this.generator.isGeneratedResource(resource)) {
                    this.generator.appendBuildSubdirectory(resource);
                }
                return false;
            }
            return true;
        }
    }
}

