/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.internal.ui.OverlayImageCache;
import org.eclipse.cdt.debug.internal.ui.OverlayImageDescriptor;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class CDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    protected HashMap fAttributes = new HashMap(3);
    protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();
    private OverlayImageCache fImageCache = new OverlayImageCache();
    private static CDebugModelPresentation gfInstance = null;

    public static CDebugModelPresentation getDefault() {
        if (gfInstance == null) {
            gfInstance = new CDebugModelPresentation();
        }
        return gfInstance;
    }

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        this.getAttributes().put(attribute, value);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public IEditorInput getEditorInput(Object element) {
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        return null;
    }

    public Image getImage(Object element) {
        Image baseImage = this.getBaseImage(element);
        if (baseImage != null) {
            ImageDescriptor[] overlays = new ImageDescriptor[4];
            return this.getImageCache().getImageFor(new OverlayImageDescriptor(baseImage, overlays));
        }
        return this.getDefaultImage(element);
    }

    private Image getBaseImage(Object element) {
        if (element instanceof ICSharedLibrary) {
            return this.getSharedLibraryImage((ICSharedLibrary)element);
        }
        if (element instanceof IRegisterGroup) {
            return this.getRegisterGroupImage((IRegisterGroup)element);
        }
        if (element instanceof ICSignal) {
            return this.getSignalImage((ICSignal)element);
        }
        if (element instanceof ICBreakpoint) {
            return this.getBreakpointImage((ICBreakpoint)element);
        }
        return super.getImage(element);
    }

    protected Image getSharedLibraryImage(ICSharedLibrary element) {
        if (element.areSymbolsLoaded()) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
            imageDescriptorArray[1] = CDebugImages.DESC_OVRS_SYMBOLS;
            return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.getDebugImageRegistry().get(CDebugImages.DESC_OBJS_LOADED_SHARED_LIBRARY), imageDescriptorArray));
        }
        return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SHARED_LIBRARY);
    }

    protected Image getSignalImage(ICSignal signal) {
        return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SIGNAL);
    }

    protected Image getRegisterGroupImage(IRegisterGroup element) {
        return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_GROUP);
    }

    protected Image getBreakpointImage(ICBreakpoint breakpoint) {
        try {
            if (breakpoint instanceof ICLineBreakpoint) {
                return this.getLineBreakpointImage((ICLineBreakpoint)breakpoint);
            }
            if (breakpoint instanceof ICWatchpoint) {
                return this.getWatchpointImage((ICWatchpoint)breakpoint);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected Image getLineBreakpointImage(ICLineBreakpoint breakpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = breakpoint.isEnabled() ? CDebugImages.DESC_OBJS_BREAKPOINT_ENABLED : CDebugImages.DESC_OBJS_BREAKPOINT_DISABLED;
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeBreakpointOverlays((ICBreakpoint)breakpoint)));
    }

    protected Image getWatchpointImage(ICWatchpoint watchpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = watchpoint.isEnabled() ? (watchpoint.isReadType() && !watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_ENABLED : (!watchpoint.isReadType() && watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_ENABLED : CDebugImages.DESC_OBJS_WATCHPOINT_ENABLED)) : (watchpoint.isReadType() && !watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_DISABLED : (!watchpoint.isReadType() && watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_DISABLED : CDebugImages.DESC_OBJS_WATCHPOINT_DISABLED));
        return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeBreakpointOverlays((ICBreakpoint)watchpoint)));
    }

    public String getText(Object element) {
        StringBuffer baseText = new StringBuffer(this.getBaseText(element));
        return baseText.toString();
    }

    private String getBaseText(Object element) {
        boolean showQualified = this.isShowQualifiedNames();
        StringBuffer label = new StringBuffer();
        if (element instanceof ICSharedLibrary) {
            label.append(this.getSharedLibraryText((ICSharedLibrary)element, showQualified));
            return label.toString();
        }
        if (element instanceof IRegisterGroup) {
            label.append(this.getRegisterGroupText((IRegisterGroup)element));
            return label.toString();
        }
        if (label.length() > 0) {
            return label.toString();
        }
        return this.getDefaultText(element);
    }

    protected String getSharedLibraryText(ICSharedLibrary library, boolean qualified) {
        String label = new String();
        String name = library.getFileName();
        if (!this.isEmpty(name)) {
            Path path = new Path(library.getFileName());
            if (!path.isEmpty()) {
                label = String.valueOf(label) + (qualified ? path.toOSString() : path.lastSegment());
            }
        } else {
            label = String.valueOf(label) + CDebugUIMessages.getString("CDebugModelPresentation.unknown_1");
        }
        return label;
    }

    protected String getRegisterGroupText(IRegisterGroup group) {
        String name = CDebugUIMessages.getString("CDebugModelPresentation.not_available_1");
        try {
            name = group.getName();
        }
        catch (DebugException e) {
            CDebugUIPlugin.log(e.getStatus());
        }
        return name;
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.getAttributes().get(DISPLAY_FULL_PATHS);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    private HashMap getAttributes() {
        return this.fAttributes;
    }

    private OverlayImageCache getImageCache() {
        return this.fImageCache;
    }

    private CDebugImageDescriptorRegistry getDebugImageRegistry() {
        return this.fDebugImageRegistry;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected String getDefaultText(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getText(element);
    }

    protected Image getDefaultImage(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getImage(element);
    }

    private ImageDescriptor[] computeBreakpointOverlays(ICBreakpoint breakpoint) {
        ImageDescriptor[] overlays = new ImageDescriptor[4];
        try {
            if (breakpoint.isConditional()) {
                ImageDescriptor imageDescriptor = overlays[0] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL : CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL_DISABLED;
            }
            if (breakpoint.isInstalled()) {
                ImageDescriptor imageDescriptor = overlays[2] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED : CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED_DISABLED;
            }
            if (breakpoint instanceof ICAddressBreakpoint) {
                ImageDescriptor imageDescriptor = overlays[1] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT : CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT_DISABLED;
            }
            if (breakpoint instanceof ICFunctionBreakpoint) {
                overlays[1] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT : CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT_DISABLED;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return overlays;
    }
}

