/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ExpressionDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class AddExpressionEditorActionDelegate
extends ActionDelegate
implements IEditorActionDelegate {
    private IEditorPart fEditorPart;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setEditorPart(targetEditor);
    }

    private IEditorPart getEditorPart() {
        return this.fEditorPart;
    }

    private void setEditorPart(IEditorPart editorPart) {
        this.fEditorPart = editorPart;
    }

    public void run(IAction action) {
        String text = this.getSelectedText();
        ExpressionDialog dlg = new ExpressionDialog(this.getShell(), text);
        if (dlg.open() != 0) {
            return;
        }
        this.createExpression(dlg.getExpression());
        this.activateExpressionView();
    }

    private String getSelectedText() {
        ISelection selection = this.getTargetSelection();
        if (selection != null && selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getText().trim();
        }
        return "";
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider provider;
        IEditorPart part = this.getEditorPart();
        if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    private void createExpression(String text) {
        IWatchExpression watchExpression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(text);
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)watchExpression);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof IDebugElement) {
            watchExpression.setExpressionContext((IDebugElement)context);
        }
    }

    protected Shell getShell() {
        return this.getEditorPart() != null ? this.getEditorPart().getSite().getShell() : CDebugUIPlugin.getActiveWorkbenchShell();
    }

    private void activateExpressionView() {
        IWorkbenchPage page;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                page.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException partInitException) {}
        }
    }
}

