/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.internal.ui.actions.BreakpointLocationVerifier;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    static /* synthetic */ Class class$0;

    /*
     * Enabled aggressive block sorting
     */
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        String errorMessage = null;
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            IEditorInput input = textEditor.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_document_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IResource resource = ToggleBreakpointAdapter.getResource((IWorkbenchPart)textEditor);
            if (resource == null) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_resource_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
            int lineNumber = bv.getValidLineBreakpointLocation(document, ((ITextSelection)selection).getStartLine());
            if (lineNumber == -1) {
                errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            String sourceHandle = this.getSourceHandle(input);
            ICLineBreakpoint breakpoint = CDIDebugModel.lineBreakpointExists((String)sourceHandle, (IResource)resource, (int)lineNumber);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                return;
            }
            CDIDebugModel.createLineBreakpoint((String)sourceHandle, (IResource)resource, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
            return;
        }
        if (!(part instanceof DisassemblyView)) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IEditorInput input = ((DisassemblyView)part).getInput();
        if (!(input instanceof DisassemblyEditorInput)) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
        int lineNumber = bv.getValidAddressBreakpointLocation(null, ((ITextSelection)selection).getStartLine());
        if (lineNumber == -1) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
        if (address == null) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ICLineBreakpoint breakpoint = ((DisassemblyEditorInput)input).breakpointExists(address);
        if (breakpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            return;
        }
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        String sourceHandle = this.getSourceHandle(input);
        CDIDebugModel.createAddressBreakpoint((String)sourceHandle, (IResource)resource, (IAddress)address, (boolean)true, (int)0, (String)"", (boolean)true);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        IEditorInput input;
        if (part instanceof DisassemblyView && (!((input = ((DisassemblyView)part).getInput()) instanceof DisassemblyEditorInput) || ((DisassemblyEditorInput)input).equals(DisassemblyEditorInput.EMPTY_EDITOR_INPUT))) {
            return false;
        }
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (ss.getFirstElement() instanceof IFunction || ss.getFirstElement() instanceof IMethod)) {
            String functionName;
            IResource resource;
            IDeclaration declaration = (IDeclaration)ss.getFirstElement();
            String sourceHandle = this.getSourceHandle(declaration);
            ICFunctionBreakpoint breakpoint = CDIDebugModel.functionBreakpointExists((String)sourceHandle, (IResource)(resource = this.getElementResource(declaration)), (String)(functionName = declaration instanceof IFunction ? this.getFunctionName((IFunction)declaration) : this.getMethodName((IMethod)declaration)));
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            } else {
                int lineNumber = -1;
                int charStart = -1;
                int charEnd = -1;
                try {
                    ISourceRange sourceRange = declaration.getSourceRange();
                    if (sourceRange != null) {
                        charStart = sourceRange.getStartPos();
                        charEnd = charStart + sourceRange.getLength();
                        if (charEnd <= 0) {
                            charStart = -1;
                            charEnd = -1;
                        }
                        lineNumber = sourceRange.getStartLine();
                    }
                }
                catch (CModelException e) {
                    DebugPlugin.log((Throwable)e);
                }
                CDIDebugModel.createFunctionBreakpoint((String)sourceHandle, (IResource)resource, (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement() instanceof IFunction || ss.getFirstElement() instanceof IMethod;
        }
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ss.getFirstElement() instanceof IVariable) {
            this.toggleVariableWatchpoint(part, (IVariable)ss.getFirstElement());
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement() instanceof IVariable;
        }
        return false;
    }

    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)part.getAdapter((Class)clazz)) != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && CDebugUIPlugin.getActiveWorkbenchShell() != null) {
            CDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected static IResource getResource(IWorkbenchPart part) {
        IEditorInput editorInput;
        if (part instanceof IEditorPart && (editorInput = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private String getSourceHandle(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocation().toOSString();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getFullPath().toOSString();
        }
        if (input instanceof DisassemblyEditorInput) {
            return ((DisassemblyEditorInput)input).getModuleFile();
        }
        return "";
    }

    private void toggleVariableWatchpoint(IWorkbenchPart part, IVariable variable) throws CoreException {
        String expression;
        IResource resource;
        String sourceHandle = this.getSourceHandle((IDeclaration)variable);
        ICWatchpoint watchpoint = CDIDebugModel.watchpointExists((String)sourceHandle, (IResource)(resource = this.getElementResource((IDeclaration)variable)), (String)(expression = this.getVariableName(variable)));
        if (watchpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)watchpoint, true);
        } else {
            AddWatchpointDialog dlg = new AddWatchpointDialog(part.getSite().getShell(), true, false, expression);
            if (dlg.open() != 0) {
                return;
            }
            expression = dlg.getExpression();
            CDIDebugModel.createWatchpoint((String)sourceHandle, (IResource)resource, (boolean)dlg.getWriteAccess(), (boolean)dlg.getReadAccess(), (String)expression, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    private String getSourceHandle(IDeclaration declaration) {
        ITranslationUnit tu = declaration.getTranslationUnit();
        if (tu != null) {
            IResource resource = tu.getResource();
            if (resource != null) {
                return resource.getLocation().toOSString();
            }
            return tu.getPath().toOSString();
        }
        return "";
    }

    private IResource getElementResource(IDeclaration declaration) {
        return declaration.getUnderlyingResource();
    }

    private String getFunctionName(IFunction function) {
        String functionName = function.getElementName();
        StringBuffer name = new StringBuffer(functionName);
        ITranslationUnit tu = function.getTranslationUnit();
        if (tu != null && tu.isCXXLanguage()) {
            this.appendParameters(name, (IFunctionDeclaration)function);
        }
        return name.toString();
    }

    private String getMethodName(IMethod method) {
        StringBuffer name = new StringBuffer();
        String methodName = method.getElementName();
        ICElement parent = method.getParent();
        while (parent != null && (parent.getElementType() == 61 || parent.getElementType() == 64)) {
            name.append(parent.getElementName()).append("::");
            parent = parent.getParent();
        }
        name.append(methodName);
        this.appendParameters(name, (IFunctionDeclaration)method);
        return name.toString();
    }

    private void appendParameters(StringBuffer sb, IFunctionDeclaration fd) {
        String[] params = fd.getParameterTypes();
        sb.append('(');
        int i = 0;
        while (i < params.length) {
            sb.append(params[i]);
            if (i != params.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(')');
    }

    private String getVariableName(IVariable variable) {
        return variable.getElementName();
    }
}

