/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.BuildGroup;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.cview.CollapseAllAction;
import org.eclipse.cdt.internal.ui.cview.GotoActionGroup;
import org.eclipse.cdt.internal.ui.cview.OpenFileGroup;
import org.eclipse.cdt.internal.ui.cview.OpenProjectGroup;
import org.eclipse.cdt.internal.ui.cview.RefactorActionGroup;
import org.eclipse.cdt.internal.ui.cview.ToggleLinkingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.cdt.ui.actions.RefactoringActionGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;

public class MainActionGroup
extends CViewActionGroup {
    AddBookmarkAction addBookmarkAction;
    AddTaskAction addTaskAction;
    PropertyDialogAction propertyDialogAction;
    ImportResourcesAction importAction;
    ExportResourcesAction exportAction;
    OpenIncludeAction openIncludeAction;
    CollapseAllAction collapseAllAction;
    ToggleLinkingAction toggleLinkingAction;
    BuildGroup buildGroup;
    OpenFileGroup openFileGroup;
    GotoActionGroup gotoGroup;
    RefactorActionGroup refactorGroup;
    OpenProjectGroup openProjectGroup;
    WorkingSetFilterActionGroup workingSetGroup;
    CustomFiltersActionGroup fCustomFiltersActionGroup;
    SelectionSearchGroup selectionSearchGroup;
    RefactoringActionGroup refactoringActionGroup;
    static /* synthetic */ Class class$0;

    public MainActionGroup(CView cview) {
        super(cview);
    }

    public void handleKeyPressed(KeyEvent event) {
        this.refactorGroup.handleKeyPressed(event);
        this.openFileGroup.handleKeyPressed(event);
        this.openProjectGroup.handleKeyPressed(event);
        this.gotoGroup.handleKeyPressed(event);
        this.buildGroup.handleKeyPressed(event);
    }

    public void handleKeyReleased(KeyEvent event) {
        this.refactorGroup.handleKeyReleased(event);
        this.openFileGroup.handleKeyReleased(event);
        this.openProjectGroup.handleKeyReleased(event);
        this.gotoGroup.handleKeyReleased(event);
        this.buildGroup.handleKeyReleased(event);
    }

    protected void makeActions() {
        TreeViewer viewer = this.getCView().getViewer();
        Shell shell = this.getCView().getViewSite().getShell();
        this.openFileGroup = new OpenFileGroup(this.getCView());
        this.openProjectGroup = new OpenProjectGroup(this.getCView());
        this.gotoGroup = new GotoActionGroup(this.getCView());
        this.buildGroup = new BuildGroup(this.getCView());
        this.refactorGroup = new RefactorActionGroup(this.getCView());
        this.openIncludeAction = new OpenIncludeAction((ISelectionProvider)viewer);
        IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    Object newValue = event.getNewValue();
                    if (newValue instanceof IWorkingSet) {
                        MainActionGroup.this.getCView().setWorkingSet((IWorkingSet)newValue);
                    } else if (newValue == null) {
                        MainActionGroup.this.getCView().setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetGroup = new WorkingSetFilterActionGroup(shell, workingSetUpdater);
        this.workingSetGroup.setWorkingSet(this.getCView().getWorkingSet());
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this.getCView(), (StructuredViewer)this.getCView().getViewer());
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.addTaskAction = new AddTaskAction(shell);
        this.propertyDialogAction = new PropertyDialogAction(shell, (ISelectionProvider)viewer);
        this.importAction = new ImportResourcesAction(this.getCView().getSite().getWorkbenchWindow());
        this.exportAction = new ExportResourcesAction(this.getCView().getSite().getWorkbenchWindow());
        this.collapseAllAction = new CollapseAllAction(this.getCView());
        this.toggleLinkingAction = new ToggleLinkingAction(this.getCView());
        this.toggleLinkingAction.setToolTipText(CViewMessages.getString("ToggleLinkingAction.toolTip"));
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/synced.gif"));
        this.selectionSearchGroup = new SelectionSearchGroup((IWorkbenchSite)this.getCView().getSite());
        this.refactoringActionGroup = new RefactoringActionGroup((IWorkbenchSite)this.getCView().getSite(), null);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection celements = (IStructuredSelection)this.getCView().getViewer().getSelection();
        IStructuredSelection resources = SelectionConverter.convertSelectionToResources((ISelection)celements);
        if (resources.isEmpty()) {
            new NewWizardMenu(menu, this.getCView().getSite().getWorkbenchWindow(), false);
            menu.add((IContributionItem)new Separator("group.reorganize"));
            this.refactoringActionGroup.fillContextMenu(menu);
            menu.add((IContributionItem)new Separator());
            this.importAction.selectionChanged(resources);
            menu.add((IAction)this.importAction);
            this.exportAction.selectionChanged(resources);
            menu.add((IAction)this.exportAction);
            menu.add((IContributionItem)new Separator());
            this.addSearchMenu(menu, celements);
            menu.add((IContributionItem)new Separator("additions"));
            menu.add((IContributionItem)new Separator("additions-end"));
            menu.add((IContributionItem)new Separator());
            return;
        }
        this.addNewMenu(menu, resources);
        menu.add((IContributionItem)new Separator());
        this.gotoGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.openFileGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.buildGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.refactorGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.importAction.selectionChanged(resources);
        menu.add((IAction)this.importAction);
        this.exportAction.selectionChanged(resources);
        menu.add((IAction)this.exportAction);
        menu.add((IContributionItem)new Separator());
        this.openProjectGroup.fillContextMenu(menu);
        this.addBookMarkMenu(menu, resources);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        this.addPropertyMenu(menu, resources);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.gotoGroup.setContext(context);
        this.openFileGroup.setContext(context);
        this.openProjectGroup.setContext(context);
        this.refactorGroup.setContext(context);
        this.buildGroup.setContext(context);
    }

    void addNewMenu(IMenuManager menu, IStructuredSelection selection) {
        MenuManager newMenu = new MenuManager(CViewMessages.getString("NewWizardsActionGroup.new"));
        new NewWizardMenu((IMenuManager)newMenu, this.getCView().getSite().getWorkbenchWindow(), false);
        menu.add((IContributionItem)newMenu);
    }

    void addBookMarkMenu(IMenuManager menu, IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj instanceof IAdaptable) {
            IResource resource;
            IAdaptable element = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)element.getAdapter((Class)clazz)) instanceof IFile) {
                this.addBookmarkAction.selectionChanged(selection);
                menu.add((IAction)this.addBookmarkAction);
            }
        }
    }

    void addPropertyMenu(IMenuManager menu, IStructuredSelection selection) {
        this.propertyDialogAction.selectionChanged(selection);
        if (this.propertyDialogAction.isApplicableForSelection()) {
            menu.add((IAction)this.propertyDialogAction);
        }
    }

    void addSearchMenu(IMenuManager menu, IStructuredSelection selection) {
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        if (element instanceof ITranslationUnit || element instanceof ICProject) {
            return;
        }
        if (SelectionSearchGroup.canActionBeAdded((ISelection)selection)) {
            this.selectionSearchGroup.fillContextMenu(menu);
        }
    }

    public void runDefaultAction(IStructuredSelection selection) {
        this.openFileGroup.runDefaultAction(selection);
        this.openProjectGroup.runDefaultAction(selection);
        this.gotoGroup.runDefaultAction(selection);
        this.buildGroup.runDefaultAction(selection);
        this.refactorGroup.runDefaultAction(selection);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.propertyDialogAction.setEnabled(selection.size() == 1);
        this.addBookmarkAction.selectionChanged(selection);
        this.addTaskAction.selectionChanged(selection);
        this.openFileGroup.updateActionBars();
        this.openProjectGroup.updateActionBars();
        this.gotoGroup.updateActionBars();
        this.buildGroup.updateActionBars();
        this.refactorGroup.updateActionBars();
        this.workingSetGroup.updateActionBars();
        this.fCustomFiltersActionGroup.updateActionBars();
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
        this.workingSetGroup.fillActionBars(actionBars);
        this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        this.gotoGroup.fillActionBars(actionBars);
        this.refactorGroup.fillActionBars(actionBars);
        this.openFileGroup.fillActionBars(actionBars);
        this.openProjectGroup.fillActionBars(actionBars);
        this.buildGroup.fillActionBars(actionBars);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.collapseAllAction);
        toolBar.add((IAction)this.toggleLinkingAction);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.toggleLinkingAction);
    }

    public void restoreFilterAndSorterState(IMemento memento) {
        this.fCustomFiltersActionGroup.restoreState(memento);
    }

    public void saveFilterAndSorterState(IMemento memento) {
        this.fCustomFiltersActionGroup.saveState(memento);
    }

    public CustomFiltersActionGroup getCustomFilterActionGroup() {
        return this.fCustomFiltersActionGroup;
    }

    public void dispose() {
        this.importAction.dispose();
        this.exportAction.dispose();
        this.refactorGroup.dispose();
        this.openFileGroup.dispose();
        this.openProjectGroup.dispose();
        this.gotoGroup.dispose();
        this.buildGroup.dispose();
        super.dispose();
    }
}

