/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;

public abstract class ACBuilder
extends IncrementalProjectBuilder
implements IMarkerGenerator {
    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        try {
            IMarker[] cur = file.findMarkers("org.eclipse.cdt.core.problem", false, 1);
            if (cur != null && cur.length > 0) {
                int i = 0;
                while (i < cur.length) {
                    int line = (Integer)cur[i].getAttribute("location");
                    int sev = (Integer)cur[i].getAttribute("severity");
                    String mesg = (String)cur[i].getAttribute("message");
                    if (line == lineNumber && sev == this.mapMarkerSeverity(severity) && mesg.equals(errorDesc)) {
                        return;
                    }
                    ++i;
                }
            }
            IMarker marker = file.createMarker("org.eclipse.cdt.core.problem");
            marker.setAttribute("location", lineNumber);
            marker.setAttribute("message", (Object)errorDesc);
            marker.setAttribute("severity", this.mapMarkerSeverity(severity));
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
            if (errorVar != null) {
                marker.setAttribute("problem.variable", (Object)errorVar);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }
}

