/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class CSearchScopeFactory {
    private static CSearchScopeFactory fgInstance;
    private static ICSearchScope EMPTY_SCOPE;
    static /* synthetic */ Class class$0;

    static {
        EMPTY_SCOPE = SearchEngine.createCSearchScope((ICElement[])new ICElement[0]);
    }

    public static CSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new CSearchScopeFactory();
        }
        return fgInstance;
    }

    public ICSearchScope createCSearchScope(IWorkingSet[] sets) {
        if (sets == null || sets.length < 1) {
            return EMPTY_SCOPE;
        }
        HashSet cElements = new HashSet(sets.length * 10);
        int i = 0;
        while (i < sets.length) {
            this.addCElements(cElements, sets[i]);
            ++i;
        }
        return this.createCSearchScope(cElements);
    }

    private ICSearchScope createCSearchScope(Set cElements) {
        return SearchEngine.createCSearchScope((ICElement[])cElements.toArray(new ICElement[cElements.size()]));
    }

    private void addCElements(Set cElements, IWorkingSet set) {
        if (set == null) {
            return;
        }
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ICElement) {
                this.addCElements(cElements, (ICElement)elements[i]);
            } else {
                this.addCElements(cElements, elements[i]);
            }
            ++i;
        }
    }

    private void addCElements(Set cElements, IAdaptable resource) {
        ICElement cElement;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cElement = (ICElement)resource.getAdapter((Class)clazz)) == null) {
            return;
        }
        this.addCElements(cElements, cElement);
    }

    private void addCElements(Set cElements, ICElement element) {
        cElements.add(element);
    }

    public ICSearchScope createCSearchScope(IStructuredSelection fStructuredSelection) {
        HashSet cElements = new HashSet(fStructuredSelection.size());
        Iterator iter = fStructuredSelection.iterator();
        while (iter.hasNext()) {
            Object tempObj = iter.next();
            if (tempObj instanceof ICElement) {
                this.addCElements(cElements, (ICElement)tempObj);
                continue;
            }
            if (tempObj instanceof BasicSearchMatch) {
                this.addCElements(cElements, (BasicSearchMatch)tempObj);
                continue;
            }
            if (!(tempObj instanceof IResource)) continue;
            this.addCElements(cElements, (IAdaptable)((IResource)tempObj));
        }
        return this.createCSearchScope(cElements);
    }

    private void addCElements(Set elements, BasicSearchMatch match) {
        ICElement cTransUnit;
        IResource tempResource = match.getResource();
        if (tempResource != null && (cTransUnit = CCorePlugin.getDefault().getCoreModel().create(tempResource)) != null) {
            elements.add(cTransUnit);
        }
    }

    public IWorkingSet[] queryWorkingSets() {
        IWorkingSet[] workingSets;
        Shell shell = CUIPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }
}

