/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CreateElementInTUOperation;
import org.eclipse.cdt.internal.core.model.MultiOperation;

public class CopyElementsOperation
extends MultiOperation {
    public CopyElementsOperation(ICElement[] elementsToCopy, ICElement[] destContainers, boolean force) {
        super(elementsToCopy, destContainers, force);
    }

    public CopyElementsOperation(ICElement[] elementsToCopy, ICElement destContainer, boolean force) {
        this(elementsToCopy, new ICElement[]{destContainer}, force);
    }

    protected String getMainTaskName() {
        return "operation.copyElementProgress";
    }

    protected CModelOperation getNestedOperation(ICElement element) {
        element.getElementType();
        return null;
    }

    protected void processElement(ICElement element) throws CModelException {
        CModelOperation op = this.getNestedOperation(element);
        if (op == null) {
            return;
        }
        boolean isInTUOperation = op instanceof CreateElementInTUOperation;
        if (isInTUOperation) {
            ICElement anchor;
            CreateElementInTUOperation inTUop = (CreateElementInTUOperation)op;
            ICElement sibling = (ICElement)this.fInsertBeforeElements.get(element);
            if (sibling != null) {
                inTUop.setRelativePosition(sibling, 3);
            } else if (this.isRename() && (anchor = this.resolveRenameAnchor(element)) != null) {
                inTUop.setRelativePosition(anchor, 2);
            }
            String newName = this.getNewNameFor(element);
            if (newName != null) {
                inTUop.setAlteredName(newName);
            }
        }
        this.executeNestedOperation(op, 1);
    }

    private ICElement resolveRenameAnchor(ICElement element) throws CModelException {
        IParent parent = (IParent)((Object)element.getParent());
        ICElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            ICElement child = children[i];
            if (child.equals(element)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected ICModelStatus verify() {
        ICModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fRenamingsList != null && this.fRenamingsList.length != this.fElementsToProcess.length) {
            return new CModelStatus(980);
        }
        return CModelStatus.VERIFIED_OK;
    }

    protected void verify(ICElement element) throws CModelException {
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.getElementType() < 60) {
            this.error(967, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        ICElement dest = this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        this.verifySibling(element, dest);
        if (this.fRenamingsList != null) {
            this.verifyRenaming(element);
        }
    }
}

