/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIMemoryChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlockRow;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class CFormattedMemoryBlock
extends CDebugElement
implements IFormattedMemoryBlock,
ICDIEventListener {
    private ICDIExpression fAddressExpression;
    private ICDIMemoryBlock fCDIMemoryBlock;
    private byte[] fBytes = null;
    private int fFormat;
    private int fWordSize;
    private int fNumberOfRows;
    private int fNumberOfColumns;
    private boolean fDisplayAscii = true;
    private char fPaddingChar = (char)46;
    private List fRows = null;
    private IAddress[] fChangedAddresses = new IAddress[0];
    private boolean fStartAddressChanged = false;
    static /* synthetic */ Class class$0;

    public CFormattedMemoryBlock(CDebugTarget target, ICDIMemoryBlock cdiMemoryBlock, ICDIExpression addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns) {
        this(target, cdiMemoryBlock, addressExpression, format, wordSize, numberOfRows, numberOfColumns, '\u0000');
    }

    public CFormattedMemoryBlock(CDebugTarget target, ICDIMemoryBlock cdiMemoryBlock, ICDIExpression addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) {
        super(target);
        this.fCDIMemoryBlock = cdiMemoryBlock;
        this.fAddressExpression = addressExpression;
        this.fFormat = format;
        this.fWordSize = wordSize;
        this.fNumberOfRows = numberOfRows;
        this.fNumberOfColumns = numberOfColumns;
        this.fDisplayAscii = true;
        this.fPaddingChar = paddingChar;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public int getFormat() {
        return this.fFormat;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public int getNumberOfRows() {
        return this.fNumberOfRows;
    }

    public int getNumberOfColumns() {
        return this.fNumberOfColumns;
    }

    public boolean displayASCII() {
        return this.getWordSize() == 1 && this.fDisplayAscii;
    }

    public IFormattedMemoryBlockRow[] getRows() {
        if (this.fRows == null) {
            this.fRows = new ArrayList();
            try {
                int offset = 0;
                byte[] bytes = this.getBytes();
                while (bytes != null && offset < bytes.length) {
                    int length = Math.min(this.fWordSize * this.fNumberOfColumns, bytes.length - offset);
                    this.fRows.add(new CFormattedMemoryBlockRow(this.getRowAddress(offset), this.createData(bytes, offset, length), this.createAscii(bytes, offset, length)));
                    offset += length;
                }
            }
            catch (DebugException debugException) {}
        }
        return this.fRows.toArray(new IFormattedMemoryBlockRow[this.fRows.size()]);
    }

    private synchronized void resetBytes() {
        this.fBytes = null;
    }

    private void resetRows() {
        this.fRows = null;
    }

    public IAddress nextRowAddress() {
        return ((CDebugTarget)this.getDebugTarget()).getAddressFactory().getZero();
    }

    public IAddress previousRowAddress() {
        return ((CDebugTarget)this.getDebugTarget()).getAddressFactory().getZero();
    }

    public IAddress nextPageAddress() {
        return ((CDebugTarget)this.getDebugTarget()).getAddressFactory().getZero();
    }

    public IAddress previousPageAddress() {
        return ((CDebugTarget)this.getDebugTarget()).getAddressFactory().getZero();
    }

    public void reformat(int format, int wordSize, int numberOfRows, int numberOfColumns) throws DebugException {
        this.resetRows();
        this.fFormat = format;
        this.fWordSize = wordSize;
        this.fNumberOfRows = numberOfRows;
        this.fNumberOfColumns = numberOfColumns;
    }

    public void reformat(int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) throws DebugException {
        this.resetRows();
        this.fFormat = format;
        this.fWordSize = wordSize;
        this.fNumberOfRows = numberOfRows;
        this.fNumberOfColumns = numberOfColumns;
        this.fPaddingChar = paddingChar;
    }

    public long getStartAddress() {
        return 0L;
    }

    public IAddress getRealStartAddress() {
        IAddressFactory factory = ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
        if (this.fCDIMemoryBlock != null) {
            return factory.createAddress(this.fCDIMemoryBlock.getStartAddress());
        }
        return factory.getZero();
    }

    public long getLength() {
        if (this.fCDIMemoryBlock != null) {
            return this.fCDIMemoryBlock.getLength();
        }
        return 0L;
    }

    public synchronized byte[] getBytes() throws DebugException {
        if (this.fBytes == null && this.fCDIMemoryBlock != null) {
            try {
                this.fBytes = this.fCDIMemoryBlock.getBytes();
            }
            catch (CDIException e) {
                CDebugElement.targetRequestFailed(e.getMessage(), null);
            }
        }
        byte[] copyBytes = null;
        if (this.fBytes != null) {
            copyBytes = new byte[this.fBytes.length];
            System.arraycopy(this.fBytes, 0, copyBytes, 0, this.fBytes.length);
        }
        return copyBytes;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
    }

    public char getPaddingCharacter() {
        return this.fPaddingChar;
    }

    public void dispose() {
        if (this.fCDIMemoryBlock != null) {
            try {
                ((CDebugTarget)this.getDebugTarget()).getCDITarget().removeBlocks(new ICDIMemoryBlock[]{this.fCDIMemoryBlock});
            }
            catch (CDIException e) {
                CDebugCorePlugin.log(e);
            }
            this.fCDIMemoryBlock = null;
        }
        if (this.fAddressExpression != null) {
            try {
                this.fAddressExpression.dispose();
            }
            catch (CDIException e) {
                CDebugCorePlugin.log(e);
            }
            this.fAddressExpression = null;
        }
        this.getCDISession().getEventManager().removeEventListener(this);
        this.fireTerminateEvent();
    }

    public String getAddressExpression() {
        return this.fAddressExpression.getExpressionText();
    }

    private String[] createData(byte[] bytes, int offset, int length) {
        ArrayList<String> data = new ArrayList<String>(length / this.getWordSize());
        int i = offset;
        while (i < offset + length) {
            data.add(this.createDataItem(bytes, i, Math.min(length + offset - i, this.getWordSize())));
            i += this.getWordSize();
        }
        return data.toArray(new String[data.size()]);
    }

    private String createDataItem(byte[] bytes, int offset, int length) {
        StringBuffer sb = new StringBuffer(length * 2);
        int i = offset;
        while (i < length + offset) {
            sb.append(CDebugUtils.getByteText(bytes[i]));
            ++i;
        }
        return sb.toString();
    }

    private String createAscii(byte[] bytes, int offset, int length) {
        StringBuffer sb = new StringBuffer(length);
        int i = offset;
        while (i < offset + length) {
            sb.append(Character.isISOControl((char)bytes[i]) || bytes[i] < 0 ? this.getPaddingCharacter() : (char)bytes[i]);
            ++i;
        }
        return sb.toString();
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source != null && source.getTarget().equals(this.getCDITarget())) {
                if (event instanceof ICDIResumedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleResumedEvent((ICDIResumedEvent)event);
                    }
                } else if (event instanceof ICDIMemoryChangedEvent) {
                    if (source instanceof ICDIMemoryBlock && source.equals(this.getCDIMemoryBlock())) {
                        this.handleChangedEvent((ICDIMemoryChangedEvent)event);
                    }
                } else if (event instanceof ICDIChangedEvent) {
                    if (source instanceof ICDIExpression && source.equals(this.fAddressExpression)) {
                        this.handleAddressChangedEvent((ICDIChangedEvent)event);
                    }
                } else if (event instanceof ICDIDestroyedEvent && source instanceof ICDIExpression && source.equals(this.fAddressExpression)) {
                    this.handleDestroyedEvent((ICDIDestroyedEvent)event);
                }
            }
            ++i;
        }
    }

    protected ICDIMemoryBlock getCDIMemoryBlock() {
        return this.fCDIMemoryBlock;
    }

    protected void setCDIMemoryBlock(ICDIMemoryBlock cdiMemoryBlock) {
        this.fCDIMemoryBlock = cdiMemoryBlock;
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.resetChangedAddresses();
        this.fStartAddressChanged = false;
        this.fireChangeEvent(512);
    }

    private void handleChangedEvent(ICDIMemoryChangedEvent event) {
        this.resetBytes();
        this.resetRows();
        IAddressFactory factory = ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
        BigInteger[] bigs = event.getAddresses();
        IAddress[] addresses = new IAddress[bigs.length];
        int i = 0;
        while (i < addresses.length) {
            addresses[i] = factory.createAddress(bigs[i]);
            ++i;
        }
        this.setChangedAddresses(addresses);
        this.fireChangeEvent(512);
    }

    private void handleAddressChangedEvent(ICDIChangedEvent event) {
        this.resetBytes();
        this.resetRows();
        this.fStartAddressChanged = true;
        this.fireChangeEvent(512);
    }

    private void handleDestroyedEvent(ICDIDestroyedEvent event) {
        this.fireTerminateEvent();
    }

    public IAddress[] getChangedAddresses() {
        return this.fChangedAddresses;
    }

    protected void setChangedAddresses(IAddress[] changedAddresses) {
        this.fChangedAddresses = changedAddresses;
    }

    protected void resetChangedAddresses() {
        this.fChangedAddresses = new IAddress[0];
    }

    public boolean isFrozen() {
        return this.getCDIMemoryBlock().isFrozen();
    }

    public void setFrozen(boolean frozen) {
        this.getCDIMemoryBlock().setFrozen(frozen);
    }

    public void setItemValue(int index, String newValue) throws DebugException {
        byte[] bytes = this.itemToBytes(newValue.toCharArray());
        this.setBytes(index * this.getWordSize(), bytes);
        this.resetRows();
    }

    private void setBytes(int index, byte[] newBytes) throws DebugException {
        try {
            this.getCDIMemoryBlock().setValue(index, newBytes);
        }
        catch (CDIException e) {
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
    }

    private byte[] itemToBytes(char[] chars) {
        switch (this.getFormat()) {
            case 0: {
                return this.hexItemToBytes(chars);
            }
        }
        return new byte[0];
    }

    private byte[] hexItemToBytes(char[] chars) {
        byte[] result = new byte[chars.length / 2];
        int i = 0;
        while (i < result.length) {
            result[i] = CDebugUtils.textToByte(new char[]{chars[2 * i], chars[2 * i + 1]});
            ++i;
        }
        return result;
    }

    public void refresh() throws DebugException {
        if (this.getCDIMemoryBlock() != null) {
            try {
                this.getCDIMemoryBlock().refresh();
            }
            catch (CDIException e) {
                CDebugElement.targetRequestFailed(e.getMessage(), null);
            }
        }
    }

    public boolean canChangeFormat(int format) {
        switch (format) {
            case 0: {
                return true;
            }
            case 3: {
                return this.getWordSize() != 8;
            }
            case 4: {
                return this.getWordSize() != 8;
            }
        }
        return false;
    }

    public boolean isLittleEndian() {
        IExecFileInfo info;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (IExecFileInfo)iDebugTarget.getAdapter((Class)clazz)) != null) {
            return info.isLittleEndian();
        }
        return true;
    }

    public boolean isStartAddressChanged() {
        return this.fStartAddressChanged;
    }

    private IAddress getRowAddress(int offset) {
        IAddress max;
        IAddress result = this.getRealStartAddress().add(BigInteger.valueOf(offset));
        if (result.compareTo((Object)(max = ((CDebugTarget)this.getDebugTarget()).getAddressFactory().getMax())) > 0) {
            result = result.add(result.getMaxOffset().negate());
        }
        return result;
    }

    class CFormattedMemoryBlockRow
    implements IFormattedMemoryBlockRow {
        private IAddress fAddress;
        private String[] fData;
        private String fAscii;

        public CFormattedMemoryBlockRow(IAddress address, String[] data, String ascii) {
            this.fAddress = address;
            this.fData = data;
            this.fAscii = ascii;
        }

        public IAddress getAddress() {
            return this.fAddress;
        }

        public String getASCII() {
            return this.fAscii;
        }

        public String[] getData() {
            return this.fData;
        }
    }
}

