/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;

public class CSharedLibrary
extends CDebugElement
implements ICSharedLibrary,
ICDIEventListener {
    private ICDISharedLibrary fCDILib = null;

    public CSharedLibrary(CDebugTarget target, ICDISharedLibrary cdiLib) {
        super(target);
        this.fCDILib = cdiLib;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public String getFileName() {
        if (this.getCDISharedLibrary() != null) {
            return this.getCDISharedLibrary().getFileName();
        }
        return null;
    }

    public IAddress getStartAddress() {
        IAddressFactory factory = ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
        if (this.getCDISharedLibrary() != null) {
            return factory.createAddress(this.getCDISharedLibrary().getStartAddress());
        }
        return factory.getZero();
    }

    public IAddress getEndAddress() {
        IAddressFactory factory = ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
        if (this.getCDISharedLibrary() != null) {
            return factory.createAddress(this.getCDISharedLibrary().getEndAddress());
        }
        return factory.getZero();
    }

    public boolean areSymbolsLoaded() {
        if (this.getCDISharedLibrary() != null) {
            return this.getCDISharedLibrary().areSymbolsLoaded();
        }
        return false;
    }

    public void loadSymbols() throws DebugException {
        try {
            if (this.getCDISharedLibrary() != null) {
                this.getCDISharedLibrary().loadSymbols();
            }
        }
        catch (CDIException e) {
            CDebugElement.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void dispose() {
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    public ICDISharedLibrary getCDISharedLibrary() {
        return this.fCDILib;
    }

    public void handleDebugEvents(ICDIEvent[] events) {
    }
}

