/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class AppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String SHOW_TU_CHILDREN = "org.eclipse.cdt.ui.editor.CUChildren";
    private static final String OUTLINE_GROUP_INCLUDES = "org.eclipse.cdt.ui.outline.groupincludes";
    private static final String OUTLINE_GROUP_NAMESPACES = "org.eclipse.cdt.ui.outline.groupnamespaces";
    private static final String CVIEW_GROUP_INCLUDES = "org.eclipse.cdt.ui.cview.groupincludes";
    private SelectionButtonDialogField fShowTUChildren;
    private SelectionButtonDialogField fOutlineGroupIncludes;
    private SelectionButtonDialogField fOutlineGroupNamespaces;
    private SelectionButtonDialogField fCViewGroupIncludes;

    public AppearancePreferencePage() {
        this.setPreferenceStore(PreferenceConstants.getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("AppearancePreferencePage.description"));
        IDialogFieldListener listener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AppearancePreferencePage.this.doDialogFieldChanged(field);
            }
        };
        this.fShowTUChildren = new SelectionButtonDialogField(32);
        this.fShowTUChildren.setDialogFieldListener(listener);
        this.fShowTUChildren.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.showTUChildren.label"));
        this.fOutlineGroupIncludes = new SelectionButtonDialogField(32);
        this.fOutlineGroupIncludes.setDialogFieldListener(listener);
        this.fOutlineGroupIncludes.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.outlineGroupIncludes.label"));
        this.fOutlineGroupNamespaces = new SelectionButtonDialogField(32);
        this.fOutlineGroupNamespaces.setDialogFieldListener(listener);
        this.fOutlineGroupNamespaces.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.outlineGroupNamespaces.label"));
        this.fCViewGroupIncludes = new SelectionButtonDialogField(32);
        this.fCViewGroupIncludes.setDialogFieldListener(listener);
        this.fCViewGroupIncludes.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.cviewGroupIncludes.label"));
    }

    private void initFields() {
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fShowTUChildren.setSelection(prefs.getBoolean(SHOW_TU_CHILDREN));
        this.fCViewGroupIncludes.setSelection(prefs.getBoolean(CVIEW_GROUP_INCLUDES));
        this.fOutlineGroupIncludes.setSelection(prefs.getBoolean(OUTLINE_GROUP_INCLUDES));
        this.fOutlineGroupNamespaces.setSelection(prefs.getBoolean(OUTLINE_GROUP_NAMESPACES));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.appearance_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int nColumns = 1;
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = nColumns;
        result.setLayout((Layout)layout);
        this.fShowTUChildren.doFillIntoGrid(result, nColumns);
        this.fCViewGroupIncludes.doFillIntoGrid(result, nColumns);
        this.fOutlineGroupIncludes.doFillIntoGrid(result, nColumns);
        this.fOutlineGroupNamespaces.doFillIntoGrid(result, nColumns);
        new Separator().doFillIntoGrid(result, nColumns);
        new Separator().doFillIntoGrid(result, nColumns);
        String noteTitle = PreferencesMessages.getString("AppearancePreferencePage.note");
        String noteMessage = PreferencesMessages.getString("AppearancePreferencePage.preferenceOnlyEffectiveForNewPerspectives");
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), result, noteTitle, noteMessage);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        noteControl.setLayoutData((Object)gd);
        this.initFields();
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    void doDialogFieldChanged(DialogField field) {
        this.updateStatus(this.getValidationStatus());
    }

    private IStatus getValidationStatus() {
        return new StatusInfo();
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore prefs = this.getPreferenceStore();
        prefs.setValue(SHOW_TU_CHILDREN, this.fShowTUChildren.isSelected());
        prefs.setValue(CVIEW_GROUP_INCLUDES, this.fCViewGroupIncludes.isSelected());
        prefs.setValue(OUTLINE_GROUP_INCLUDES, this.fOutlineGroupIncludes.isSelected());
        prefs.setValue(OUTLINE_GROUP_NAMESPACES, this.fOutlineGroupNamespaces.isSelected());
        CUIPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fShowTUChildren.setSelection(prefs.getDefaultBoolean(SHOW_TU_CHILDREN));
        this.fCViewGroupIncludes.setSelection(prefs.getDefaultBoolean(CVIEW_GROUP_INCLUDES));
        this.fOutlineGroupIncludes.setSelection(prefs.getDefaultBoolean(OUTLINE_GROUP_INCLUDES));
        this.fOutlineGroupNamespaces.setSelection(prefs.getDefaultBoolean(OUTLINE_GROUP_NAMESPACES));
        super.performDefaults();
    }
}

