/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.internal.core.parser.token.BasicTokenDuple;
import org.eclipse.cdt.internal.core.parser.token.ImagedToken;
import org.eclipse.cdt.internal.core.parser.token.TemplateTokenDuple;

public class TokenFactory {
    protected static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();

    public static IToken createStandAloneToken(int type, String image) {
        return new ImagedToken(type, image.toCharArray(), 0, EMPTY_CHAR_ARRAY, 0);
    }

    public static ITokenDuple createTokenDuple(IToken first, IToken last) {
        if (first == last && first instanceof ITokenDuple) {
            return (ITokenDuple)((Object)first);
        }
        return new BasicTokenDuple(first, last);
    }

    public static ITokenDuple createTokenDuple(IToken first, IToken last, List templateArgLists) {
        if (first == last && templateArgLists == null && first instanceof ITokenDuple) {
            return (ITokenDuple)((Object)first);
        }
        if (templateArgLists != null && !templateArgLists.isEmpty()) {
            return new TemplateTokenDuple(first, last, templateArgLists);
        }
        return new BasicTokenDuple(first, last);
    }

    public static ITokenDuple createTokenDuple(ITokenDuple firstDuple, ITokenDuple secondDuple) {
        if (secondDuple == null) {
            return firstDuple;
        }
        if (firstDuple == null) {
            return secondDuple;
        }
        List[] f1 = firstDuple.getTemplateIdArgLists();
        List[] f2 = secondDuple.getTemplateIdArgLists();
        if (f1 == null && f2 == null) {
            return new BasicTokenDuple(firstDuple, secondDuple);
        }
        return new TemplateTokenDuple(firstDuple, secondDuple);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IToken consumeTemplateIdArguments(IToken name, IToken last) {
        IToken token = name;
        if (token.getType() != 42) return token;
        if (token == last) {
            return token;
        }
        BraceCounter scopes = BraceCounter.getCounter();
        try {
            scopes.addValue(42);
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    token = token.getNext();
                    switch (token.getType()) {
                        case 46: {
                            if (scopes.getLast() != 42) break;
                            scopes.removeValue();
                            break;
                        }
                        case 11: {
                            int top;
                            do {
                                top = scopes.removeValue();
                            } while (!scopes.isEmpty() && top == 42);
                            break;
                        }
                        case 9: {
                            int top;
                            do {
                                top = scopes.removeValue();
                            } while (!scopes.isEmpty() && top == 42);
                            break;
                        }
                        case 42: {
                            scopes.addValue(42);
                            break;
                        }
                        case 10: {
                            scopes.addValue(10);
                            break;
                        }
                        case 8: {
                            scopes.addValue(8);
                            break;
                        }
                    }
                }
                if (scopes.isEmpty()) break;
            } while (token != last);
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            BraceCounter.returnCounter(scopes);
            throw throwable;
        }
        BraceCounter.returnCounter(scopes);
        return token;
    }

    public static char[] createCharArrayRepresentation(IToken first, IToken last) {
        return BasicTokenDuple.createCharArrayRepresentation(first, last);
    }

    protected static class BraceCounter {
        private static final int POOLSIZE = 8;
        private static final BraceCounter[] pool;
        private static final boolean[] free;
        private static int newObjectCount;
        private final int key;
        private int[] array = new int[8];
        int currentIndex = 0;

        static {
            newObjectCount = 8;
            pool = new BraceCounter[8];
            free = new boolean[8];
            int i = 0;
            while (i < 8) {
                BraceCounter.pool[i] = new BraceCounter(i);
                BraceCounter.free[i] = true;
                ++i;
            }
        }

        public static synchronized BraceCounter getCounter() {
            int i = 0;
            while (i < 8) {
                if (free[i]) {
                    BraceCounter.free[i] = false;
                    return pool[i];
                }
                ++i;
            }
            return new BraceCounter(newObjectCount++);
        }

        public static synchronized void returnCounter(BraceCounter c) {
            if (c.getKey() > 0 && c.getKey() < 8) {
                BraceCounter.free[c.getKey()] = true;
                c.clear();
            }
        }

        private void clear() {
            this.currentIndex = 0;
            Arrays.fill(this.array, 0, this.array.length, -1);
        }

        private void resizeArray() {
            int[] newArray = new int[this.array.length * 2];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }

        public void addValue(int value) {
            if (this.currentIndex == this.array.length) {
                this.resizeArray();
            }
            this.array[this.currentIndex] = value;
            ++this.currentIndex;
        }

        public int removeValue() {
            int result = this.array[this.currentIndex];
            this.array[this.currentIndex] = -1;
            --this.currentIndex;
            return result;
        }

        public int getLast() {
            if (this.isEmpty()) {
                return -1;
            }
            return this.array[this.currentIndex - 1];
        }

        public boolean isEmpty() {
            return this.currentIndex == 0;
        }

        public BraceCounter(int i) {
            this.key = i;
            this.clear();
        }

        public int getKey() {
            return this.key;
        }
    }
}

