/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.scannerconfig.IManagedScannerInfoCollector;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class ManagedBuildManager
extends AbstractCExtension
implements IScannerInfoProvider {
    private static final QualifiedName buildInfoProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "managedBuildInfo");
    private static final String ROOT_NODE_NAME = "ManagedProjectBuildInfo";
    public static final String SETTINGS_FILE_NAME = ".cdtbuild";
    private static final ITarget[] emptyTargets = new ITarget[0];
    public static final String INTERFACE_IDENTITY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildManager";
    public static final String EXTENSION_POINT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".buildDefinitions";
    public static final String EXTENSION_POINT_ID_V2 = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildInfo";
    private static final String REVISION_ELEMENT_NAME = "managedBuildRevision";
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    private static final String MANIFEST_VERSION_ERROR = "ManagedBuildManager.error.manifest.version.error";
    private static final String PROJECT_VERSION_ERROR = "ManagedBuildManager.error.project.version.error";
    private static final String MANIFEST_ERROR_HEADER = "ManagedBuildManager.error.manifest.header";
    public static final String MANIFEST_ERROR_RESOLVING = "ManagedBuildManager.error.manifest.resolving";
    public static final String MANIFEST_ERROR_DUPLICATE = "ManagedBuildManager.error.manifest.duplicate";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final PluginVersionIdentifier buildInfoVersion = new PluginVersionIdentifier(2, 1, 0);
    private static Map depCalculatorsMap;
    private static boolean projectTypesLoaded;
    private static Map projectTypeMap;
    private static List projectTypes;
    private static Map extensionConfigurationMap;
    private static Map extensionResourceConfigurationMap;
    private static Map extensionToolChainMap;
    private static Map extensionToolMap;
    private static Map extensionTargetPlatformMap;
    private static Map extensionBuilderMap;
    private static Map extensionOptionMap;
    private static Map extensionOptionCategoryMap;
    private static Map extensionTargetMap;
    private static Map configElementMap;
    private static Map buildModelListeners;
    private static Random randomNumber;

    static {
        projectTypesLoaded = false;
    }

    public static int getRandomNumber() {
        int i;
        if (randomNumber == null) {
            randomNumber = new Random();
            randomNumber.setSeed(System.currentTimeMillis());
        }
        if ((i = randomNumber.nextInt()) < 0) {
            i *= -1;
        }
        return i;
    }

    public static IProjectType[] getDefinedProjectTypes() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        List definedTypes = null;
        int size = projectTypes != null ? projectTypes.size() + (definedTypes != null ? definedTypes.size() : 0) : 0;
        IProjectType[] types = new IProjectType[size];
        int n = 0;
        int i = 0;
        while (i < projectTypes.size()) {
            types[n++] = (IProjectType)projectTypes.get(i);
            ++i;
        }
        if (definedTypes != null) {
            i = 0;
            while (i < definedTypes.size()) {
                types[n++] = (IProjectType)definedTypes.get(i);
                ++i;
            }
        }
        return types;
    }

    public static IProjectType getProjectType(String id) {
        return (IProjectType)ManagedBuildManager.getExtensionProjectTypeMap().get(id);
    }

    protected static Map getExtensionDepCalcMap() {
        if (depCalculatorsMap == null) {
            depCalculatorsMap = new HashMap();
        }
        return depCalculatorsMap;
    }

    protected static Map getExtensionProjectTypeMap() {
        if (projectTypeMap == null) {
            projectTypeMap = new HashMap();
        }
        return projectTypeMap;
    }

    protected static Map getExtensionConfigurationMap() {
        if (extensionConfigurationMap == null) {
            extensionConfigurationMap = new HashMap();
        }
        return extensionConfigurationMap;
    }

    protected static Map getExtensionResourceConfigurationMap() {
        if (extensionResourceConfigurationMap == null) {
            extensionResourceConfigurationMap = new HashMap();
        }
        return extensionResourceConfigurationMap;
    }

    protected static Map getExtensionToolChainMap() {
        if (extensionToolChainMap == null) {
            extensionToolChainMap = new HashMap();
        }
        return extensionToolChainMap;
    }

    protected static Map getExtensionToolMap() {
        if (extensionToolMap == null) {
            extensionToolMap = new HashMap();
        }
        return extensionToolMap;
    }

    protected static Map getExtensionTargetPlatformMap() {
        if (extensionTargetPlatformMap == null) {
            extensionTargetPlatformMap = new HashMap();
        }
        return extensionTargetPlatformMap;
    }

    protected static Map getExtensionBuilderMap() {
        if (extensionBuilderMap == null) {
            extensionBuilderMap = new HashMap();
        }
        return extensionBuilderMap;
    }

    protected static Map getExtensionOptionMap() {
        if (extensionOptionMap == null) {
            extensionOptionMap = new HashMap();
        }
        return extensionOptionMap;
    }

    protected static Map getExtensionOptionCategoryMap() {
        if (extensionOptionCategoryMap == null) {
            extensionOptionCategoryMap = new HashMap();
        }
        return extensionOptionCategoryMap;
    }

    protected static Map getExtensionTargetMap() {
        if (extensionTargetMap == null) {
            extensionTargetMap = new HashMap();
        }
        return extensionTargetMap;
    }

    public static ITarget[] getTargets(IResource resource) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(resource);
        if (buildInfo != null) {
            List targets = buildInfo.getTargets();
            return targets.toArray(new ITarget[targets.size()]);
        }
        return emptyTargets;
    }

    public static IProjectType getExtensionProjectType(String id) {
        return (IProjectType)ManagedBuildManager.getExtensionProjectTypeMap().get(id);
    }

    public static IConfiguration getExtensionConfiguration(String id) {
        return (IConfiguration)ManagedBuildManager.getExtensionConfigurationMap().get(id);
    }

    public static IResourceConfiguration getExtensionResourceConfiguration(String id) {
        return (IResourceConfiguration)ManagedBuildManager.getExtensionResourceConfigurationMap().get(id);
    }

    public static IToolChain getExtensionToolChain(String id) {
        return (IToolChain)ManagedBuildManager.getExtensionToolChainMap().get(id);
    }

    public static ITool getExtensionTool(String id) {
        return (ITool)ManagedBuildManager.getExtensionToolMap().get(id);
    }

    public static ITargetPlatform getExtensionTargetPlatform(String id) {
        return (ITargetPlatform)ManagedBuildManager.getExtensionTargetPlatformMap().get(id);
    }

    public static IBuilder getExtensionBuilder(String id) {
        return (IBuilder)ManagedBuildManager.getExtensionBuilderMap().get(id);
    }

    public static IOption getExtensionOption(String id) {
        return (IOption)ManagedBuildManager.getExtensionOptionMap().get(id);
    }

    public static ITarget getExtensionTarget(String id) {
        return (ITarget)ManagedBuildManager.getExtensionTargetMap().get(id);
    }

    public static ITarget getTarget(IResource resource, String id) {
        IManagedBuildInfo buildInfo;
        ITarget target = null;
        if (resource != null && (buildInfo = ManagedBuildManager.getBuildInfo(resource)) != null) {
            target = buildInfo.getTarget(id);
        }
        if (target == null) {
            target = (ITarget)ManagedBuildManager.getExtensionTargetMap().get(id);
        }
        return target;
    }

    public static void setDefaultConfiguration(IProject project, IConfiguration newDefault) {
        if (project == null || newDefault == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setDefaultConfiguration(newDefault);
        }
    }

    public static void setSelectedConfiguration(IProject project, IConfiguration config) {
        if (project == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setSelectedConfiguration(config);
        }
    }

    public static IManagedBuilderMakefileGenerator getBuildfileGenerator(IConfiguration config) {
        try {
            IToolChain toolChain = config.getToolChain();
            IBuilder builder = toolChain.getBuilder();
            IConfigurationElement element = builder.getBuildFileGeneratorElement();
            if (element != null) {
                if (element.getName().equalsIgnoreCase("target")) {
                    if (element.getAttribute("makefileGenerator") != null) {
                        return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("makefileGenerator");
                    }
                } else if (element.getAttribute("buildfileGenerator") != null) {
                    return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("buildfileGenerator");
                }
            }
        }
        catch (CoreException coreException) {}
        return new GnuMakefileGenerator();
    }

    public static IManagedCommandLineGenerator getCommandLineGenerator(IConfiguration config, String toolId) {
        ITool tool = config.getTool(toolId);
        if (tool != null) {
            return tool.getCommandLineGenerator();
        }
        return ManagedCommandLineGenerator.getCommandLineGenerator();
    }

    public static IManagedScannerInfoCollector getScannerInfoCollector(IConfiguration config) {
        try {
            IToolChain toolChain = config.getToolChain();
            IConfigurationElement element = toolChain.getScannerInfoCollectorElement();
            if (element != null && element.getAttribute("scannerInfoCollector") != null) {
                return (IManagedScannerInfoCollector)element.createExecutableExtension("scannerInfoCollector");
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static IConfiguration getSelectedConfiguration(IProject project) {
        if (project == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            return info.getSelectedConfiguration();
        }
        return null;
    }

    private static void notifyListeners(IConfiguration config, IOption option) {
        try {
            if (option.getValueType() != 4 && option.getValueType() != 5) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        IResource resource = config.getOwner();
        List listeners = (List)ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource));
        }
    }

    private static void notifyListeners(IResourceConfiguration resConfig, IOption option) {
        try {
            if (option.getValueType() != 4 && option.getValueType() != 5) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        IResource resource = resConfig.getOwner();
        List listeners = (List)ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource));
        }
    }

    public static void setNewProjectVersion(IProject newProject) {
        ManagedBuildInfo info = ManagedBuildManager.findBuildInfo((IResource)newProject);
        info.setVersion(buildInfoVersion.toString());
    }

    public static IOption setOption(IConfiguration config, ITool tool, IOption option, boolean value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(tool, option, value);
            ManagedBuildManager.notifyListeners(config, option);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceConfiguration resConfig, ITool tool, IOption option, boolean value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(tool, option, value);
            ManagedBuildManager.notifyListeners(resConfig, option);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IConfiguration config, ITool tool, IOption option, String value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(tool, option, value);
            ManagedBuildManager.notifyListeners(config, option);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceConfiguration resConfig, ITool tool, IOption option, String value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(tool, option, value);
            ManagedBuildManager.notifyListeners(resConfig, option);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IConfiguration config, ITool tool, IOption option, String[] value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(tool, option, value);
            ManagedBuildManager.notifyListeners(config, option);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceConfiguration resConfig, ITool tool, IOption option, String[] value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(tool, option, value);
            ManagedBuildManager.notifyListeners(resConfig, option);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static void setToolCommand(IConfiguration config, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            config.setToolCommand(tool, command);
        }
    }

    public static void setToolCommand(IResourceConfiguration resConfig, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            resConfig.setToolCommand(tool, command);
        }
    }

    public static void saveBuildInfo(IProject project, boolean force) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            ManagedBuildInfo buildInfo = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo != null && !buildInfo.isReadOnly() && buildInfo.isValid() && (force || buildInfo.isDirty())) {
                String projectVersion = buildInfo.getVersion();
                if (projectVersion != null) {
                    ProcessingInstruction instruction = doc.createProcessingInstruction(VERSION_ELEMENT_NAME, projectVersion);
                    doc.appendChild(instruction);
                }
                Element rootElement = doc.createElement(ROOT_NODE_NAME);
                doc.appendChild(rootElement);
                buildInfo.serialize(doc, rootElement);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
                IFile projectFile = project.getFile(SETTINGS_FILE_NAME);
                String utfString = stream.toString("UTF-8");
                if (projectFile.exists()) {
                    projectFile.setContents((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                }
                stream.close();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void removeBuildInfo(IResource resource) {
        try {
            resource.setSessionProperty(buildInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    public static void resetConfiguration(IProject project, IConfiguration configuration) {
        ((Configuration)configuration).reset();
    }

    public static void resetResourceConfiguration(IProject project, IResourceConfiguration resConfig) {
        ((ResourceConfiguration)resConfig).reset();
    }

    public static void addExtensionProjectType(ProjectType projectType) {
        if (projectTypes == null) {
            projectTypes = new ArrayList();
        }
        projectTypes.add(projectType);
        ProjectType previous = ManagedBuildManager.getExtensionProjectTypeMap().put(projectType.getId(), projectType);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ProjectType", projectType.getId());
        }
    }

    public static void addExtensionConfiguration(Configuration configuration) {
        Configuration previous = ManagedBuildManager.getExtensionConfigurationMap().put(configuration.getId(), configuration);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Configuration", configuration.getId());
        }
    }

    public static void addExtensionResourceConfiguration(ResourceConfiguration resourceConfiguration) {
        ResourceConfiguration previous = ManagedBuildManager.getExtensionResourceConfigurationMap().put(resourceConfiguration.getId(), resourceConfiguration);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ResourceConfiguration", resourceConfiguration.getId());
        }
    }

    public static void addExtensionToolChain(ToolChain toolChain) {
        ToolChain previous = ManagedBuildManager.getExtensionToolChainMap().put(toolChain.getId(), toolChain);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ToolChain", toolChain.getId());
        }
    }

    public static void addExtensionTool(Tool tool) {
        Tool previous = ManagedBuildManager.getExtensionToolMap().put(tool.getId(), tool);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Tool", tool.getId());
        }
    }

    public static void addExtensionTargetPlatform(TargetPlatform targetPlatform) {
        TargetPlatform previous = ManagedBuildManager.getExtensionTargetPlatformMap().put(targetPlatform.getId(), targetPlatform);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("TargetPlatform", targetPlatform.getId());
        }
    }

    public static void addExtensionBuilder(Builder builder) {
        Builder previous = ManagedBuildManager.getExtensionBuilderMap().put(builder.getId(), builder);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Builder", builder.getId());
        }
    }

    public static void addExtensionOption(Option option) {
        Option previous = ManagedBuildManager.getExtensionOptionMap().put(option.getId(), option);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Option", option.getId());
        }
    }

    public static void addExtensionOptionCategory(OptionCategory optionCategory) {
        OptionCategory previous = ManagedBuildManager.getExtensionOptionCategoryMap().put(optionCategory.getId(), optionCategory);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("OptionCategory", optionCategory.getId());
        }
    }

    public static void addExtensionTarget(Target target) {
        ManagedBuildManager.getExtensionTargetMap().put(target.getId(), target);
    }

    public static IManagedProject createManagedProject(IResource resource, IProjectType parent) throws BuildException {
        return new ManagedProject(resource, parent);
    }

    public static ITarget createTarget(IResource resource, ITarget parentTarget) throws BuildException {
        IResource owner = parentTarget.getOwner();
        if (owner != null && owner.equals((Object)resource)) {
            return parentTarget;
        }
        if (resource instanceof IProject) {
            if (owner != null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_null"));
            }
        } else {
            if (owner == null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.null_owner"));
            }
            if (!owner.equals((Object)resource.getProject())) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_project"));
            }
        }
        return new Target(resource, parentTarget);
    }

    public static IStatus initBuildInfoContainer(IResource resource) {
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = ManagedBuildManager.findBuildInfo((IResource)resource.getProject());
            ManagedBuildManager.initBuildInfoContainer(buildInfo);
        }
        catch (CoreException e) {
            return new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, e.getLocalizedMessage(), (Throwable)e);
        }
        return new Status(0, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ManagedMakeMessages.getFormattedString("ManagedBuildInfo.message.init.ok", resource.getName()), null);
    }

    private static void initBuildInfoContainer(ManagedBuildInfo info) throws CoreException {
        ICProject cProject;
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null));
        }
        if (info.isContainerInited()) {
            return;
        }
        ICProject iCProject = cProject = info.getCProject();
        synchronized (iCProject) {
            IPathEntry[] entries = cProject.getRawPathEntries();
            ArrayList<IPathEntry> newEntries = new ArrayList<IPathEntry>(Arrays.asList(entries));
            if (!newEntries.contains(ManagedBuildInfo.containerEntry)) {
                newEntries.add((IPathEntry)ManagedBuildInfo.containerEntry);
                cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
            }
            info.setContainerInited(true);
        }
    }

    private static boolean isVersionCompatible(IExtension extension) {
        PluginVersionIdentifier version = null;
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int index = 0;
        while (index < elements.length) {
            IConfigurationElement element = elements[index];
            if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                version = new PluginVersionIdentifier(element.getAttribute(VERSION_ELEMENT_NAME));
                break;
            }
            ++index;
        }
        if (version == null) {
            return true;
        }
        return buildInfoVersion.isCompatibleWith(version);
    }

    private static ManagedBuildInfo loadBuildInfo(IProject project) throws Exception {
        ManagedBuildInfo buildInfo;
        block16: {
            NodeList nodes;
            InputStream stream;
            block15: {
                buildInfo = null;
                IFile file = project.getFile(SETTINGS_FILE_NAME);
                if (!file.exists()) {
                    return null;
                }
                stream = null;
                try {
                    stream = file.getContents();
                }
                catch (ResourceException e) {
                    if (e.getStatus().getCode() != 274) break block15;
                    stream = file.getContents(true);
                }
                catch (Exception e) {
                    throw e;
                }
            }
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(stream);
            String fileVersion = null;
            Node rootElement = document.getFirstChild();
            if (rootElement.getNodeType() == 7) {
                fileVersion = rootElement.getNodeValue();
                PluginVersionIdentifier version = new PluginVersionIdentifier(fileVersion);
                if (!buildInfoVersion.isCompatibleWith(version)) {
                    throw new BuildException(ManagedMakeMessages.getFormattedString(PROJECT_VERSION_ERROR, project.getName()));
                }
                buildInfoVersion.isGreaterThan(version);
            }
            if ((nodes = document.getElementsByTagName(ROOT_NODE_NAME)).getLength() <= 0) break block16;
            Node node = nodes.item(0);
            buildInfo = new ManagedBuildInfo((IResource)project, (Element)node);
            if (fileVersion != null) {
                buildInfo.setVersion(fileVersion);
            }
            if (!UpdateManagedProjectManager.isCompatibleProject(buildInfo)) {
                UpdateManagedProjectManager.updateProject(project, buildInfo);
            }
            if (buildInfo.getManagedProject() == null || !buildInfo.getManagedProject().isValid()) {
                throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
            }
            project.setSessionProperty(buildInfoProperty, (Object)buildInfo);
        }
        buildInfo.setValid(true);
        return buildInfo;
    }

    private static void loadExtensions() throws BuildException {
        if (projectTypesLoaded) {
            return;
        }
        ManagedBuildManager.loadExtensionsSynchronized();
    }

    private static synchronized void loadExtensionsSynchronized() throws BuildException {
        IConfigurationElement[] elements;
        IExtension extension;
        IExtension[] extensions;
        if (projectTypesLoaded) {
            return;
        }
        projectTypesLoaded = true;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                extension = extensions[i];
                if (!ManagedBuildManager.isVersionCompatible(extension)) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        window = windows[0];
                    }
                    final Shell shell = window.getShell();
                    final String errMsg = ManagedMakeMessages.getFormattedString(MANIFEST_VERSION_ERROR, extension.getUniqueIdentifier());
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.manifest_load_failed_title"), (String)errMsg);
                        }
                    });
                } else {
                    elements = extension.getConfigurationElements();
                    ManagedBuildManager.loadConfigElements(DefaultManagedConfigElement.convertArray(elements));
                }
                ++i;
            }
            Iterator projectTypeIter = ManagedBuildManager.getExtensionProjectTypeMap().values().iterator();
            while (projectTypeIter.hasNext()) {
                try {
                    ProjectType projectType = (ProjectType)projectTypeIter.next();
                    projectType.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator configurationIter = ManagedBuildManager.getExtensionConfigurationMap().values().iterator();
            while (configurationIter.hasNext()) {
                try {
                    Configuration configuration = (Configuration)configurationIter.next();
                    configuration.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator resConfigIter = ManagedBuildManager.getExtensionResourceConfigurationMap().values().iterator();
            while (resConfigIter.hasNext()) {
                try {
                    ResourceConfiguration resConfig = (ResourceConfiguration)resConfigIter.next();
                    resConfig.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator toolChainIter = ManagedBuildManager.getExtensionToolChainMap().values().iterator();
            while (toolChainIter.hasNext()) {
                try {
                    ToolChain toolChain = (ToolChain)toolChainIter.next();
                    toolChain.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator toolIter = ManagedBuildManager.getExtensionToolMap().values().iterator();
            while (toolIter.hasNext()) {
                try {
                    Tool tool = (Tool)toolIter.next();
                    tool.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator targetPlatformIter = ManagedBuildManager.getExtensionTargetPlatformMap().values().iterator();
            while (targetPlatformIter.hasNext()) {
                try {
                    TargetPlatform targetPlatform = (TargetPlatform)targetPlatformIter.next();
                    targetPlatform.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator builderIter = ManagedBuildManager.getExtensionBuilderMap().values().iterator();
            while (builderIter.hasNext()) {
                try {
                    Builder builder = (Builder)builderIter.next();
                    builder.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator optionIter = ManagedBuildManager.getExtensionOptionMap().values().iterator();
            while (optionIter.hasNext()) {
                try {
                    Option option = (Option)optionIter.next();
                    option.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator optionCatIter = ManagedBuildManager.getExtensionOptionCategoryMap().values().iterator();
            while (optionCatIter.hasNext()) {
                try {
                    OptionCategory optionCat = (OptionCategory)optionCatIter.next();
                    optionCat.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID_V2)) != null && (extensions = extensionPoint.getExtensions()) != null && extensions.length > 0) {
            int i = 0;
            while (i < extensions.length) {
                extension = extensions[i];
                if (!ManagedBuildManager.isVersionCompatible(extension)) {
                    throw new BuildException(ManagedMakeMessages.getResourceString(MANIFEST_VERSION_ERROR));
                }
                elements = extension.getConfigurationElements();
                ManagedBuildManager.loadConfigElementsV2(DefaultManagedConfigElement.convertArray(elements));
                ++i;
            }
            Iterator targetIter = ManagedBuildManager.getExtensionTargetMap().values().iterator();
            while (targetIter.hasNext()) {
                try {
                    Target target = (Target)targetIter.next();
                    target.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator toolIter = ManagedBuildManager.getExtensionToolMap().values().iterator();
            while (toolIter.hasNext()) {
                try {
                    Tool tool = (Tool)toolIter.next();
                    tool.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            targetIter = ManagedBuildManager.getExtensionTargetMap().values().iterator();
            while (targetIter.hasNext()) {
                try {
                    Target target = (Target)targetIter.next();
                    if (target.getCreatedProjectType() != null) continue;
                    target.convertToProjectType();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator projTypeIter = ManagedBuildManager.getExtensionProjectTypeMap().values().iterator();
            while (projTypeIter.hasNext()) {
                try {
                    ProjectType projType = (ProjectType)projTypeIter.next();
                    projType.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static void loadConfigElements(IManagedConfigElement[] elements) {
        int toolIndex = 0;
        while (toolIndex < elements.length) {
            try {
                IManagedConfigElement element = elements[toolIndex];
                if (element.getName().equals("projectType")) {
                    new ProjectType(element);
                } else if (element.getName().equals("configuration")) {
                    new Configuration(null, element);
                } else if (element.getName().equals("toolChain")) {
                    new ToolChain(null, element);
                } else if (element.getName().equals("tool")) {
                    new Tool(null, element);
                } else if (element.getName().equals("targetPlatform")) {
                    new TargetPlatform(null, element);
                } else if (element.getName().equals("builder")) {
                    new Builder(null, element);
                } else if (element.getName().equals("dynamicElementProvider") && element instanceof DefaultManagedConfigElement) {
                    IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                    IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                    ManagedBuildManager.loadConfigElements(providedConfigs);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++toolIndex;
        }
    }

    private static void loadConfigElementsV2(IManagedConfigElement[] elements) {
        int toolIndex = 0;
        while (toolIndex < elements.length) {
            try {
                IManagedConfigElement element = elements[toolIndex];
                if (element.getName().equals("tool")) {
                    new Tool(element);
                } else if (element.getName().equals("target")) {
                    new Target(element);
                } else if (element.getName().equals("dynamicElementProvider") && element instanceof DefaultManagedConfigElement) {
                    IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                    IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                    ManagedBuildManager.loadConfigElementsV2(providedConfigs);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++toolIndex;
        }
    }

    public static ManagedBuildInfo createBuildInfo(IResource resource) {
        ManagedBuildInfo buildInfo = new ManagedBuildInfo(resource);
        try {
            resource.setSessionProperty(buildInfoProperty, (Object)buildInfo);
        }
        catch (CoreException coreException) {
            buildInfo = null;
        }
        return buildInfo;
    }

    private static IManagedConfigElementProvider createConfigProvider(DefaultManagedConfigElement element) throws CoreException {
        return (IManagedConfigElementProvider)element.getConfigurationElement().createExecutableExtension("class");
    }

    public static boolean manages(IResource resource) {
        IProject project = null;
        if (resource instanceof IProject) {
            project = (IProject)resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return false;
        }
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        if (file.exists()) {
            try {
                InputStream stream = file.getContents();
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(stream);
                NodeList nodes = document.getElementsByTagName(ROOT_NODE_NAME);
                return nodes.getLength() > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static ManagedBuildInfo findBuildInfo(IResource resource) {
        if (resource == null) {
            return null;
        }
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
            return null;
        }
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = (ManagedBuildInfo)resource.getSessionProperty(buildInfoProperty);
            if (buildInfo != null) {
                buildInfo.updateOwner(resource);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = ManagedBuildManager.findBuildInfoSynchronized((IProject)resource);
        }
        return buildInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ManagedBuildInfo findBuildInfoSynchronized(IProject project) {
        IJobManager jobManager;
        IProject rule;
        ManagedBuildInfo buildInfo;
        block17: {
            ManagedBuildInfo managedBuildInfo;
            block16: {
                buildInfo = null;
                rule = project;
                jobManager = Platform.getJobManager();
                try {
                    try {
                        jobManager.beginRule((ISchedulingRule)rule, null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    try {
                        buildInfo = (ManagedBuildInfo)project.getSessionProperty(buildInfoProperty);
                        if (buildInfo != null) {
                            buildInfo.updateOwner((IResource)project);
                        }
                    }
                    catch (CoreException coreException) {}
                    if (buildInfo == null && (buildInfo = UpdateManagedProjectManager.getConvertedManagedBuildInfo(project)) != null) {
                        managedBuildInfo = buildInfo;
                        Object var8_5 = null;
                        break block16;
                    }
                    if (buildInfo == null) {
                        try {
                            buildInfo = ManagedBuildManager.loadBuildInfo(project);
                        }
                        catch (Exception e) {
                            if (buildInfo == null) {
                                buildInfo = ManagedBuildManager.createBuildInfo((IResource)project);
                            }
                            buildInfo.setValid(false);
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (window == null) {
                                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                                window = windows[0];
                            }
                            final Shell shell = window.getShell();
                            final String exceptionMsg = e.getMessage();
                            shell.getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.open_failed_title"), (String)ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.open_failed", exceptionMsg));
                                }
                            });
                        }
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    jobManager.endRule((ISchedulingRule)rule);
                    throw throwable;
                }
            }
            jobManager.endRule((ISchedulingRule)rule);
            return managedBuildInfo;
        }
        Object var8_7 = null;
        jobManager.endRule((ISchedulingRule)rule);
        if (buildInfo.isContainerInited()) return buildInfo;
        try {
            ManagedBuildManager.initBuildInfoContainer(buildInfo);
            return buildInfo;
        }
        catch (CoreException coreException) {}
        return buildInfo;
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource) {
        return ManagedBuildManager.findBuildInfo((IResource)resource.getProject());
    }

    public static PluginVersionIdentifier getBuildInfoVersion() {
        return buildInfoVersion;
    }

    private static Map getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap();
        }
        return buildModelListeners;
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        return (IScannerInfo)ManagedBuildManager.getBuildInfo((IResource)resource.getProject());
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!list.contains(listener)) {
            list.add(listener);
            map.put(project, list);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
            map.put(project, list);
        }
    }

    private static Map getConfigElementMap() {
        if (configElementMap == null) {
            configElementMap = new HashMap();
        }
        return configElementMap;
    }

    public static void putConfigElement(IBuildObject buildObj, IManagedConfigElement configElement) {
        ManagedBuildManager.getConfigElementMap().put(buildObj, configElement);
    }

    private static void removeConfigElement(IBuildObject buildObj) {
        ManagedBuildManager.getConfigElementMap().remove(buildObj);
    }

    public static IManagedConfigElement getConfigElement(IBuildObject buildObj) {
        return (IManagedConfigElement)ManagedBuildManager.getConfigElementMap().get(buildObj);
    }

    public static void OutputResolveError(String attribute, String lookupId, String type, String id) {
        String[] msgs = new String[]{attribute, lookupId, type, id};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_RESOLVING, msgs));
    }

    public static void OutputDuplicateIdError(String type, String id) {
        String[] msgs = new String[]{type, id};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_DUPLICATE, msgs));
    }

    public static void OutputManifestError(String message) {
        System.err.println(String.valueOf(ManagedMakeMessages.getResourceString(MANIFEST_ERROR_HEADER)) + message + NEWLINE);
    }
}

