/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.io.File;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.GDBDebuggerPage;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.mi.internal.ui.SerialPortSettingsBlock;
import org.eclipse.cdt.debug.mi.internal.ui.TCPSettingsBlock;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ComboDialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class GDBServerDebuggerPage
extends GDBDebuggerPage {
    private static final String CONNECTION_TCP = MIUIMessages.getString("GDBServerDebuggerPage.0");
    private static final String CONNECTION_SERIAL = MIUIMessages.getString("GDBServerDebuggerPage.1");
    private ComboDialogField fConnectionField;
    private String[] fConnections = new String[]{CONNECTION_TCP, CONNECTION_SERIAL};
    private TCPSettingsBlock fTCPBlock;
    private SerialPortSettingsBlock fSerialBlock;
    private Composite fConnectionStack;
    private boolean fIsInitializing = false;

    public GDBServerDebuggerPage() {
        this.fConnectionField = this.createConnectionField();
        this.fTCPBlock = new TCPSettingsBlock();
        this.fSerialBlock = new SerialPortSettingsBlock();
        this.fTCPBlock.addObserver(this);
        this.fSerialBlock.addObserver(this);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString("GDBServerDebuggerPage.2"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        tabItem.setControl((Control)comp);
        Composite subComp = ControlFactory.createCompositeEx((Composite)comp, (int)3, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("GDBServerDebuggerPage.3"));
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!GDBServerDebuggerPage.this.isInitializing()) {
                    GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button button = this.createPushButton(subComp, MIUIMessages.getString("GDBServerDebuggerPage.4"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (!GDBServerDebuggerPage.this.isInitializing()) {
                    this.handleGDBButtonSelected();
                    GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GDBServerDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString("GDBServerDebuggerPage.5"));
                String gdbCommand = GDBServerDebuggerPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GDBServerDebuggerPage.this.fGDBCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("GDBServerDebuggerPage.6"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBInitText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!GDBServerDebuggerPage.this.isInitializing()) {
                    GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        button = this.createPushButton(subComp, MIUIMessages.getString("GDBServerDebuggerPage.7"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (!GDBServerDebuggerPage.this.isInitializing()) {
                    this.handleGDBInitButtonSelected();
                    GDBServerDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GDBServerDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString("GDBServerDebuggerPage.8"));
                String gdbCommand = GDBServerDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GDBServerDebuggerPage.this.fGDBInitText.setText(res);
            }
        });
        this.extendMainTab(comp);
    }

    protected void extendMainTab(Composite parent) {
        Composite comp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        this.fConnectionField.doFillIntoGrid(comp, 2);
        ((GridData)this.fConnectionField.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        PixelConverter converter = new PixelConverter((Control)comp);
        LayoutUtil.setWidthHint((Control)this.fConnectionField.getComboControl(null), converter.convertWidthInCharsToPixels(15));
        this.fConnectionStack = ControlFactory.createCompositeEx((Composite)comp, (int)1, (int)1808);
        StackLayout stackLayout = new StackLayout();
        this.fConnectionStack.setLayout((Layout)stackLayout);
        ((GridData)this.fConnectionStack.getLayoutData()).horizontalSpan = 2;
        this.fTCPBlock.createBlock(this.fConnectionStack);
        this.fSerialBlock.createBlock(this.fConnectionStack);
    }

    private ComboDialogField createConnectionField() {
        ComboDialogField field = new ComboDialogField(12);
        field.setLabelText(MIUIMessages.getString("GDBServerDebuggerPage.9"));
        field.setItems(this.fConnections);
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                if (!GDBServerDebuggerPage.this.isInitializing()) {
                    GDBServerDebuggerPage.this.connectionTypeChanged();
                }
            }
        });
        return field;
    }

    protected void connectionTypeChanged() {
        this.connectionTypeChanged0();
        this.updateLaunchConfigurationDialog();
    }

    private void connectionTypeChanged0() {
        ((StackLayout)this.fConnectionStack.getLayout()).topControl = null;
        int index = this.fConnectionField.getSelectionIndex();
        if (index >= 0 && index < this.fConnections.length) {
            String[] connTypes = this.fConnectionField.getItems();
            if (CONNECTION_TCP.equals(connTypes[index])) {
                ((StackLayout)this.fConnectionStack.getLayout()).topControl = this.fTCPBlock.getControl();
            } else if (CONNECTION_SERIAL.equals(connTypes[index])) {
                ((StackLayout)this.fConnectionStack.getLayout()).topControl = this.fSerialBlock.getControl();
            }
        }
        this.fConnectionStack.layout();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (super.isValid(launchConfig)) {
            this.setErrorMessage(null);
            this.setMessage(null);
            int index = this.fConnectionField.getSelectionIndex();
            if (index >= 0 && index < this.fConnections.length) {
                String[] connTypes = this.fConnectionField.getItems();
                if (CONNECTION_TCP.equals(connTypes[index])) {
                    if (!this.fTCPBlock.isValid(launchConfig)) {
                        this.setErrorMessage(this.fTCPBlock.getErrorMessage());
                        return false;
                    }
                } else if (CONNECTION_SERIAL.equals(connTypes[index]) && !this.fSerialBlock.isValid(launchConfig)) {
                    this.setErrorMessage(this.fSerialBlock.getErrorMessage());
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        super.initializeFrom(configuration);
        boolean isTcp = false;
        try {
            isTcp = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false);
        }
        catch (CoreException coreException) {}
        this.fTCPBlock.initializeFrom(configuration);
        this.fSerialBlock.initializeFrom(configuration);
        this.fConnectionField.selectItem(isTcp ? 0 : 1);
        this.connectionTypeChanged0();
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        if (this.fConnectionField != null) {
            configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, this.fConnectionField.getSelectionIndex() == 0);
        }
        this.fTCPBlock.performApply(configuration);
        this.fSerialBlock.performApply(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false);
        this.fTCPBlock.setDefaults(configuration);
        this.fSerialBlock.setDefaults(configuration);
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }
}

