/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.propertypages;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.internal.ui.propertypages.PropertyMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public class OptionsPropertyPage
extends PropertyPage {
    private Button fRefreshRegistersButton;
    private Button fRefreshSolibsButton;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public OptionsPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite comp = ControlFactory.createComposite((Composite)parent, (int)1);
        this.fRefreshRegistersButton = this.createCheckButton(comp, PropertyMessages.getString("OptionsPropertyPage.0"));
        this.fRefreshSolibsButton = this.createCheckButton(comp, PropertyMessages.getString("OptionsPropertyPage.1"));
        this.initialize();
        return comp;
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private void initialize() {
        ICDISession session;
        boolean regUpdate = true;
        boolean solibUpdate = true;
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((session = (ICDISession)iAdaptable.getAdapter((Class)clazz)) instanceof Session) {
            regUpdate = ((Session)session).getRegisterManager().isAutoUpdate();
            solibUpdate = ((Session)session).getSharedLibraryManager().isAutoUpdate();
        }
        this.fRefreshRegistersButton.setSelection(regUpdate);
        this.fRefreshSolibsButton.setSelection(solibUpdate);
    }

    protected void performApply() {
        this.storeValues();
        super.performApply();
    }

    public boolean performOk() {
        this.storeValues();
        return super.performOk();
    }

    private void storeValues() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICDISession session = (ICDISession)iAdaptable.getAdapter((Class)clazz);
        IAdaptable iAdaptable2 = this.getElement();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final ICDITarget target = (ICDITarget)iAdaptable2.getAdapter((Class)clazz2);
        if (session instanceof Session) {
            final boolean regUpdate = this.fRefreshRegistersButton.getSelection();
            final boolean solibUpdate = this.fRefreshSolibsButton.getSelection();
            final Session miSession = (Session)session;
            miSession.getRegisterManager().setAutoUpdate(regUpdate);
            miSession.getSharedLibraryManager().setAutoUpdate(solibUpdate);
            if (target.isSuspended() && (regUpdate || solibUpdate)) {
                DebugPlugin.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (target.isSuspended()) {
                            if (regUpdate) {
                                try {
                                    miSession.getRegisterManager().update();
                                }
                                catch (CDIException cDIException) {}
                            }
                            if (solibUpdate) {
                                try {
                                    miSession.getSharedLibraryManager().update();
                                }
                                catch (CDIException cDIException) {}
                            }
                        }
                    }
                });
            }
        }
    }
}

