/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.part;

import java.text.MessageFormat;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.part.CheckboxTablePart;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class WizardCheckboxTablePart
extends CheckboxTablePart {
    public static final String KEY_SELECT_ALL = MakeUIPlugin.getResourceString("WizardCheckboxTablePart.WizardCheckboxTablePart.selectAll");
    public static final String KEY_DESELECT_ALL = MakeUIPlugin.getResourceString("WizardCheckboxTablePart.WizardCheckboxTablePart.deselectAll");
    public static final String KEY_COUNTER = MakeUIPlugin.getResourceString("WizardCheckboxTablePart.WizardCheckboxTablePart.counter");
    private final String EMPTY_STRING = "";
    private int selectAllIndex = -1;
    private int deselectAllIndex = -1;
    private String tableName;
    private int counter;
    private Label counterLabel;

    public WizardCheckboxTablePart(String tableName, String[] buttonLabels) {
        super(buttonLabels);
        this.tableName = tableName;
    }

    public WizardCheckboxTablePart(String mainLabel) {
        this(mainLabel, new String[]{MakeUIPlugin.getResourceString(KEY_SELECT_ALL), MakeUIPlugin.getResourceString(KEY_DESELECT_ALL)});
        this.setSelectAllIndex(0);
        this.setDeselectAllIndex(1);
    }

    public void setSelectAllIndex(int index) {
        this.selectAllIndex = index;
    }

    public void setDeselectAllIndex(int index) {
        this.deselectAllIndex = index;
    }

    protected void buttonSelected(Button button, int index) {
        if (index == this.selectAllIndex) {
            this.handleSelectAll(true);
        }
        if (index == this.deselectAllIndex) {
            this.handleSelectAll(false);
        }
    }

    public Object[] getSelection() {
        CheckboxTableViewer viewer = this.getTableViewer();
        return viewer.getCheckedElements();
    }

    public void setSelection(Object[] selected) {
        CheckboxTableViewer viewer = this.getTableViewer();
        viewer.setCheckedElements(selected);
        this.updateCounter(selected.length);
    }

    public void createControl(Composite parent) {
        this.createControl(parent, 0, 2);
        this.counterLabel = new Label(parent, 0);
        GridData gd = new GridData(258);
        gd.horizontalSpan = 2;
        this.counterLabel.setLayoutData((Object)gd);
        this.updateCounter(0);
    }

    protected Button createButton(Composite parent, String label, int index) {
        Button button = super.createButton(parent, label, index);
        return button;
    }

    protected StructuredViewer createStructuredViewer(Composite parent, int style) {
        StructuredViewer viewer = super.createStructuredViewer(parent, style);
        return viewer;
    }

    protected void createMainLabel(Composite parent, int span) {
        if (this.tableName == null) {
            return;
        }
        Label label = new Label(parent, 0);
        label.setText(this.tableName);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
    }

    protected void updateCounter(int amount) {
        this.counter = amount;
        this.updateCounterLabel();
    }

    protected void updateCounterLabel() {
        String number = "" + this.getSelectionCount();
        String totalNumber = "" + this.getTotalCount();
        String message = MessageFormat.format(MakeUIPlugin.getResourceString(KEY_COUNTER), number, totalNumber);
        this.counterLabel.setText(message);
    }

    public int getSelectionCount() {
        return this.counter;
    }

    public void selectAll(boolean select) {
        this.handleSelectAll(select);
    }

    private int getTotalCount() {
        CheckboxTableViewer viewer = this.getTableViewer();
        return viewer.getTable().getItemCount();
    }

    protected void handleSelectAll(boolean select) {
        CheckboxTableViewer viewer = this.getTableViewer();
        viewer.setAllChecked(select);
        int selected = !select ? 0 : this.getTotalCount();
        this.updateCounter(selected);
    }

    protected void elementChecked(Object element, boolean checked) {
        int count = this.getSelectionCount();
        this.updateCounter(checked ? count + 1 : count - 1);
    }
}

