/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CWatchpoint
extends CBreakpoint
implements ICWatchpoint {
    private static final String C_WATCHPOINT = "org.eclipse.cdt.debug.core.cWatchpointMarker";

    public CWatchpoint() {
    }

    public CWatchpoint(IResource resource, Map attributes, boolean add) throws CoreException {
        super(resource, CWatchpoint.getMarkerType(), attributes, add);
    }

    public boolean isWriteType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.write", true);
    }

    public boolean isReadType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.read", false);
    }

    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.expression", "");
    }

    public static String getMarkerType() {
        return C_WATCHPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        String expression;
        StringBuffer sb = new StringBuffer();
        if (this.isWriteType() && !this.isReadType()) {
            sb.append(BreakpointMessages.getString("CWatchpoint.1"));
        } else if (!this.isWriteType() && this.isReadType()) {
            sb.append(BreakpointMessages.getString("CWatchpoint.2"));
        } else if (this.isWriteType() && this.isReadType()) {
            sb.append(BreakpointMessages.getString("CWatchpoint.3"));
        } else {
            sb.append(BreakpointMessages.getString("CWatchpoint.4"));
        }
        sb.append(' ');
        String fileName = this.ensureMarker().getResource().getName();
        if (fileName != null && fileName.length() > 0) {
            sb.append(' ');
            sb.append(fileName);
        }
        if ((expression = this.getExpression()) != null && expression.length() > 0) {
            sb.append(MessageFormat.format(BreakpointMessages.getString("CWatchpoint.5"), expression));
        }
        sb.append(this.getConditionText());
        return sb.toString();
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }
}

