/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlockRow;
import org.eclipse.debug.core.DebugException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class MemoryPresentation {
    private static final int INTERVAL_BETWEEN_ADDRESS_AND_DATA = 2;
    private static final int INTERVAL_BETWEEN_DATA_ITEMS = 1;
    private static final int INTERVAL_BETWEEN_DATA_AND_ASCII = 1;
    private IFormattedMemoryBlock fBlock;
    private List fAddressZones = new LinkedList();
    private List fChangedZones = new LinkedList();
    private boolean fDisplayAscii = true;

    public IFormattedMemoryBlock getMemoryBlock() {
        return this.fBlock;
    }

    public void setMemoryBlock(IFormattedMemoryBlock block) {
        this.fBlock = block;
    }

    public String getText() {
        this.fAddressZones.clear();
        IFormattedMemoryBlockRow[] rows = this.getMemoryBlock() != null ? this.getMemoryBlock().getRows() : new IFormattedMemoryBlockRow[]{};
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < rows.length) {
            int offset = sb.length();
            sb.append(this.getRowText(rows[i]));
            this.fAddressZones.add(new Point(offset, offset + rows[i].getAddress().getCharsNum()));
            ++i;
        }
        return sb.toString();
    }

    public String[] getText(Point[] zones) {
        return new String[0];
    }

    public boolean isAcceptable(char ch, int offset) {
        if (this.isInAsciiArea(offset)) {
            return true;
        }
        if (this.isInDataArea(offset)) {
            return this.isValidValue(ch);
        }
        return false;
    }

    public Point[] getAddressZones() {
        return this.fAddressZones.toArray(new Point[this.fAddressZones.size()]);
    }

    public Point[] getChangedZones() {
        this.fChangedZones.clear();
        IAddress[] changedAddresses = this.getChangedAddresses();
        int i = 0;
        while (i < changedAddresses.length) {
            int asciiOffset;
            int dataOffset = this.getDataItemOffsetByAddress(changedAddresses[i]);
            if (dataOffset != -1) {
                this.fChangedZones.add(new Point(dataOffset, dataOffset + this.getDataItemLength() - 1));
            }
            if (this.displayASCII() && (asciiOffset = this.getAsciiOffsetByAddress(changedAddresses[i])) != -1) {
                this.fChangedZones.add(new Point(asciiOffset, asciiOffset));
            }
            ++i;
        }
        return this.fChangedZones.toArray(new Point[this.fChangedZones.size()]);
    }

    public String getStartAddress() {
        return this.fBlock != null ? this.fBlock.getRealStartAddress().toHexAddressString() : "";
    }

    public String getAddressExpression() {
        return this.fBlock != null ? this.fBlock.getAddressExpression() : "";
    }

    private String getInterval(int length) {
        char[] chars = new char[length];
        Arrays.fill(chars, ' ');
        return new String(chars);
    }

    private String getRowText(IFormattedMemoryBlockRow row) {
        StringBuffer result = new StringBuffer(this.getRowLength());
        result.append(row.getAddress().toHexAddressString());
        result.append(this.getInterval(2));
        String[] items = row.getData();
        int i = 0;
        while (i < items.length) {
            result.append(this.getDataItemPresentation(items[i]));
            result.append(this.getInterval(1));
            ++i;
        }
        if (this.displayASCII()) {
            result.append(this.getInterval(1));
            result.append(row.getASCII());
        }
        result.append('\n');
        return result.toString();
    }

    private int getRowLength() {
        return this.getAddressLength() + 2 + (this.getDataItemLength() + 1) * this.getNumberOfDataItemsInRow() + (this.displayASCII() ? 1 + this.getDataBytesPerRow() : 0) + 1;
    }

    private int getAddressLength() {
        return this.fBlock.getRealStartAddress().getCharsNum();
    }

    private boolean isInAsciiArea(int offset) {
        if (this.displayASCII() && this.getRowLength() != 0) {
            int asciiColumn;
            int pos = offset % this.getRowLength();
            return pos >= (asciiColumn = this.getAddressLength() + 2 + (this.getDataItemLength() + 1) * this.getNumberOfDataItemsInRow() + 1) && pos < this.getRowLength() - 1;
        }
        return false;
    }

    private boolean isInDataArea(int offset) {
        if (this.getRowLength() != 0) {
            int pos = offset % this.getRowLength();
            int dataBegin = this.getAddressLength() + 2;
            int dataEnd = dataBegin + (this.getDataItemLength() + 1) * this.getNumberOfDataItemsInRow();
            if (pos >= dataBegin && pos < dataEnd) {
                return this.isInDataItem(pos - dataBegin);
            }
        }
        return false;
    }

    private boolean isInDataItem(int pos) {
        int i = 0;
        while (i < this.getNumberOfDataItemsInRow()) {
            if (pos < i * (this.getDataItemLength() + 1)) {
                return false;
            }
            if (pos >= i * (this.getDataItemLength() + 1) && pos < i * (this.getDataItemLength() + 1) + this.getDataItemLength()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getDataItemLength() {
        if (this.getMemoryBlock() != null) {
            switch (this.getDataFormat()) {
                case 0: {
                    return this.getMemoryBlock().getWordSize() * 2;
                }
                case 3: {
                    return this.getDecimalDataItemLength(this.getMemoryBlock().getWordSize(), true);
                }
                case 4: {
                    return this.getDecimalDataItemLength(this.getMemoryBlock().getWordSize(), false);
                }
            }
        }
        return 0;
    }

    private int getNumberOfDataItemsInRow() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().getNumberOfColumns();
        }
        return 0;
    }

    protected boolean displayASCII() {
        if (this.canDisplayAscii()) {
            return this.fDisplayAscii;
        }
        return false;
    }

    protected void setDisplayAscii(boolean displayAscii) {
        this.fDisplayAscii = displayAscii;
    }

    private int getDataBytesPerRow() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().getNumberOfColumns() * this.getMemoryBlock().getWordSize();
        }
        return 0;
    }

    private boolean isValidValue(char ch) {
        switch (this.getDataFormat()) {
            case 0: {
                return this.isHexadecimal(ch);
            }
        }
        return false;
    }

    private boolean isHexadecimal(char ch) {
        return Character.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private int getDataFormat() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().getFormat();
        }
        return 0;
    }

    private IAddress[] getChangedAddresses() {
        return this.getMemoryBlock() != null ? this.getMemoryBlock().getChangedAddresses() : new IAddress[]{};
    }

    private int getDataItemOffsetByAddress(IAddress address) {
        if (this.getMemoryBlock() != null) {
            IFormattedMemoryBlockRow[] rows = this.getMemoryBlock().getRows();
            int i = 0;
            while (i < rows.length) {
                int wordSize = this.getMemoryBlock().getWordSize();
                int numberOfColumns = this.getMemoryBlock().getNumberOfColumns();
                if (address.compareTo((Object)rows[i].getAddress()) >= 0 && address.compareTo((Object)rows[i].getAddress().add(BigInteger.valueOf(wordSize * numberOfColumns))) < 0) {
                    int j = 1;
                    while (j <= numberOfColumns) {
                        if (address.compareTo((Object)rows[i].getAddress().add(BigInteger.valueOf((j - 1) * wordSize))) >= 0 && address.compareTo((Object)rows[i].getAddress().add(BigInteger.valueOf(j * wordSize))) < 0) {
                            return i * this.getRowLength() + (j - 1) * (this.getDataItemLength() + 1) + address.getCharsNum() + 2;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    private int getAsciiOffsetByAddress(IAddress address) {
        IFormattedMemoryBlockRow[] rows;
        if (this.getMemoryBlock() != null && (rows = this.getMemoryBlock().getRows()).length > 0) {
            IFormattedMemoryBlockRow firstRow = rows[0];
            IFormattedMemoryBlockRow lastRow = rows[rows.length - 1];
            if (address.compareTo((Object)firstRow.getAddress()) >= 0 && address.compareTo((Object)lastRow.getAddress()) <= 0) {
                BigInteger asciiOffset = firstRow.getAddress().distanceTo(address);
                int asciiRowlength = this.getMemoryBlock().getWordSize() * this.getMemoryBlock().getNumberOfColumns();
                int numberOfRows = asciiOffset.intValue() / asciiRowlength;
                int offsetInRow = asciiOffset.intValue() % asciiRowlength;
                return numberOfRows * this.getRowLength() + address.getCharsNum() + 2 + (this.getDataItemLength() + 1) * this.getMemoryBlock().getNumberOfColumns() + 1 + offsetInRow;
            }
        }
        return -1;
    }

    protected boolean canDisplayAscii() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().displayASCII();
        }
        return false;
    }

    protected int getDataItemIndex(int offset) {
        int row = offset / this.getRowLength();
        int pos = offset % this.getRowLength() - this.getAddressLength() - 2;
        int i = 0;
        while (i < this.getNumberOfDataItemsInRow()) {
            if (pos < i * (this.getDataItemLength() + 1)) {
                return -1;
            }
            if (pos >= i * (this.getDataItemLength() + 1) && pos < i * (this.getDataItemLength() + 1) + this.getDataItemLength()) {
                return i + row * this.getNumberOfDataItemsInRow();
            }
            ++i;
        }
        if (this.displayASCII() && pos >= this.getNumberOfDataItemsInRow() * (this.getDataItemLength() + 1) + 1) {
            return (pos - (this.getNumberOfDataItemsInRow() * (this.getDataItemLength() + 1) + 1)) * 2 / this.getDataItemLength() + row * this.getNumberOfDataItemsInRow();
        }
        return -1;
    }

    private int getDataItemOffset(int index) {
        int row = index / this.getNumberOfDataItemsInRow();
        int pos = index % this.getNumberOfDataItemsInRow();
        return row * this.getRowLength() + this.getAddressLength() + 2 + pos * (this.getDataItemLength() + 1);
    }

    private char[] getDataItemChars(int index) {
        if (this.getMemoryBlock() != null) {
            String[] data;
            int rowNumber = index / this.getMemoryBlock().getNumberOfColumns();
            int pos = index % this.getMemoryBlock().getNumberOfColumns();
            IFormattedMemoryBlockRow[] rows = this.getMemoryBlock().getRows();
            if (rowNumber < rows.length && pos < (data = rows[rowNumber].getData()).length) {
                return data[pos].toCharArray();
            }
        }
        return new char[0];
    }

    private int getOffsetInDataItem(int offset, int index) {
        if (this.isInDataArea(offset)) {
            return offset - this.getDataItemOffset(index);
        }
        return -1;
    }

    public void dispose() {
        if (this.fAddressZones != null) {
            this.fAddressZones.clear();
        }
        if (this.fChangedZones != null) {
            this.fChangedZones.clear();
        }
    }

    private String getDataItemPresentation(String item) {
        switch (this.getDataFormat()) {
            case 0: {
                return this.convertToHex(this.getWordSize(), item);
            }
            case 3: {
                return this.convertToDecimal(this.getWordSize(), item, true);
            }
            case 4: {
                return this.convertToDecimal(this.getWordSize(), item, false);
            }
        }
        return "";
    }

    private int getDecimalDataItemLength(int wordSize, boolean signed) {
        switch (wordSize) {
            case 1: {
                return signed ? 4 : 3;
            }
            case 2: {
                return signed ? 6 : 5;
            }
            case 4: {
                return signed ? 11 : 10;
            }
        }
        return 0;
    }

    private int getWordSize() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().getWordSize();
        }
        return 0;
    }

    private String convertToHex(int wordsize, String item) {
        if (!this.getMemoryBlock().isLittleEndian() || wordsize == 1) {
            return item;
        }
        int length = item.length();
        StringBuffer ret = new StringBuffer(length);
        int i = length - 2;
        while (i >= 0) {
            ret.append(item.substring(i, i + 2));
            i -= 2;
        }
        return ret.toString();
    }

    private String convertToDecimal(int wordSize, String item, boolean signed) {
        String result = "";
        boolean le = this.getMemoryBlock().isLittleEndian();
        switch (wordSize) {
            case 1: {
                result = Long.toString(signed ? CDebugUtils.toByte((char[])item.toCharArray(), (boolean)le) : CDebugUtils.toUnsignedByte((char[])item.toCharArray(), (boolean)le));
                break;
            }
            case 2: {
                result = Long.toString(signed ? CDebugUtils.toShort((char[])item.toCharArray(), (boolean)le) : CDebugUtils.toUnsignedShort((char[])item.toCharArray(), (boolean)le));
                break;
            }
            case 4: {
                result = Long.toString(signed ? (long)CDebugUtils.toInt((char[])item.toCharArray(), (boolean)le) : CDebugUtils.toUnsignedInt((char[])item.toCharArray(), (boolean)le));
            }
        }
        return CDebugUtils.prependString((String)result, (int)this.getDataItemLength(), (char)' ');
    }

    protected boolean isStartAddressChanged() {
        if (this.getMemoryBlock() != null) {
            return this.getMemoryBlock().isStartAddressChanged();
        }
        return false;
    }

    protected String getNewItemValue(int offset, char newChar) {
        int index;
        if (this.getMemoryBlock() != null && (index = this.getDataItemIndex(offset)) != -1) {
            char[] chars = this.getDataItemChars(index);
            if (this.isInDataArea(offset)) {
                int charIndex = this.getOffsetInDataItem(offset, index);
                chars[charIndex] = newChar;
            }
            if (this.isInAsciiArea(offset)) {
                chars = CDebugUtils.getByteText((byte)((byte)newChar));
            }
            return new String(chars);
        }
        return null;
    }

    protected void setItemValue(int offset, char ch) {
        String newValue;
        int index;
        if (this.getMemoryBlock() != null && (index = this.getDataItemIndex(offset)) != -1 && (newValue = this.getNewItemValue(offset, ch)) != null) {
            try {
                this.getMemoryBlock().setItemValue(index, newValue);
                return;
            }
            catch (DebugException debugException) {
                Display.getDefault().beep();
            }
        }
        Display.getDefault().beep();
    }
}

