/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.core.model.IEnableDisableTarget;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegister;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterGroup
extends CDebugElement
implements IRegisterGroup,
IEnableDisableTarget {
    private ICDIRegisterGroup fCDIRegisterGroup;
    private IRegister[] fRegisters;
    private boolean fIsEnabled = true;
    static /* synthetic */ Class class$0;

    public CRegisterGroup(CDebugTarget target, ICDIRegisterGroup regGroup) {
        super(target);
        this.fCDIRegisterGroup = regGroup;
    }

    public String getName() throws DebugException {
        return this.fCDIRegisterGroup.getName();
    }

    public IRegister[] getRegisters() throws DebugException {
        if (this.fRegisters == null) {
            try {
                ICDIRegisterDescriptor[] regDescs = this.fCDIRegisterGroup.getRegisterDescriptors();
                this.fRegisters = new IRegister[regDescs.length];
                int i = 0;
                while (i < this.fRegisters.length) {
                    this.fRegisters[i] = new CRegister(this, regDescs[i]);
                    if (((CRegister)this.fRegisters[i]).isEnabled()) {
                        ((CRegister)this.fRegisters[i]).setEnabled(this.isEnabled());
                    }
                    ++i;
                }
            }
            catch (CDIException e) {
                CDebugElement.requestFailed(e.getMessage(), null);
            }
        }
        return this.fRegisters;
    }

    public boolean hasRegisters() throws DebugException {
        try {
            return this.fCDIRegisterGroup.hasRegisters();
        }
        catch (CDIException e) {
            CDebugElement.requestFailed(e.getMessage(), null);
            return false;
        }
    }

    public void dispose() {
        if (this.fRegisters == null) {
            return;
        }
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null) {
                ((CRegister)this.fRegisters[i]).dispose();
                this.fRegisters[i] = null;
            }
            ++i;
        }
    }

    public void targetSuspended() {
        if (this.fRegisters == null) {
            return;
        }
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null && ((CRegister)this.fRegisters[i]).hasErrors()) {
                ((CRegister)this.fRegisters[i]).dispose();
                this.fRegisters[i] = null;
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IEnableDisableTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean canEnableDisable() {
        return true;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setEnabled(boolean enabled) throws DebugException {
        if (this.fRegisters != null) {
            IRegister[] iRegisterArray = this.fRegisters;
            // MONITORENTER : this.fRegisters
            if (this.fRegisters != null) {
                int i = 0;
                while (i < this.fRegisters.length) {
                    if (this.fRegisters[i] instanceof CRegister) {
                        ((CRegister)this.fRegisters[i]).setEnabled(enabled);
                    }
                    ++i;
                }
            }
            // MONITOREXIT : iRegisterArray
        }
        this.fIsEnabled = enabled;
        this.fireChangeEvent(512);
    }
}

