/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.util.ArrayList;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;

public final class IndexedFileHashedArray {
    private IndexedFile[] elements;
    private int elementSize;
    private int threshold;
    private int lastId;
    private ArrayList replacedElements;

    public IndexedFileHashedArray(int size) {
        if (size < 7) {
            size = 7;
        }
        this.elements = new IndexedFile[2 * size + 1];
        this.elementSize = 0;
        this.threshold = size + 1;
        this.lastId = 0;
        this.replacedElements = null;
    }

    public IndexedFile add(IDocument document) {
        return this.add(new IndexedFile(document, ++this.lastId));
    }

    public IndexedFile add(String path) {
        return this.add(new IndexedFile(path, ++this.lastId));
    }

    private IndexedFile add(IndexedFile file) {
        IndexedFile current;
        int length = this.elements.length;
        String path = file.getPath();
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPath().equals(path)) {
                if (this.replacedElements == null) {
                    this.replacedElements = new ArrayList(5);
                }
                this.replacedElements.add(current);
                this.elements[index] = file;
                return this.elements[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.elements[index] = file;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return file;
    }

    public IndexedFile[] asArray() {
        IndexedFile current;
        IndexedFile[] array = new IndexedFile[this.lastId];
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            current = this.elements[i];
            if (current != null) {
                array[current.fileNumber - 1] = current;
            }
            ++i;
        }
        if (this.replacedElements != null) {
            i = 0;
            length = this.replacedElements.size();
            while (i < length) {
                array[current.fileNumber - 1] = current = (IndexedFile)this.replacedElements.get(i);
                ++i;
            }
        }
        return array;
    }

    public IndexedFile get(String path) {
        IndexedFile current;
        int length = this.elements.length;
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPath().equals(path)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void grow() {
        IndexedFileHashedArray newArray = new IndexedFileHashedArray(this.elementSize * 2);
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            if (this.elements[i] != null) {
                newArray.add(this.elements[i]);
            }
            ++i;
        }
        this.elements = newArray.elements;
        this.elementSize = newArray.elementSize;
        this.threshold = newArray.threshold;
    }

    public int size() {
        return this.elementSize + (this.replacedElements == null ? 0 : this.replacedElements.size());
    }

    public String toString() {
        String s = "";
        IndexedFile[] files = this.asArray();
        int i = 0;
        int length = files.length;
        while (i < length) {
            s = String.valueOf(s) + files[i].toString() + "\n";
            ++i;
        }
        return s;
    }
}

