/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDeclarationSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TemplateParameterTypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;

public class UndefinedTemplateSymbol
extends BasicSymbol
implements ITemplateSymbol {
    private List _contents = Collections.EMPTY_LIST;
    private CharArrayObjectMap _containedSymbols = CharArrayObjectMap.EMPTY_MAP;
    private List _argumentList = Collections.EMPTY_LIST;
    private ObjectMap _instantiations = ObjectMap.EMPTY_MAP;

    public UndefinedTemplateSymbol(ParserSymbolTable table, char[] name) {
        super(table, name);
    }

    public UndefinedTemplateSymbol(ParserSymbolTable table, char[] name, ITypeInfo.eType typeInfo) {
        super(table, name, typeInfo);
    }

    public Object clone() {
        UndefinedTemplateSymbol copy = (UndefinedTemplateSymbol)super.clone();
        copy._containedSymbols = (CharArrayObjectMap)(this._containedSymbols != CharArrayObjectMap.EMPTY_MAP ? this._containedSymbols.clone() : this._containedSymbols);
        copy._contents = this._contents != Collections.EMPTY_LIST ? (List)((ArrayList)this._contents).clone() : this._contents;
        copy._instantiations = this._instantiations != ObjectMap.EMPTY_MAP ? (ObjectMap)this._instantiations.clone() : this._instantiations;
        copy._argumentList = this._argumentList != Collections.EMPTY_LIST ? (List)((ArrayList)this._argumentList).clone() : this._argumentList;
        return copy;
    }

    public void addSymbol(ISymbol obj) throws ParserSymbolTableException {
        UndefinedTemplateSymbol containing = this;
        if (!(obj instanceof UndefinedTemplateSymbol)) {
            throw new ParserSymbolTableError(-1);
        }
        obj.setContainingSymbol(containing);
        containing.putInContainedSymbols(obj.getName(), obj);
        obj.setIsTemplateMember(this.isTemplateMember() || this.getType() == ITypeInfo.t_template);
        this.addToContents(obj);
    }

    public void addTemplateId(ISymbol symbol, List args) throws ParserSymbolTableException {
        throw new ParserSymbolTableException(4);
    }

    public boolean hasUsingDirectives() {
        return false;
    }

    public List getUsingDirectives() {
        return null;
    }

    public IUsingDirectiveSymbol addUsingDirective(IContainerSymbol namespace) throws ParserSymbolTableException {
        return null;
    }

    public IUsingDeclarationSymbol addUsingDeclaration(char[] name) throws ParserSymbolTableException {
        return null;
    }

    public IUsingDeclarationSymbol addUsingDeclaration(char[] name, IContainerSymbol declContext) throws ParserSymbolTableException {
        return null;
    }

    public CharArrayObjectMap getContainedSymbols() {
        return this._containedSymbols;
    }

    protected void putInContainedSymbols(char[] key, Object obj) {
        if (this._containedSymbols == CharArrayObjectMap.EMPTY_MAP) {
            this._containedSymbols = new CharArrayObjectMap(4);
        }
        this._containedSymbols.put(key, obj);
    }

    public List prefixLookup(TypeFilter filter, char[] prefix, boolean qualified, List paramList) throws ParserSymbolTableException {
        return null;
    }

    public ISymbol elaboratedLookup(ITypeInfo.eType type, char[] name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, type){
            private TypeFilter filter = null;
            private final ITypeInfo.eType t;
            {
                this.t = eType2;
            }

            public TypeFilter getFilter() {
                if (this.t == ITypeInfo.t_any) {
                    return ParserSymbolTable.LookupData.ANY_FILTER;
                }
                if (this.filter == null) {
                    this.filter = new TypeFilter(this.t);
                }
                return this.filter;
            }
        };
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (this.isTemplateMember() && found instanceof ITemplateSymbol) {
            boolean areWithinTemplate = false;
            IContainerSymbol container = this.getContainingSymbol();
            while (container != null) {
                if (container == found) {
                    areWithinTemplate = true;
                    break;
                }
                container = container.getContainingSymbol();
            }
            if (areWithinTemplate) {
                return TemplateEngine.instantiateWithinTemplateScope(this, (ITemplateSymbol)found);
            }
        }
        return found;
    }

    public ISymbol lookup(char[] name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name);
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (this.isTemplateMember() && found instanceof ITemplateSymbol) {
            return TemplateEngine.instantiateWithinTemplateScope(this, (ITemplateSymbol)found);
        }
        if (found == null && this.getTypeInfo() instanceof TemplateParameterTypeInfo) {
            found = this.getSymbolTable().newUndefinedTemplateSymbol(name, ITypeInfo.t_undef);
            this.addSymbol(found);
        }
        return found;
    }

    public ISymbol lookupMemberForDefinition(char[] name) throws ParserSymbolTableException {
        return null;
    }

    public IParameterizedSymbol lookupMethodForDefinition(char[] name, List parameters) throws ParserSymbolTableException {
        return null;
    }

    public ISymbol lookupNestedNameSpecifier(char[] name) throws ParserSymbolTableException {
        return this.lookupNestedNameSpecifier(name, this);
    }

    private ISymbol lookupNestedNameSpecifier(char[] name, IContainerSymbol inSymbol) throws ParserSymbolTableException {
        ISymbol foundSymbol = null;
        TypeFilter filter = new TypeFilter(ITypeInfo.t_namespace);
        filter.addAcceptedType(ITypeInfo.t_class);
        filter.addAcceptedType(ITypeInfo.t_struct);
        filter.addAcceptedType(ITypeInfo.t_union);
        filter.addAcceptedType(ITypeInfo.t_templateParameter);
        filter.addAcceptedType(IASTNode.LookupKind.TYPEDEFS);
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, filter){
            private final TypeFilter typeFilter;
            {
                this.typeFilter = typeFilter;
            }

            public TypeFilter getFilter() {
                return this.typeFilter;
            }
        };
        data.qualified = true;
        ParserSymbolTable.lookup(data, inSymbol);
        if (data.foundItems != null) {
            foundSymbol = this.getSymbolTable().resolveAmbiguities(data);
        }
        if (foundSymbol == null && this.getTypeInfo() instanceof TemplateParameterTypeInfo) {
            foundSymbol = this.getSymbolTable().newUndefinedTemplateSymbol(name, ITypeInfo.t_undef);
            this.addSymbol(foundSymbol);
        }
        return foundSymbol;
    }

    public ISymbol qualifiedLookup(char[] name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name);
        data.qualified = true;
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (found == null) {
            found = this.getSymbolTable().newUndefinedTemplateSymbol(name, ITypeInfo.t_undef);
            this.addSymbol(found);
        }
        return found;
    }

    public ISymbol qualifiedLookup(char[] name, final ITypeInfo.eType t) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name){
            private TypeFilter filter = null;

            public TypeFilter getFilter() {
                if (t == ITypeInfo.t_any) {
                    return ParserSymbolTable.LookupData.ANY_FILTER;
                }
                if (this.filter == null) {
                    this.filter = new TypeFilter(t);
                }
                return this.filter;
            }
        };
        data.qualified = true;
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (found == null) {
            found = this.getSymbolTable().newUndefinedTemplateSymbol(name, ITypeInfo.t_undef);
            this.addSymbol(found);
        }
        return found;
    }

    public IParameterizedSymbol unqualifiedFunctionLookup(char[] name, List parameters) throws ParserSymbolTableException {
        return null;
    }

    public IParameterizedSymbol memberFunctionLookup(char[] name, List parameters) throws ParserSymbolTableException {
        return null;
    }

    public IParameterizedSymbol qualifiedFunctionLookup(char[] name, List parameters) throws ParserSymbolTableException {
        return null;
    }

    public ISymbol lookupTemplateId(char[] name, List arguments) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name);
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        if (found == null) {
            found = this.getSymbolTable().newUndefinedTemplateSymbol(name, ITypeInfo.t_template);
            this.addSymbol(found);
        }
        if (found != null) {
            if (found.isType(ITypeInfo.t_templateParameter) && found.getTypeInfo().getTemplateParameterType() == ITypeInfo.t_template || found.isType(ITypeInfo.t_template)) {
                found = ((ITemplateSymbol)found).instantiate(arguments);
            } else if (found.getContainingSymbol().isType(ITypeInfo.t_template)) {
                found = ((ITemplateSymbol)found.getContainingSymbol()).instantiate(arguments);
            }
        }
        return found;
    }

    public ISymbol lookupFunctionTemplateId(char[] name, List parameters, List arguments, boolean forDefinition) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, parameters, arguments){
            private final List params;
            private final List templateParams;
            {
                this.params = list == null ? Collections.EMPTY_LIST : list;
                this.templateParams = list2;
            }

            public List getParameters() {
                return this.params;
            }

            public List getTemplateParameters() {
                return this.templateParams;
            }

            public TypeFilter getFilter() {
                return ParserSymbolTable.LookupData.FUNCTION_FILTER;
            }
        };
        data.exactFunctionsOnly = forDefinition;
        ParserSymbolTable.lookup(data, this);
        ISymbol found = this.getSymbolTable().resolveAmbiguities(data);
        return found;
    }

    public IContainerSymbol lookupTemplateIdForDefinition(char[] name, List arguments) throws ParserSymbolTableException {
        return null;
    }

    public boolean isVisible(ISymbol symbol, IContainerSymbol qualifyingSymbol) {
        return false;
    }

    public Iterator getContentsIterator() {
        return this.getContents().iterator();
    }

    protected void addToContents(IExtensibleSymbol symbol) {
        if (this._contents == Collections.EMPTY_LIST) {
            this._contents = new ArrayList(8);
        }
        this._contents.add(symbol);
    }

    protected List getContents() {
        return this._contents;
    }

    public void addParameter(ISymbol param) {
        throw new ParserSymbolTableError(0);
    }

    public void addParameter(ITypeInfo.eType type, int info, ITypeInfo.PtrOp ptrOp, boolean hasDefault) {
        throw new ParserSymbolTableError(0);
    }

    public void addParameter(ISymbol typeSymbol, int info, ITypeInfo.PtrOp ptrOp, boolean hasDefault) {
        throw new ParserSymbolTableError(0);
    }

    public CharArrayObjectMap getParameterMap() {
        return CharArrayObjectMap.EMPTY_MAP;
    }

    public List getParameterList() {
        return Collections.EMPTY_LIST;
    }

    public boolean hasSameParameters(IParameterizedSymbol newDecl) {
        return false;
    }

    public void setReturnType(ISymbol type) {
    }

    public ISymbol getReturnType() {
        return null;
    }

    public void setHasVariableArgs(boolean var) {
    }

    public boolean hasVariableArgs() {
        return false;
    }

    public void prepareForParameters(int numParams) {
    }

    public void addTemplateParameter(ISymbol param) throws ParserSymbolTableException {
        throw new ParserSymbolTableError(0);
    }

    public boolean hasSpecializations() {
        return false;
    }

    public void addSpecialization(ISpecializedSymbol spec) {
    }

    public List getSpecializations() {
        return null;
    }

    public IContainerSymbol getTemplatedSymbol() {
        return this;
    }

    public ObjectMap getDefinitionParameterMap() {
        return ObjectMap.EMPTY_MAP;
    }

    public IContainerSymbol findInstantiation(List arguments) {
        if (this._instantiations == ObjectMap.EMPTY_MAP) {
            return null;
        }
        int size = this._instantiations.size();
        List args = null;
        int i = 0;
        while (i < size) {
            args = (List)this._instantiations.keyAt(i);
            if (args.equals(arguments)) {
                return (IContainerSymbol)this._instantiations.get(args);
            }
            ++i;
        }
        return null;
    }

    public List findArgumentsFor(IContainerSymbol instance) {
        if (instance == null || !instance.isTemplateInstance()) {
            return null;
        }
        int size = this._instantiations.size();
        int i = 0;
        while (i < size) {
            List args = (List)this._instantiations.keyAt(i);
            if (this._instantiations.get(args) == instance) {
                return args;
            }
            ++i;
        }
        return null;
    }

    public void addInstantiation(IContainerSymbol instance, List args) {
        ArrayList key = new ArrayList(args);
        if (this._instantiations == ObjectMap.EMPTY_MAP) {
            this._instantiations = new ObjectMap(2);
        }
        this._instantiations.put(key, instance);
    }

    public void removeInstantiation(IContainerSymbol symbol) {
        List args = this.findArgumentsFor(symbol);
        if (args != null) {
            this._instantiations.remove(args);
        }
    }

    public void addExplicitSpecialization(ISymbol symbol, List args) throws ParserSymbolTableException {
    }

    public ISymbol instantiate(List arguments) throws ParserSymbolTableException {
        if (this.getType() != ITypeInfo.t_template && (this.getType() != ITypeInfo.t_templateParameter || this.getTypeInfo().getTemplateParameterType() != ITypeInfo.t_template)) {
            return null;
        }
        UndefinedTemplateSymbol instance = (UndefinedTemplateSymbol)this.findInstantiation(arguments);
        if (instance == null) {
            instance = (UndefinedTemplateSymbol)this.getSymbolTable().newUndefinedTemplateSymbol(this.getName(), this.getType());
            instance.setArgumentList(arguments);
            instance.setInstantiatedSymbol(this);
            this.addInstantiation(instance, arguments);
        }
        return instance;
    }

    public List getArgumentList() {
        return this._argumentList;
    }

    protected void setArgumentList(List list) {
        this._argumentList = new ArrayList(list);
    }

    public ISymbol instantiate(ITemplateSymbol template, ObjectMap argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember() || template == null) {
            return null;
        }
        if (this.getContainingSymbol() instanceof UndefinedTemplateSymbol) {
            ISymbol containingSymbol = ((UndefinedTemplateSymbol)this.getContainingSymbol()).instantiate(template, argMap);
            if (containingSymbol instanceof IContainerSymbol) {
                ISymbol symbol = this.isType(ITypeInfo.t_template) ? ((IContainerSymbol)containingSymbol).lookupTemplateId(this.getName(), this.getArgumentList()) : ((IContainerSymbol)containingSymbol).lookup(this.getName());
                if (symbol instanceof IDeferredTemplateInstance) {
                    symbol = ((IDeferredTemplateInstance)symbol).getTemplate();
                }
                if (symbol instanceof ITemplateSymbol) {
                    symbol = ((ITemplateSymbol)symbol).getTemplatedSymbol();
                }
                return symbol;
            }
            throw new ParserSymbolTableException(8);
        }
        if (this.isType(ITypeInfo.t_templateParameter) && argMap.containsKey(this)) {
            return ((ITypeInfo)argMap.get(this)).getTypeSymbol();
        }
        return null;
    }

    public IDeferredTemplateInstance deferredInstance(List args) {
        return null;
    }

    public ObjectMap getExplicitSpecializations() {
        return null;
    }

    public int getNumberDeferredInstantiations() {
        return 0;
    }

    public void registerDeferredInstatiation(Object obj0, Object obj1, ITemplateSymbol.DeferredKind kind, ObjectMap argMap) {
    }
}

