/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.projectconverter;

import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.projectconverter.ConverterMessages;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class UpdateManagedProject20 {
    private static final String ID_SEPARATOR = ".";

    UpdateManagedProject20() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void doProjectUpdate(IProgressMonitor monitor, IProject project) throws CoreException {
        String[] projectName = new String[]{project.getName()};
        IFile settingsFile = project.getFile(".cdtbuild");
        if (!settingsFile.exists()) {
            monitor.done();
            return;
        }
        monitor.beginTask(ConverterMessages.getFormattedString("UpdateManagedProject20.0", projectName), 1);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        UpdateManagedProjectManager.backupFile(settingsFile, "_20backup", monitor, project);
        try {
            try {
                InputStream stream = settingsFile.getContents();
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(stream);
                NodeList targetNodes = document.getElementsByTagName("target");
                int listSize = targetNodes.getLength();
                monitor.beginTask(ConverterMessages.getFormattedString("UpdateManagedProject20.1", projectName), listSize * 9);
                int targIndex = 0;
                while (true) {
                    block9: {
                        if (targIndex < listSize) break block9;
                        ((ManagedBuildInfo)info).setVersion(ManagedBuildManager.getBuildInfoVersion().toString());
                        info.setValid(true);
                        break;
                    }
                    Element oldTarget = (Element)targetNodes.item(targIndex);
                    String oldTargetId = oldTarget.getAttribute("id");
                    IManagedProject newProject = UpdateManagedProject20.convertTarget(project, oldTarget, monitor);
                    if (newProject != null) {
                        info.removeTarget(oldTargetId);
                        monitor.worked(9);
                    }
                    ++targIndex;
                }
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            ManagedBuildManager.saveBuildInfo(project, false);
            monitor.done();
            throw throwable;
        }
        {
            Object var14_18 = null;
        }
        ManagedBuildManager.saveBuildInfo(project, false);
        monitor.done();
    }

    protected static IManagedProject convertTarget(IProject project, Element oldTarget, IProgressMonitor monitor) throws CoreException {
        IManagedProject newProject;
        block7: {
            newProject = null;
            IProjectType newParent = null;
            String parentID = oldTarget.getAttribute("parent");
            oldTarget.getAttribute("id");
            newParent = ManagedBuildManager.getProjectType(parentID);
            if (newParent == null) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject20.9", parentID), null));
            }
            try {
                newProject = ManagedBuildManager.createManagedProject((IResource)project, newParent);
                NodeList configNodes = oldTarget.getElementsByTagName("configuration");
                int configIndex = 0;
                while (configIndex < configNodes.getLength()) {
                    try {
                        UpdateManagedProject20.convertConfiguration(newProject, newParent, (Element)configNodes.item(configIndex), monitor);
                    }
                    catch (CoreException coreException) {}
                    ++configIndex;
                }
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                IConfiguration[] newConfigs = newProject.getConfigurations();
                if (newConfigs.length > 0) {
                    info.setDefaultConfiguration(newConfigs[0]);
                    info.setSelectedConfiguration(newConfigs[0]);
                    break block7;
                }
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject20.10", newProject.getName()), null));
            }
            catch (BuildException e) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject20.11", new String[]{newProject.getName(), e.getMessage()}), null));
            }
        }
        monitor.worked(1);
        return newProject;
    }

    protected static void convertConfiguration(IManagedProject newProject, IProjectType newParent, Element oldConfig, IProgressMonitor monitor) throws CoreException {
        IBuilder builder;
        String builderName;
        String subId;
        int nnn;
        int i;
        Element targetEl;
        IConfiguration newParentConfig = null;
        IConfiguration newConfig = null;
        String parentId = oldConfig.getAttribute("parent");
        newParentConfig = newParent.getConfiguration(parentId);
        if (newParentConfig == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject20.2", parentId), null));
        }
        int randomElement = ManagedBuildManager.getRandomNumber();
        String newConfigId = String.valueOf(parentId) + ID_SEPARATOR + randomElement;
        newConfig = newProject.createConfiguration(newParentConfig, newConfigId);
        if (oldConfig.hasAttribute("name")) {
            newConfig.setName(oldConfig.getAttribute("name"));
        }
        if ((targetEl = (Element)oldConfig.getParentNode()).hasAttribute("artifactName")) {
            newConfig.setArtifactName(targetEl.getAttribute("artifactName"));
        }
        if (targetEl.hasAttribute("errorParsers")) {
            newConfig.setErrorParserIds(targetEl.getAttribute("errorParsers"));
        }
        if (targetEl.hasAttribute("cleanCommand")) {
            newConfig.setCleanCommand(targetEl.getAttribute("cleanCommand"));
        }
        if (targetEl.hasAttribute("extension")) {
            newConfig.setArtifactExtension(targetEl.getAttribute("extension"));
        }
        IToolChain toolChain = newConfig.getToolChain();
        if (targetEl.hasAttribute("osList")) {
            String oses = targetEl.getAttribute("osList");
            String[] osList = oses.split(",");
            i = 0;
            while (i < osList.length) {
                osList[i] = osList[i].trim();
                ++i;
            }
            toolChain.setOSList(osList);
        }
        if (targetEl.hasAttribute("archList")) {
            String archs = targetEl.getAttribute("archList");
            String[] archList = archs.split(",");
            i = 0;
            while (i < archList.length) {
                archList[i] = archList[i].trim();
                ++i;
            }
            toolChain.setArchList(archList);
        }
        if (targetEl.hasAttribute("binaryParser")) {
            String binaryParser = targetEl.getAttribute("binaryParser");
            ITargetPlatform targetPlatform = toolChain.getTargetPlatform();
            if (targetPlatform.isExtensionElement()) {
                nnn = ManagedBuildManager.getRandomNumber();
                subId = String.valueOf(targetPlatform.getId()) + ID_SEPARATOR + nnn;
                builderName = String.valueOf(targetPlatform.getName()) + ID_SEPARATOR + newConfig.getName();
                toolChain.createTargetPlatform(targetPlatform, subId, builderName, false);
            }
            targetPlatform.setBinaryParserId(binaryParser);
        }
        if (targetEl.hasAttribute("makeCommand")) {
            String makeCommand = targetEl.getAttribute("makeCommand");
            builder = toolChain.getBuilder();
            if (builder.isExtensionElement()) {
                nnn = ManagedBuildManager.getRandomNumber();
                subId = String.valueOf(builder.getId()) + ID_SEPARATOR + nnn;
                builderName = String.valueOf(builder.getName()) + ID_SEPARATOR + newConfig.getName();
                builder = toolChain.createBuilder(builder, subId, builderName, false);
            }
            builder.setCommand(makeCommand);
        }
        if (targetEl.hasAttribute("makeArguments")) {
            String makeArguments = targetEl.getAttribute("makeArguments");
            builder = toolChain.getBuilder();
            if (builder.isExtensionElement()) {
                nnn = ManagedBuildManager.getRandomNumber();
                subId = String.valueOf(builder.getId()) + ID_SEPARATOR + nnn;
                builderName = String.valueOf(builder.getName()) + ID_SEPARATOR + newConfig.getName();
                builder = toolChain.createBuilder(builder, subId, builderName, false);
            }
            builder.setArguments(makeArguments);
        }
        NodeList toolRefNodes = oldConfig.getElementsByTagName("toolReference");
        int refIndex = 0;
        while (refIndex < toolRefNodes.getLength()) {
            try {
                UpdateManagedProject20.convertToolRef(toolChain, (Element)toolRefNodes.item(refIndex), monitor);
            }
            catch (CoreException e) {
                newProject.removeConfiguration(newConfigId);
                throw e;
            }
            ++refIndex;
        }
        monitor.worked(1);
    }

    protected static void convertToolRef(IToolChain toolChain, Element oldToolRef, IProgressMonitor monitor) throws CoreException {
        if (!oldToolRef.hasAttribute("id")) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getResourceString("UpdateManagedProject20.3"), null));
        }
        String toolId = oldToolRef.getAttribute("id");
        IConfiguration configuration = toolChain.getParent();
        ITool[] tools = configuration.getTools();
        if (tools == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getResourceString("UpdateManagedProject20.4"), null));
        }
        ITool tool = null;
        int i = 0;
        while (i < tools.length) {
            block14: {
                ITool curTool = tools[i];
                ITool parent = curTool.getSuperClass();
                String curToolId = curTool.getId();
                while (parent != null) {
                    String parentId = parent.getId();
                    if (parentId.equals(toolId)) break;
                    parent = parent.getSuperClass();
                }
                if (parent != null) {
                    try {
                        Integer.decode(curToolId.substring(curToolId.lastIndexOf(46) + 1));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        break block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block14;
                    }
                    tool = curTool;
                    break;
                }
            }
            ++i;
        }
        if (tool == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject20.5", toolId), null));
        }
        if (oldToolRef.hasAttribute("command")) {
            tool.setToolCommand(oldToolRef.getAttribute("command"));
        }
        if (oldToolRef.hasAttribute("outputFlag")) {
            tool.setOutputFlag(oldToolRef.getAttribute("outputFlag"));
        }
        if (oldToolRef.hasAttribute("outputPrefix")) {
            tool.setOutputPrefix(oldToolRef.getAttribute("outputPrefix"));
        }
        if (oldToolRef.hasAttribute("outputs")) {
            String outputs = oldToolRef.getAttribute("outputs");
            tool.setOutputExtensions(outputs);
        }
        NodeList optRefs = oldToolRef.getElementsByTagName("optionReference");
        int refIndex = optRefs.getLength() - 1;
        while (refIndex >= 0) {
            UpdateManagedProject20.convertOptionRef(toolChain, tool, (Element)optRefs.item(refIndex), monitor);
            --refIndex;
        }
        monitor.worked(1);
    }

    protected static void convertOptionRef(IToolChain toolChain, ITool tool, Element optRef, IProgressMonitor monitor) throws CoreException {
        if (!optRef.hasAttribute("id")) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getResourceString("UpdateManagedProject20.6"), null));
        }
        String optId = optRef.getAttribute("id");
        IConfiguration configuration = toolChain.getParent();
        IOption[] options = tool.getOptions();
        IOption option = null;
        int i = 0;
        while (i < options.length) {
            String parentId;
            IOption curOption = options[i];
            IOption parent = curOption.getSuperClass();
            curOption.getId();
            if (parent != null && (parentId = parent.getId()).equals(optId)) {
                option = curOption;
                break;
            }
            ++i;
        }
        if (option == null) {
            option = tool.getOptionById(optId);
        }
        if (option != null) {
            try {
                int type = option.getValueType();
                switch (type) {
                    case 0: {
                        if (optRef.hasAttribute("defaultValue")) {
                            Boolean bool = new Boolean(optRef.getAttribute("defaultValue"));
                            configuration.setOption(tool, option, bool);
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (optRef.hasAttribute("defaultValue")) {
                            configuration.setOption(tool, option, optRef.getAttribute("defaultValue"));
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        Vector<String> values = new Vector<String>();
                        NodeList nodes = optRef.getElementsByTagName("listOptionValue");
                        int j = 0;
                        while (j < nodes.getLength()) {
                            Boolean isBuiltIn;
                            Node node = nodes.item(j);
                            if (node.getNodeType() == 1 && !(isBuiltIn = new Boolean(((Element)node).getAttribute("builtIn"))).booleanValue()) {
                                values.add(((Element)node).getAttribute("value"));
                            }
                            ++j;
                        }
                        configuration.setOption(tool, option, values.toArray(new String[values.size()]));
                        break;
                    }
                }
            }
            catch (BuildException e) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject20.8", e.getMessage()), (Throwable)e));
            }
        }
    }
}

