/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.cdt.debug.mi.core.IMITTY;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MIProcess;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecAbort;
import org.eclipse.cdt.debug.mi.core.command.MIExecInterrupt;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowExitCode;
import org.eclipse.cdt.debug.mi.core.command.MIInfoProgram;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowExitCodeInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoProgramInfo;

public class MIInferior
extends Process {
    static final int SUSPENDED = 1;
    static final int RUNNING = 2;
    static final int TERMINATED = 4;
    boolean connected = false;
    boolean exitCodeKnown = false;
    int exitCode = 0;
    int state = 0;
    MISession session;
    OutputStream out;
    InputStream in;
    PipedOutputStream inPiped;
    PipedInputStream err;
    PipedOutputStream errPiped;
    IMITTY tty;
    int inferiorPID;

    MIInferior(MISession mi, IMITTY p) {
        this.session = mi;
        this.tty = p;
        if (this.tty != null) {
            this.out = this.tty.getOutputStream();
            this.in = this.tty.getInputStream();
        }
    }

    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new OutputStream(){
                StringBuffer buf = new StringBuffer();

                public void write(int b) throws IOException {
                    if (!MIInferior.this.isRunning()) {
                        throw new IOException(MIPlugin.getResourceString("src.MIInferior.target_is_suspended"));
                    }
                    OutputStream channel = MIInferior.this.session.getChannelOutputStream();
                    if (channel == null) {
                        throw new IOException(MIPlugin.getResourceString("src.MIInferior.No_session"));
                    }
                    channel.write(b);
                }
            };
        }
        return this.out;
    }

    public InputStream getInputStream() {
        if (this.in == null) {
            try {
                this.inPiped = new PipedOutputStream();
                this.in = new PipedInputStream(this.inPiped);
            }
            catch (IOException iOException) {}
        }
        return this.in;
    }

    public InputStream getErrorStream() {
        if (this.err == null) {
            try {
                this.errPiped = new PipedOutputStream();
                this.err = new PipedInputStream(this.errPiped);
            }
            catch (IOException iOException) {}
        }
        return this.err;
    }

    public synchronized void waitForSync() throws InterruptedException {
        while (this.state != 4) {
            this.wait();
        }
    }

    public int waitFor() throws InterruptedException {
        this.waitForSync();
        return this.exitValue();
    }

    public int exitValue() {
        if (this.isTerminated()) {
            if (!this.session.isTerminated() && !this.exitCodeKnown) {
                CommandFactory factory = this.session.getCommandFactory();
                MIGDBShowExitCode code = factory.createMIGDBShowExitCode();
                try {
                    this.session.postCommand(code);
                    MIGDBShowExitCodeInfo info = code.getMIGDBShowExitCodeInfo();
                    this.exitCode = info.getCode();
                }
                catch (MIException mIException) {}
                this.exitCodeKnown = true;
            }
            return this.exitCode;
        }
        throw new IllegalThreadStateException();
    }

    public void destroy() {
        try {
            this.terminate();
        }
        catch (MIException mIException) {}
    }

    public void terminate() throws MIException {
        if (this.session.isAttachSession() && this.isConnected() || this.session.isProgramSession() && !this.isTerminated()) {
            if (this.isRunning()) {
                this.interrupt();
            }
            int token = 0;
            if (this.isSuspended()) {
                try {
                    CommandFactory factory = this.session.getCommandFactory();
                    MIExecAbort abort = factory.createMIExecAbort();
                    this.session.postCommand0(abort, -1L);
                    token = abort.getToken();
                }
                catch (MIException mIException) {}
            }
            this.setTerminated(token, true);
        } else if (this.session.isCoreSession() && !this.isTerminated()) {
            this.setTerminated();
        }
    }

    public void interrupt() throws MIException {
        MIProcess gdb = this.session.getGDBProcess();
        CommandFactory factory = this.session.getCommandFactory();
        MIExecInterrupt interrupt = factory.createMIExecInterrupt();
        if (interrupt != null) {
            try {
                this.session.postCommand(interrupt);
                interrupt.getMIInfo();
                MIInferior mIInferior = this;
                synchronized (mIInferior) {
                    int i = 0;
                    while (this.state == 2 && i < 5) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                }
            }
            catch (MIException mIException) {}
        } else if (gdb.canInterrupt(this)) {
            gdb.interrupt(this);
        }
        if (this.state == 2) {
            throw new MIException(MIPlugin.getResourceString("src.MIInferior.Failed_to_interrupt"));
        }
    }

    public boolean isSuspended() {
        return this.state == 1;
    }

    public boolean isRunning() {
        return this.state == 2;
    }

    public boolean isTerminated() {
        return this.state == 4;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void setConnected() {
        this.connected = true;
    }

    public synchronized void setDisconnected() {
        this.connected = false;
    }

    public synchronized void setSuspended() {
        this.state = 1;
        this.notifyAll();
    }

    public synchronized void setRunning() {
        this.state = 2;
        this.notifyAll();
    }

    public synchronized void setTerminated() {
        this.setTerminated(0, true);
    }

    synchronized void setTerminated(int token, boolean fireEvent) {
        this.state = 4;
        try {
            if (this.inPiped != null) {
                this.inPiped.close();
                this.inPiped = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.errPiped != null) {
                this.errPiped.close();
                this.errPiped = null;
            }
        }
        catch (IOException iOException) {}
        if (this.tty != null) {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
                this.in = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                this.out = null;
            }
        }
        if (fireEvent) {
            this.session.fireEvent(new MIInferiorExitEvent(this.session, token));
        }
        this.notifyAll();
    }

    public OutputStream getPipedOutputStream() {
        return this.inPiped;
    }

    public OutputStream getPipedErrorStream() {
        return this.errPiped;
    }

    public IMITTY getTTY() {
        return this.tty;
    }

    public void update() {
        if (this.getInferiorPID() == 0) {
            int pid = 0;
            if (!this.isConnected()) {
                CommandFactory factory = this.session.getCommandFactory();
                MIInfoProgram prog = factory.createMIInfoProgram();
                try {
                    this.session.postCommand(prog);
                    MIInfoProgramInfo info = prog.getMIInfoProgramInfo();
                    pid = info.getPID();
                }
                catch (MIException mIException) {}
            }
            this.setInferiorPID(pid == 0 ? -1 : pid);
        }
    }

    public void setInferiorPID(int pid) {
        this.inferiorPID = pid;
    }

    public int getInferiorPID() {
        return this.inferiorPID;
    }
}

