/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ArchiveInfo;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Archive
extends Openable
implements IArchive {
    IBinaryParser.IBinaryArchive binaryArchive;
    static /* synthetic */ Class class$0;

    public Archive(ICElement parent, IFile file, IBinaryParser.IBinaryArchive ar) {
        this(parent, file.getLocation(), ar);
    }

    public Archive(ICElement parent, IPath path, IBinaryParser.IBinaryArchive ar) {
        super(parent, path, 18);
        this.binaryArchive = ar;
    }

    public IBinary[] getBinaries() throws CModelException {
        ICElement[] e = this.getChildren();
        IBinary[] b = new IBinary[e.length];
        System.arraycopy(e, 0, b, 0, e.length);
        return b;
    }

    public boolean isReadOnly() {
        return true;
    }

    public CElementInfo createElementInfo() {
        return new ArchiveInfo(this);
    }

    protected ArchiveInfo getArchiveInfo() throws CModelException {
        return (ArchiveInfo)this.getElementInfo();
    }

    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        return this.computeChildren(info, underlyingResource);
    }

    public boolean computeChildren(OpenableInfo info, IResource res) {
        IBinaryParser.IBinaryArchive ar = this.getBinaryArchive();
        if (ar != null) {
            IBinaryParser.IBinaryObject[] objects = ar.getObjects();
            int i = 0;
            while (i < objects.length) {
                IBinaryParser.IBinaryObject obj = objects[i];
                Binary binary = new Binary((ICElement)this, ar.getPath().append(obj.getName()), obj);
                info.addChild(binary);
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.IBinaryParser$IBinaryArchive");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getBinaryArchive();
        }
        return super.getAdapter(adapter);
    }

    IBinaryParser.IBinaryArchive getBinaryArchive() {
        return this.binaryArchive;
    }

    public boolean exists() {
        return this.getResource() != null;
    }

    protected void closing(Object info) throws CModelException {
        ICProject cproject = this.getCProject();
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(cproject);
        if (pinfo != null && pinfo.vLib != null) {
            pinfo.vLib.removeChild(this);
        }
        super.closing(info);
    }
}

