/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.PathEntryContainerInitializer;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.DefaultPathEntryStore;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.cdt.internal.core.model.SetPathEntriesOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class PathEntryManager
implements IPathEntryStoreListener,
IElementChangedListener {
    public static final String PATHENTRY_STORE_ID = "PathEntryStore";
    public static final String PATHENTRY_STORE_UNIQ_ID = "org.eclipse.cdt.core.PathEntryStore";
    static String CONTAINER_INITIALIZER_EXTPOINT_ID = "PathEntryContainerInitializer";
    static final String[] NO_PREREQUISITES = new String[0];
    private static HashMap Containers = new HashMap(5);
    static final IPathEntry[] NO_PATHENTRIES = new IPathEntry[0];
    static final IMarker[] NO_MARKERS = new IMarker[0];
    protected Map resolvedMap = new Hashtable();
    private Map storeMap = new HashMap();
    private static PathEntryManager pathEntryManager;

    private PathEntryManager() {
    }

    public static synchronized PathEntryManager getDefault() {
        if (pathEntryManager == null) {
            pathEntryManager = new PathEntryManager();
            CoreModel.getDefault().addElementChangedListener(pathEntryManager);
        }
        return pathEntryManager;
    }

    public IPathEntry[] getResolvedPathEntries(ICProject cproject) throws CModelException {
        boolean markers = cproject.getProject().getWorkspace().isTreeLocked();
        return this.getResolvedPathEntries(cproject, !markers);
    }

    public IPathEntry[] getResolvedPathEntries(ICProject cproject, boolean generateMarkers) throws CModelException {
        ArrayList<IPathEntry> resolvedEntries = (ArrayList<IPathEntry>)this.resolvedMap.get(cproject);
        if (resolvedEntries == null) {
            List dups;
            IPath projectPath = cproject.getPath();
            IPathEntry[] rawEntries = this.getRawPathEntries(cproject);
            resolvedEntries = new ArrayList<IPathEntry>();
            int i = 0;
            while (i < rawEntries.length) {
                IPathEntry entry = rawEntries[i];
                if (entry.getEntryKind() == 5) {
                    IPathEntry[] containerEntries;
                    IContainerEntry centry = (IContainerEntry)entry;
                    IPathEntryContainer container = this.getPathEntryContainer(centry, cproject);
                    if (container != null && (containerEntries = container.getPathEntries()) != null) {
                        int j = 0;
                        while (j < containerEntries.length) {
                            IPathEntry newEntry = this.cloneEntry(projectPath, containerEntries[j]);
                            resolvedEntries.add(newEntry);
                            ++j;
                        }
                    }
                } else {
                    IPathEntry clone = this.cloneEntry(projectPath, entry);
                    IPathEntry e = this.getExpandedPathEntry(clone, cproject);
                    if (e != null) {
                        resolvedEntries.add(e);
                    }
                }
                ++i;
            }
            resolvedEntries.trimToSize();
            if (generateMarkers) {
                IPathEntry[] finalEntries = resolvedEntries.toArray(NO_PATHENTRIES);
                ArrayList<ICModelStatus> problemList = new ArrayList<ICModelStatus>();
                ICModelStatus status = this.validatePathEntry(cproject, finalEntries);
                if (!status.isOK()) {
                    problemList.add(status);
                }
                int j = 0;
                while (j < finalEntries.length) {
                    status = this.validatePathEntry(cproject, finalEntries[j], true, false);
                    if (!status.isOK()) {
                        problemList.add(status);
                    }
                    ++j;
                }
                ICModelStatus[] problems = new ICModelStatus[problemList.size()];
                problemList.toArray(problems);
                IProject project = cproject.getProject();
                if (this.hasPathEntryProblemMarkersChange(project, problems)) {
                    this.generateMarkers(project, problems);
                }
            }
            if ((dups = this.checkForDuplication(resolvedEntries, 3)).size() > 0) {
                resolvedEntries.removeAll(dups);
            }
            if ((dups = this.checkForDuplication(resolvedEntries, 7)).size() > 0) {
                resolvedEntries.removeAll(dups);
            }
            this.resolvedMap.put(cproject, resolvedEntries);
        }
        return resolvedEntries.toArray(NO_PATHENTRIES);
    }

    private IPathEntry getExpandedPathEntry(IPathEntry entry, ICProject cproject) throws CModelException {
        switch (entry.getEntryKind()) {
            case 4: {
                IIncludeEntry includeEntry = (IIncludeEntry)entry;
                IPath refPath = includeEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                IPath includePath = includeEntry.getIncludePath();
                if (refPath.isAbsolute()) {
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] entries = this.getResolvedPathEntries(refCProject);
                    int i = 0;
                    while (i < entries.length) {
                        IIncludeEntry refEntry;
                        if (entries[i].getEntryKind() == 4 && (refEntry = (IIncludeEntry)entries[i]).getIncludePath().equals((Object)includePath)) {
                            IPath newBasePath = refEntry.getBasePath();
                            if (!newBasePath.isAbsolute() && !includePath.isAbsolute()) {
                                IResource refRes;
                                if (!newBasePath.isEmpty()) {
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(newBasePath);
                                } else {
                                    IPath refResPath = refEntry.getPath();
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(refResPath);
                                }
                                if (refRes != null) {
                                    if (refRes.getType() == 1) {
                                        refRes = refRes.getParent();
                                    }
                                    newBasePath = refRes.getLocation().append(newBasePath);
                                }
                            }
                            return CoreModel.newIncludeEntry(includeEntry.getPath(), newBasePath, includePath);
                        }
                        ++i;
                    }
                } else {
                    IPathEntryContainer container = this.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] entries = container.getPathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        IIncludeEntry refEntry;
                        if (entries[i].getEntryKind() == 4 && (refEntry = (IIncludeEntry)entries[i]).getIncludePath().equals((Object)includePath)) {
                            IPath newBasePath = refEntry.getBasePath();
                            return CoreModel.newIncludeEntry(includeEntry.getPath(), newBasePath, includePath);
                        }
                        ++i;
                    }
                }
                break;
            }
            case 6: {
                IMacroEntry macroEntry = (IMacroEntry)entry;
                IPath refPath = macroEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                String name = macroEntry.getMacroName();
                if (refPath.isAbsolute()) {
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] entries = this.getResolvedPathEntries(refCProject);
                    int i = 0;
                    while (i < entries.length) {
                        IMacroEntry refEntry;
                        if (entries[i].getEntryKind() == 6 && (refEntry = (IMacroEntry)entries[i]).getMacroName().equals(name)) {
                            String value = refEntry.getMacroValue();
                            return CoreModel.newMacroEntry(macroEntry.getPath(), name, value);
                        }
                        ++i;
                    }
                } else {
                    IPathEntryContainer container = this.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] entries = container.getPathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        IMacroEntry refEntry;
                        if (entries[i].getEntryKind() == 6 && (refEntry = (IMacroEntry)entries[i]).getMacroName().equals(name)) {
                            String value = refEntry.getMacroValue();
                            return CoreModel.newMacroEntry(macroEntry.getPath(), name, value);
                        }
                        ++i;
                    }
                }
                break;
            }
            case 1: {
                ILibraryEntry libEntry = (ILibraryEntry)entry;
                IPath refPath = libEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                IPath libraryPath = libEntry.getLibraryPath();
                if (refPath.isAbsolute()) {
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] entries = this.getResolvedPathEntries(refCProject);
                    int i = 0;
                    while (i < entries.length) {
                        ILibraryEntry refEntry;
                        if (entries[i].getEntryKind() == 1 && (refEntry = (ILibraryEntry)entries[i]).getLibraryPath().equals((Object)libraryPath)) {
                            IPath newBasePath = refEntry.getBasePath();
                            if (!newBasePath.isAbsolute() && !libraryPath.isAbsolute()) {
                                IResource refRes;
                                if (!newBasePath.isEmpty()) {
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(newBasePath);
                                } else {
                                    IPath refResPath = refEntry.getPath();
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(refResPath);
                                }
                                if (refRes != null) {
                                    if (refRes.getType() == 1) {
                                        refRes = refRes.getParent();
                                    }
                                    newBasePath = refRes.getLocation().append(newBasePath);
                                }
                            }
                            return CoreModel.newLibraryEntry(entry.getPath(), newBasePath, refEntry.getLibraryPath(), refEntry.getSourceAttachmentPath(), refEntry.getSourceAttachmentRootPath(), refEntry.getSourceAttachmentPrefixMapping(), false);
                        }
                        ++i;
                    }
                } else {
                    IPathEntryContainer container = this.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] entries = container.getPathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        ILibraryEntry refEntry;
                        if (entries[i].getEntryKind() == 1 && (refEntry = (ILibraryEntry)entries[i]).getPath().equals((Object)libraryPath)) {
                            return CoreModel.newLibraryEntry(entry.getPath(), refEntry.getBasePath(), refEntry.getLibraryPath(), refEntry.getSourceAttachmentPath(), refEntry.getSourceAttachmentRootPath(), refEntry.getSourceAttachmentPrefixMapping(), false);
                        }
                        ++i;
                    }
                }
                break;
            }
        }
        return entry;
    }

    public void setRawPathEntries(ICProject cproject, IPathEntry[] newEntries, IProgressMonitor monitor) throws CModelException {
        try {
            IPathEntry[] oldResolvedEntries = null;
            ArrayList listEntries = (ArrayList)this.resolvedMap.get(cproject);
            if (listEntries != null) {
                oldResolvedEntries = listEntries.toArray(NO_PATHENTRIES);
            }
            SetPathEntriesOperation op = new SetPathEntriesOperation(cproject, oldResolvedEntries, newEntries);
            CModelManager.getDefault().runOperation(op, monitor);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public IPathEntry[] getRawPathEntries(ICProject cproject) throws CModelException {
        IPathEntry[] pathEntries;
        IProject project = cproject.getProject();
        if (!CoreModel.hasCNature(project) && !CoreModel.hasCCNature(project)) {
            throw new CModelException(new CModelStatus(969));
        }
        try {
            IPathEntryStore store = this.getPathEntryStore(project, true);
            pathEntries = store.getRawPathEntries();
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        boolean foundSource = false;
        boolean foundOutput = false;
        int i = 0;
        while (i < pathEntries.length) {
            IPathEntry rawEntry = pathEntries[i];
            if (rawEntry.getEntryKind() == 3) {
                foundSource = true;
            }
            if (rawEntry.getEntryKind() == 7) {
                foundOutput = true;
            }
            ++i;
        }
        if (!foundSource) {
            IPathEntry[] newEntries = new IPathEntry[pathEntries.length + 1];
            System.arraycopy(pathEntries, 0, newEntries, 0, pathEntries.length);
            newEntries[pathEntries.length] = CoreModel.newSourceEntry(cproject.getPath());
            pathEntries = newEntries;
        }
        if (!foundOutput) {
            IPathEntry[] newEntries = new IPathEntry[pathEntries.length + 1];
            System.arraycopy(pathEntries, 0, newEntries, 0, pathEntries.length);
            newEntries[pathEntries.length] = CoreModel.newOutputEntry(cproject.getPath());
            pathEntries = newEntries;
        }
        return pathEntries;
    }

    public void setPathEntryContainer(ICProject[] affectedProjects, IPathEntryContainer newContainer, IProgressMonitor monitor) throws CModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        Path containerPath = newContainer == null ? new Path("") : newContainer.getPath();
        final int projectLength = affectedProjects.length;
        final ICProject[] modifiedProjects = new ICProject[projectLength];
        System.arraycopy(affectedProjects, 0, modifiedProjects, 0, projectLength);
        final IPathEntry[][] oldResolvedEntries = new IPathEntry[projectLength][];
        int remaining = 0;
        int i = 0;
        while (i < projectLength) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            ICProject affectedProject = affectedProjects[i];
            boolean found = false;
            IPathEntry[] rawPath = this.getRawPathEntries(affectedProject);
            int j = 0;
            int cpLength = rawPath.length;
            while (j < cpLength) {
                IContainerEntry cont;
                IPathEntry entry = rawPath[j];
                if (entry.getEntryKind() == 5 && (cont = (IContainerEntry)entry).getPath().equals((Object)containerPath)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                modifiedProjects[i] = null;
                this.containerPut(affectedProject, (IPath)containerPath, newContainer);
            } else {
                IPathEntryContainer oldContainer = this.containerGet(affectedProject, (IPath)containerPath, true);
                if (oldContainer != null && newContainer != null && oldContainer.equals(newContainer)) {
                    modifiedProjects[i] = null;
                } else {
                    ++remaining;
                    ArrayList listEntries = (ArrayList)this.resolvedMap.remove(affectedProject);
                    oldResolvedEntries[i] = listEntries != null ? listEntries.toArray(NO_PATHENTRIES) : null;
                    this.containerPut(affectedProject, (IPath)containerPath, newContainer);
                }
            }
            ++i;
        }
        if (remaining == 0) {
            return;
        }
        try {
            CoreModel.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    boolean shouldFire = false;
                    CModelManager mgr = CModelManager.getDefault();
                    int i = 0;
                    while (i < projectLength) {
                        IPathEntry[] newEntries;
                        ICElementDelta[] deltas;
                        if (progressMonitor != null && progressMonitor.isCanceled()) {
                            return;
                        }
                        ICProject affectedProject = modifiedProjects[i];
                        if (affectedProject != null && oldResolvedEntries[i] != null && (deltas = PathEntryManager.this.generatePathEntryDeltas(affectedProject, oldResolvedEntries[i], newEntries = PathEntryManager.this.getResolvedPathEntries(affectedProject))).length > 0) {
                            affectedProject.close();
                            shouldFire = true;
                            int j = 0;
                            while (j < deltas.length) {
                                mgr.registerCModelDelta(deltas[j]);
                                ++j;
                            }
                        }
                        ++i;
                    }
                    if (shouldFire) {
                        mgr.fire(1);
                    }
                }
            }, monitor);
        }
        catch (CoreException coreException) {}
    }

    public IPathEntryContainer getPathEntryContainer(IContainerEntry entry, ICProject cproject) throws CModelException {
        return this.getPathEntryContainer(entry.getPath(), cproject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPathEntryContainer getPathEntryContainer(final IPath containerPath, final ICProject project) throws CModelException {
        PathEntryContainerLock lock;
        IPathEntryContainer container = this.containerGet(project, containerPath, true);
        if (!(container instanceof PathEntryContainerLock)) return container;
        boolean runInitializer = false;
        PathEntryContainerLock pathEntryContainerLock = lock = (PathEntryContainerLock)container;
        synchronized (pathEntryContainerLock) {
            if (!lock.isContainerInitialize()) {
                runInitializer = true;
                lock.setContainerInitialize(runInitializer);
            } else {
                while (this.containerGet(project, containerPath, true) instanceof PathEntryContainerLock) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (!runInitializer) return this.containerGet(project, containerPath, false);
        final PathEntryContainerInitializer initializer = this.getPathEntryContainerInitializer(containerPath.segment(0));
        final boolean[] ok = new boolean[1];
        if (initializer != null) {
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Status status = new Status(4, "org.eclipse.cdt.core", 4, "Exception occurred in container initializer: " + initializer, exception);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    initializer.initialize(containerPath, project);
                    ok[0] = true;
                }
            });
        }
        if (ok[0]) return this.containerGet(project, containerPath, false);
        this.containerPut(project, containerPath, null);
        return this.containerGet(project, containerPath, false);
    }

    public PathEntryContainerInitializer getPathEntryContainerInitializer(String containerID) {
        CCorePlugin core = CCorePlugin.getDefault();
        if (core == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", CONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String initializerID = configElements[j].getAttribute("id");
                    if (initializerID != null && initializerID.equals(containerID)) {
                        try {
                            Object execExt = configElements[j].createExecutableExtension("class");
                            if (execExt instanceof PathEntryContainerInitializer) {
                                return (PathEntryContainerInitializer)execExt;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private synchronized IPathEntryContainer containerGet(ICProject cproject, IPath containerPath, boolean bCreateLock) {
        HashMap<IPath, IPathEntryContainer> projectContainers = (HashMap<IPath, IPathEntryContainer>)Containers.get(cproject);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IPathEntryContainer>();
            Containers.put(cproject, projectContainers);
        }
        IPathEntryContainer container = (IPathEntryContainer)projectContainers.get(containerPath);
        if (bCreateLock && container == null) {
            container = new PathEntryContainerLock();
            projectContainers.put(containerPath, container);
        }
        return container;
    }

    private synchronized void containerPut(ICProject cproject, IPath containerPath, IPathEntryContainer container) {
        IPathEntryContainer oldContainer;
        HashMap<IPath, IPathEntryContainer> projectContainers = (HashMap<IPath, IPathEntryContainer>)Containers.get(cproject);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IPathEntryContainer>();
            Containers.put(cproject, projectContainers);
        }
        if ((oldContainer = container == null ? (IPathEntryContainer)projectContainers.remove(containerPath) : projectContainers.put(containerPath, container)) instanceof PathEntryContainerLock) {
            IPathEntryContainer iPathEntryContainer = oldContainer;
            synchronized (iPathEntryContainer) {
                oldContainer.notifyAll();
            }
        }
    }

    private synchronized void containerRemove(ICProject cproject) {
        Containers.remove(cproject);
    }

    public String[] projectPrerequisites(IPathEntry[] entries) throws CModelException {
        if (entries != null) {
            ArrayList<String> prerequisites = new ArrayList<String>();
            int i = 0;
            int length = entries.length;
            while (i < length) {
                if (entries[i].getEntryKind() == 2) {
                    IProjectEntry entry = (IProjectEntry)entries[i];
                    prerequisites.add(entry.getPath().lastSegment());
                }
                ++i;
            }
            int size = prerequisites.size();
            if (size != 0) {
                String[] result = new String[size];
                prerequisites.toArray(result);
                return result;
            }
        }
        return NO_PREREQUISITES;
    }

    public void saveRawPathEntries(ICProject cproject, IPathEntry[] entries) throws CModelException {
        if (entries == null) {
            entries = NO_PATHENTRIES;
        }
        ArrayList<IPathEntry> list = new ArrayList<IPathEntry>(entries.length);
        IPath projectPath = cproject.getPath();
        int i = 0;
        while (i < entries.length) {
            IPathEntry entry;
            int kind = entries[i].getEntryKind();
            IPath resourcePath = entries[i].getPath();
            if (resourcePath == null) {
                resourcePath = Path.EMPTY;
            }
            if (kind != 5 && resourcePath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(resourcePath)) {
                if (resourcePath.segment(0).equals(projectPath.segment(0))) {
                    resourcePath = resourcePath.removeFirstSegments(1);
                    resourcePath = resourcePath.makeRelative();
                } else {
                    resourcePath = resourcePath.makeAbsolute();
                }
            }
            switch (kind) {
                case 4: {
                    IIncludeEntry include = (IIncludeEntry)entries[i];
                    IPath baseRef = include.getBaseReference();
                    if (baseRef == null || baseRef.isEmpty()) {
                        entry = CoreModel.newIncludeEntry(resourcePath, include.getBasePath(), include.getIncludePath(), include.isSystemInclude(), include.getExclusionPatterns(), include.isExported());
                        break;
                    }
                    entry = CoreModel.newIncludeRefEntry(resourcePath, baseRef, include.getIncludePath());
                    break;
                }
                case 1: {
                    IPath baseRef;
                    ILibraryEntry library = (ILibraryEntry)entries[i];
                    IPath sourcePath = library.getSourceAttachmentPath();
                    if (sourcePath != null && projectPath != null && projectPath.isPrefixOf(sourcePath) && sourcePath.segment(0).equals(projectPath.segment(0))) {
                        sourcePath = sourcePath.removeFirstSegments(1);
                        sourcePath = sourcePath.makeRelative();
                    }
                    if ((baseRef = library.getBaseReference()) == null || baseRef.isEmpty()) {
                        entry = CoreModel.newLibraryEntry(resourcePath, library.getBasePath(), library.getLibraryPath(), sourcePath, library.getSourceAttachmentRootPath(), library.getSourceAttachmentPrefixMapping(), library.isExported());
                        break;
                    }
                    entry = CoreModel.newLibraryRefEntry(resourcePath, baseRef, library.getLibraryPath());
                    break;
                }
                case 6: {
                    IMacroEntry macro = (IMacroEntry)entries[i];
                    IPath baseRef = macro.getBaseReference();
                    if (baseRef == null || baseRef.isEmpty()) {
                        entry = CoreModel.newMacroEntry(resourcePath, macro.getMacroName(), macro.getMacroValue(), macro.getExclusionPatterns(), macro.isExported());
                        break;
                    }
                    entry = CoreModel.newMacroRefEntry(resourcePath, baseRef, macro.getMacroName());
                    break;
                }
                case 7: {
                    IOutputEntry out = (IOutputEntry)entries[i];
                    entry = CoreModel.newOutputEntry(resourcePath, out.getExclusionPatterns());
                    break;
                }
                case 2: {
                    IProjectEntry projEntry = (IProjectEntry)entries[i];
                    entry = CoreModel.newProjectEntry(projEntry.getPath(), projEntry.isExported());
                    break;
                }
                case 3: {
                    ISourceEntry source = (ISourceEntry)entries[i];
                    entry = CoreModel.newSourceEntry(resourcePath, source.getExclusionPatterns());
                    break;
                }
                case 5: {
                    entry = CoreModel.newContainerEntry(entries[i].getPath(), entries[i].isExported());
                    break;
                }
                default: {
                    entry = entries[i];
                }
            }
            list.add(entry);
            ++i;
        }
        try {
            IPathEntry[] newRawEntries = new IPathEntry[list.size()];
            list.toArray(newRawEntries);
            IProject project = cproject.getProject();
            IPathEntryStore store = this.getPathEntryStore(project, true);
            store.setRawPathEntries(newRawEntries);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public void generateMarkers(final IProject project, final ICModelStatus[] problems) {
        Job markerTask = new Job("PathEntry Marker Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CCorePlugin.getWorkspace().run(new IWorkspaceRunnable(this, project, problems){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ IProject val$project;
                        private final /* synthetic */ ICModelStatus[] val$problems;
                        {
                            this.this$1 = var1_1;
                            this.val$project = iProject;
                            this.val$problems = iCModelStatusArray;
                        }

                        public void run(IProgressMonitor monitor) throws CoreException {
                            3.access$0(this.this$1).flushPathEntryProblemMarkers(this.val$project);
                            int i = 0;
                            while (i < this.val$problems.length) {
                                3.access$0(this.this$1).createPathEntryProblemMarker(this.val$project, this.val$problems[i]);
                                ++i;
                            }
                        }
                    }, null);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ PathEntryManager access$0(3 var0) {
                return var0.PathEntryManager.this;
            }
        };
        markerTask.setRule((ISchedulingRule)CCorePlugin.getWorkspace().getRoot());
        markerTask.schedule();
    }

    public ICElementDelta[] generatePathEntryDeltas(ICProject cproject, IPathEntry[] oldEntries, IPathEntry[] newEntries) {
        ICElementDelta delta;
        boolean found;
        ArrayList<ICElementDelta> list = new ArrayList<ICElementDelta>();
        if (oldEntries == null) {
            return new ICElementDelta[0];
        }
        if (newEntries == null) {
            newEntries = NO_PATHENTRIES;
        }
        int i = 0;
        while (i < oldEntries.length) {
            ICElementDelta delta2;
            found = false;
            int j = 0;
            while (j < newEntries.length) {
                if (oldEntries[i].equals(newEntries[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found && (delta2 = this.makePathEntryDelta(cproject, oldEntries[i], true)) != null) {
                list.add(delta2);
            }
            ++i;
        }
        i = 0;
        while (i < newEntries.length) {
            ICElementDelta delta3;
            found = false;
            int j = 0;
            while (j < oldEntries.length) {
                if (newEntries[i].equals(oldEntries[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found && (delta3 = this.makePathEntryDelta(cproject, newEntries[i], false)) != null) {
                list.add(delta3);
            }
            ++i;
        }
        if (list.size() == 0 && oldEntries.length == newEntries.length) {
            i = 0;
            while (i < newEntries.length) {
                ICElementDelta delta4;
                if (!newEntries[i].equals(oldEntries[i]) && (delta4 = this.makePathEntryDelta(cproject, null, false)) != null) {
                    list.add(delta4);
                }
                ++i;
            }
        }
        if (list.size() == 0 && oldEntries.length != newEntries.length && (delta = this.makePathEntryDelta(cproject, null, true)) != null) {
            list.add(delta);
        }
        ICElementDelta[] deltas = new ICElementDelta[list.size()];
        list.toArray(deltas);
        return deltas;
    }

    protected ICElementDelta makePathEntryDelta(ICProject cproject, IPathEntry entry, boolean removed) {
        ICElement celement = null;
        int flag = 262144;
        if (entry == null) {
            celement = cproject;
            flag = 262144;
        } else {
            int kind = entry.getEntryKind();
            switch (kind) {
                case 3: {
                    ISourceEntry source = (ISourceEntry)entry;
                    IPath path = source.getPath();
                    celement = CoreModel.getDefault().create(path);
                    flag = removed ? 512 : 256;
                    break;
                }
                case 1: {
                    celement = cproject;
                    flag = removed ? 8192 : 4096;
                    break;
                }
                case 2: {
                    celement = cproject;
                    flag = 16384;
                    break;
                }
                case 4: {
                    IIncludeEntry include = (IIncludeEntry)entry;
                    IPath path = include.getPath();
                    celement = CoreModel.getDefault().create(path);
                    flag = 2048;
                    break;
                }
                case 6: {
                    IMacroEntry macro = (IMacroEntry)entry;
                    IPath path = macro.getPath();
                    celement = CoreModel.getDefault().create(path);
                    flag = 1024;
                    break;
                }
            }
        }
        if (celement == null) {
            celement = cproject;
        }
        CElementDelta delta = new CElementDelta(cproject.getCModel());
        delta.changed(celement, flag);
        return delta;
    }

    static String[] getRegisteredContainerIDs() {
        CCorePlugin core = CCorePlugin.getDefault();
        if (core == null) {
            return null;
        }
        ArrayList<String> containerIDList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", CONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String idAttribute = configElements[j].getAttribute("id");
                    if (idAttribute != null) {
                        containerIDList.add(idAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] containerIDs = new String[containerIDList.size()];
        containerIDList.toArray(containerIDs);
        return containerIDs;
    }

    public void setPathEntryStore(IProject project, IPathEntryStore newStore) {
        IPathEntryStore oldStore = null;
        PathEntryManager pathEntryManager = this;
        synchronized (pathEntryManager) {
            oldStore = (IPathEntryStore)this.storeMap.remove(project);
            if (newStore != null) {
                this.storeMap.put(project, newStore);
            }
        }
        if (oldStore != null) {
            oldStore.removePathEntryStoreListener(this);
            oldStore.close();
        }
    }

    public synchronized IPathEntryStore getPathEntryStore(IProject project, boolean create) throws CoreException {
        IPathEntryStore store = (IPathEntryStore)this.storeMap.get(project);
        if (store == null && create) {
            store = this.createPathEntryStore(project);
            this.storeMap.put(project, store);
            store.addPathEntryStoreListener(this);
        }
        return store;
    }

    public IPathEntryStore createPathEntryStore(IProject project) throws CoreException {
        IPathEntryStore store;
        block7: {
            store = null;
            if (project != null) {
                try {
                    ICExtensionReference[] cextensions;
                    ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(project, false);
                    if (cdesc == null || (cextensions = cdesc.get(PATHENTRY_STORE_UNIQ_ID, true)).length <= 0) break block7;
                    int i = 0;
                    while (i < cextensions.length) {
                        try {
                            store = (IPathEntryStore)cextensions[i].createExtension();
                            break;
                        }
                        catch (ClassCastException e) {
                            CCorePlugin.log(e);
                            ++i;
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        if (store == null) {
            store = new DefaultPathEntryStore(project);
        }
        return store;
    }

    public void pathEntryStoreChanged(PathEntryStoreChangedEvent event) {
        IProject project = event.getProject();
        if (project == null) {
            return;
        }
        CModelManager manager = CModelManager.getDefault();
        ICProject cproject = manager.create(project);
        if (event.hasClosed()) {
            this.setPathEntryStore(project, null);
            this.containerRemove(cproject);
        }
        if (project.isAccessible()) {
            try {
                IPathEntry[] newResolvedEntries;
                ICElementDelta[] deltas;
                IPathEntry[] oldResolvedEntries = null;
                ArrayList listEntries = (ArrayList)this.resolvedMap.remove(cproject);
                if (listEntries != null) {
                    oldResolvedEntries = listEntries.toArray(NO_PATHENTRIES);
                }
                if ((deltas = this.generatePathEntryDeltas(cproject, oldResolvedEntries, newResolvedEntries = this.getResolvedPathEntries(cproject))).length > 0) {
                    cproject.close();
                    int i = 0;
                    while (i < deltas.length) {
                        manager.registerCModelDelta(deltas[i]);
                        ++i;
                    }
                    manager.fire(1);
                }
            }
            catch (CModelException e) {
                CCorePlugin.log((Throwable)((Object)e));
            }
        } else {
            this.resolvedMap.remove(cproject);
            this.containerRemove(cproject);
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            if (this.processDelta(event.getDelta())) {
                ICProject[] cProjects = this.resolvedMap.keySet().toArray(new ICProject[0]);
                int i = 0;
                while (i < cProjects.length) {
                    ArrayList resolvedList = (ArrayList)this.resolvedMap.get(cProjects[i]);
                    if (resolvedList != null) {
                        IPathEntry[] entries = resolvedList.toArray(new IPathEntry[resolvedList.size()]);
                        IProject project = cProjects[i].getProject();
                        ArrayList<ICModelStatus> problemList = new ArrayList<ICModelStatus>();
                        ICModelStatus status = this.validatePathEntry(cProjects[i], entries);
                        if (!status.isOK()) {
                            problemList.add(status);
                        }
                        int j = 0;
                        while (j < entries.length) {
                            status = this.validatePathEntry(cProjects[i], entries[j], true, false);
                            if (!status.isOK()) {
                                problemList.add(status);
                            }
                            ++j;
                        }
                        ICModelStatus[] problems = new ICModelStatus[problemList.size()];
                        problemList.toArray(problems);
                        if (this.hasPathEntryProblemMarkersChange(project, problems)) {
                            this.generateMarkers(project, problems);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CModelException cModelException) {}
    }

    /*
     * Exception decompiling
     */
    protected boolean processDelta(ICElementDelta delta) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 133->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IPathEntry cloneEntry(IPath rpath, IPathEntry entry) {
        IPath entryPath = entry.getPath();
        if (entryPath == null) {
            entryPath = Path.EMPTY;
        }
        IPath resourcePath = entryPath.isAbsolute() ? entryPath : rpath.append(entryPath);
        switch (entry.getEntryKind()) {
            case 4: {
                IIncludeEntry include = (IIncludeEntry)entry;
                return CoreModel.newIncludeEntry(resourcePath, include.getBasePath(), include.getIncludePath(), include.isSystemInclude(), include.getExclusionPatterns(), include.isExported());
            }
            case 1: {
                ILibraryEntry library = (ILibraryEntry)entry;
                return CoreModel.newLibraryEntry(resourcePath, library.getBasePath(), library.getLibraryPath(), library.getSourceAttachmentPath(), library.getSourceAttachmentRootPath(), library.getSourceAttachmentPrefixMapping(), library.isExported());
            }
            case 6: {
                IMacroEntry macro = (IMacroEntry)entry;
                return CoreModel.newMacroEntry(resourcePath, macro.getMacroName(), macro.getMacroValue(), macro.getExclusionPatterns(), macro.isExported());
            }
            case 7: {
                IOutputEntry out = (IOutputEntry)entry;
                return CoreModel.newOutputEntry(resourcePath, out.getExclusionPatterns());
            }
            case 2: {
                IProjectEntry projEntry = (IProjectEntry)entry;
                return CoreModel.newProjectEntry(projEntry.getPath(), projEntry.isExported());
            }
            case 3: {
                ISourceEntry source = (ISourceEntry)entry;
                return CoreModel.newSourceEntry(resourcePath, source.getExclusionPatterns());
            }
            case 5: {
                return CoreModel.newContainerEntry(entry.getPath(), entry.isExported());
            }
        }
        return entry;
    }

    public ICModelStatus validatePathEntry(ICProject cProject, IPathEntry[] entries) {
        StringBuffer errMesg;
        int i;
        ICModelStatus[] cmodelStatus;
        int i2 = 0;
        while (i2 < entries.length) {
            IPathEntry entry = entries[i2];
            if (entry != null) {
                int j = 0;
                while (j < entries.length) {
                    IPathEntry otherEntry = entries[j];
                    if (otherEntry != null && entry != otherEntry && otherEntry.equals(entry)) {
                        StringBuffer errMesg2 = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                        return new CModelStatus(964, errMesg2.toString());
                    }
                    ++j;
                }
            }
            ++i2;
        }
        List dups = this.checkForDuplication(Arrays.asList(entries), 3);
        if (dups.size() > 0) {
            cmodelStatus = new ICModelStatus[dups.size()];
            i = 0;
            while (i < dups.size()) {
                errMesg = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                cmodelStatus[i] = new CModelStatus(964, errMesg.toString());
                ++i;
            }
            return CModelStatus.newMultiStatus(964, cmodelStatus);
        }
        dups = this.checkForDuplication(Arrays.asList(entries), 7);
        if (dups.size() > 0) {
            cmodelStatus = new ICModelStatus[dups.size()];
            i = 0;
            while (i < dups.size()) {
                errMesg = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                cmodelStatus[i] = new CModelStatus(977, errMesg.toString());
                ++i;
            }
            return CModelStatus.newMultiStatus(964, cmodelStatus);
        }
        int i3 = 0;
        while (i3 < entries.length) {
            IPathEntry entry = entries[i3];
            if (entry != null) {
                IPath entryPath = entry.getPath();
                int kind = entry.getEntryKind();
                if (kind == 3) {
                    int j = 0;
                    while (j < entries.length) {
                        IPathEntry otherEntry = entries[j];
                        if (otherEntry != null) {
                            int otherKind = otherEntry.getEntryKind();
                            IPath otherPath = otherEntry.getPath();
                            if (entry != otherEntry && otherKind == 3) {
                                char[][] exclusionPatterns = ((ISourceEntry)otherEntry).fullExclusionPatternChars();
                                if (otherPath.isPrefixOf(entryPath) && !otherPath.equals((Object)entryPath) && !CoreModelUtil.isExcluded(entryPath.append("*"), exclusionPatterns)) {
                                    String exclusionPattern = entryPath.removeFirstSegments(otherPath.segmentCount()).segment(0);
                                    if (CoreModelUtil.isExcluded(entryPath, exclusionPatterns)) {
                                        StringBuffer errMesg3 = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                        return new CModelStatus(964, errMesg3.toString());
                                    }
                                    if (otherKind == 3) {
                                        exclusionPattern = String.valueOf(exclusionPattern) + '/';
                                        StringBuffer errMesg4 = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                        return new CModelStatus(964, errMesg4.toString());
                                    }
                                    StringBuffer errMesg5 = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                    return new CModelStatus(964, errMesg5.toString());
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i3;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public ICModelStatus validatePathEntry(ICProject cProject, IPathEntry entry, boolean checkSourceAttachment, boolean recurseInContainers) {
        IProject project = cProject.getProject();
        IPath path = entry.getPath();
        if (entry.getEntryKind() != 2 && !this.isValidWorkspacePath(project, path)) {
            return new CModelStatus(964, String.valueOf(CoreModelMessages.getString("PathEntryManager.0")) + path.toOSString() + " for " + ((PathEntry)entry).getKindString());
        }
        switch (entry.getEntryKind()) {
            case 4: {
                IIncludeEntry include = (IIncludeEntry)entry;
                IPath includePath = include.getFullIncludePath();
                if (!this.isValidExternalPath(includePath)) {
                    return new CModelStatus(964, String.valueOf(CoreModelMessages.getString("PathEntryManager.2")) + " (" + includePath.toOSString() + ")");
                }
                if (this.isValidBasePath(include.getBasePath())) break;
                return new CModelStatus(964, String.valueOf(CoreModelMessages.getString("PathEntryManager.1")) + " (" + includePath.toOSString() + ")");
            }
            case 1: {
                IPath sourceAttach;
                ILibraryEntry library = (ILibraryEntry)entry;
                if (!(!checkSourceAttachment || (sourceAttach = library.getSourceAttachmentPath()) == null || sourceAttach.isAbsolute() || this.isValidWorkspacePath(project, sourceAttach) && this.isValidExternalPath(sourceAttach))) {
                    return new CModelStatus(964, String.valueOf(CoreModelMessages.getString("PathEntryManager.3")) + " (" + sourceAttach.toOSString() + ")");
                }
                IPath libraryPath = library.getFullLibraryPath();
                if (!this.isValidExternalPath(libraryPath)) {
                    return new CModelStatus(964, String.valueOf(CoreModelMessages.getString("PathEntryManager.4")) + " (" + libraryPath.toOSString() + ")");
                }
                if (this.isValidBasePath(library.getBasePath())) break;
                return new CModelStatus(964, String.valueOf(CoreModelMessages.getString("PathEntryManager.7")) + " (" + libraryPath.toOSString() + ")");
            }
            case 2: {
                IProjectEntry projEntry = (IProjectEntry)entry;
                path = projEntry.getPath();
                IProject reqProject = project.getWorkspace().getRoot().getProject(path.segment(0));
                if (!reqProject.isAccessible()) {
                    return new CModelStatus(964, CoreModelMessages.getString("PathEntryManager.5"));
                }
                if (CoreModel.hasCNature(reqProject) || CoreModel.hasCCNature(reqProject)) break;
                return new CModelStatus(964, CoreModelMessages.getString("PathEntryManager.6"));
            }
            case 5: {
                if (!recurseInContainers) break;
                try {
                    IPathEntryContainer cont = this.getPathEntryContainer((IContainerEntry)entry, cProject);
                    IPathEntry[] contEntries = cont.getPathEntries();
                    int i = 0;
                    while (i < contEntries.length) {
                        ICModelStatus status = this.validatePathEntry(cProject, contEntries[i], checkSourceAttachment, false);
                        if (!status.isOK()) {
                            return status;
                        }
                        ++i;
                    }
                    break;
                }
                catch (CModelException e) {
                    return new CModelStatus(e);
                }
            }
        }
        return CModelStatus.VERIFIED_OK;
    }

    private boolean isValidWorkspacePath(IProject project, IPath path) {
        if (path == null) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        IResource res = null;
        res = path.isAbsolute() ? workspaceRoot.findMember(path) : project.findMember(path);
        return res != null && res.isAccessible();
    }

    private boolean isValidExternalPath(IPath path) {
        File file;
        if (path != null && (file = path.toFile()) != null) {
            return file.exists();
        }
        return false;
    }

    private boolean isValidBasePath(IPath path) {
        IResource res;
        return path.isEmpty() || path.isAbsolute() || (res = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && res.isAccessible();
    }

    private List checkForDuplication(List pathEntries, int type) {
        ArrayList<IPathEntry> duplicate = new ArrayList<IPathEntry>(pathEntries.size());
        int i = 0;
        while (i < pathEntries.size()) {
            IPathEntry pathEntry = (IPathEntry)pathEntries.get(i);
            if (pathEntry.getEntryKind() == type) {
                int j = 0;
                while (j < pathEntries.size()) {
                    IPathEntry otherEntry = (IPathEntry)pathEntries.get(j);
                    if (otherEntry.getEntryKind() == type && !pathEntry.equals(otherEntry) && !duplicate.contains(pathEntry) && pathEntry.getPath().equals((Object)otherEntry.getPath())) {
                        duplicate.add(otherEntry);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return duplicate;
    }

    void createPathEntryProblemMarker(IProject project, ICModelStatus status) {
        int severity = this.code2Severity(status);
        try {
            IMarker marker = project.createMarker("org.eclipse.cdt.core.pathentry_problem");
            marker.setAttributes(new String[]{"message", "severity", "location", "pathEntryFileFormat"}, new Object[]{status.getMessage(), new Integer(severity), "pathentry", "false"});
        }
        catch (CoreException coreException) {}
    }

    protected void flushPathEntryProblemMarkers(IProject project) {
        IWorkspace workspace = project.getWorkspace();
        try {
            IMarker[] markers = this.getPathEntryProblemMarkers(project);
            workspace.deleteMarkers(markers);
        }
        catch (CoreException coreException) {}
    }

    protected IMarker[] getPathEntryProblemMarkers(IProject project) {
        try {
            project.getWorkspace();
            IMarker[] markers = project.findMarkers("org.eclipse.cdt.core.pathentry_problem", false, 0);
            if (markers != null) {
                return markers;
            }
        }
        catch (CoreException coreException) {}
        return NO_MARKERS;
    }

    protected boolean hasPathEntryProblemMarkersChange(IProject project, ICModelStatus[] status) {
        IMarker[] markers = this.getPathEntryProblemMarkers(project);
        if (markers.length != status.length) {
            return true;
        }
        int i = 0;
        while (i < markers.length) {
            boolean found = false;
            String message = markers[i].getAttribute("message", "");
            int severity = markers[i].getAttribute("severity", 2);
            int j = 0;
            while (j < status.length) {
                String msg = status[j].getMessage();
                int cseverity = this.code2Severity(status[j]);
                if (msg.equals(message) && severity == cseverity) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int code2Severity(ICModelStatus status) {
        int severity;
        switch (status.getCode()) {
            case 964: {
                severity = 1;
                break;
            }
            case 979: {
                severity = 1;
                break;
            }
            default: {
                severity = 2;
            }
        }
        return severity;
    }

    private class PathEntryContainerLock
    implements IPathEntryContainer {
        boolean runInitializer;

        PathEntryContainerLock() {
        }

        public boolean isContainerInitialize() {
            return this.runInitializer;
        }

        public void setContainerInitialize(boolean init) {
            this.runInitializer = init;
        }

        public IPathEntry[] getPathEntries() {
            return NO_PATHENTRIES;
        }

        public String getDescription() {
            return new String("Lock container");
        }

        public IPath getPath() {
            return Path.EMPTY;
        }
    }
}

