/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;

public class GLDErrorParser
implements IErrorParser {
    public boolean processLine(String line, ErrorParserManager eoParser) {
        int firstColon = line.indexOf(58);
        if (firstColon != -1) {
            String buf = line.substring(0, firstColon);
            String desc = line.substring(firstColon + 1);
            int firstPara = buf.indexOf(40);
            int secondPara = buf.indexOf(41);
            if (firstPara >= 0 && secondPara >= 0) {
                int colon;
                String fileName = buf.substring(0, firstPara);
                String previous = eoParser.getPreviousLine();
                if (previous == null) {
                    previous = "";
                }
                if ((colon = previous.indexOf(58)) != -1) {
                    previous = previous.substring(colon + 1);
                }
                if (!Path.EMPTY.isValidPath(fileName)) {
                    return false;
                }
                desc = "*" + previous + " " + desc;
                IFile file = eoParser.findFileName(fileName);
                if (file != null) {
                    if (eoParser.isConflictingName(fileName)) {
                        file = null;
                    }
                } else {
                    file = eoParser.findFilePath(fileName);
                }
                if (file == null) {
                    desc = String.valueOf(fileName) + " " + desc;
                }
                eoParser.generateMarker((IResource)file, 0, desc, 2, null);
            } else if (buf.endsWith("ld")) {
                String fileName;
                IFile file;
                int errorType = 2;
                if ((desc = desc.trim()).startsWith("warning") || desc.startsWith("Warning")) {
                    errorType = 1;
                }
                if ((file = eoParser.findFileName(fileName = line.substring(0, firstColon))) != null) {
                    if (eoParser.isConflictingName(fileName)) {
                        file = null;
                    }
                } else {
                    file = eoParser.findFilePath(fileName);
                }
                if (file == null) {
                    desc = String.valueOf(fileName) + " " + desc;
                }
                eoParser.generateMarker((IResource)file, 0, desc, errorType, null);
            }
        }
        return false;
    }
}

