/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MISigHandle;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class MIInfoSignalsInfo
extends MIInfo {
    MISigHandle[] signals;

    public MIInfoSignalsInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public MISigHandle[] getMISignals() {
        return this.signals;
    }

    void parse() {
        ArrayList aList = new ArrayList();
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    this.parseSignal(str.trim(), aList);
                }
                ++i;
            }
        }
        this.signals = new MISigHandle[aList.size()];
        int i = 0;
        while (i < aList.size()) {
            this.signals[i] = (MISigHandle)aList.get(i);
            ++i;
        }
    }

    void parseSignal(String str, List aList) {
        if (str.length() > 0 && !str.startsWith("Signal ") && !str.startsWith("Use ")) {
            String signal = "";
            boolean stop = false;
            boolean print = false;
            boolean pass = false;
            String desc = "";
            StringTokenizer tokenizer = new StringTokenizer(str);
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String sub = null;
                sub = i == 4 ? tokenizer.nextToken("\n") : tokenizer.nextToken();
                switch (i) {
                    case 0: {
                        signal = sub;
                        break;
                    }
                    case 1: {
                        stop = MIInfoSignalsInfo.getBoolean(sub);
                        break;
                    }
                    case 2: {
                        print = MIInfoSignalsInfo.getBoolean(sub);
                        break;
                    }
                    case 3: {
                        pass = MIInfoSignalsInfo.getBoolean(sub);
                        break;
                    }
                    case 4: {
                        desc = sub;
                    }
                }
                ++i;
            }
            MISigHandle s = new MISigHandle(signal, stop, print, pass, desc.trim());
            aList.add(s);
        }
    }

    static boolean getBoolean(String value) {
        return value != null && value.equalsIgnoreCase("Yes");
    }
}

