/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;

public class ConsoleOutputSniffer {
    private int nOpens = 0;
    private OutputStream consoleOutputStream;
    private OutputStream consoleErrorStream;
    private IScannerInfoConsoleParser[] parsers;

    public ConsoleOutputSniffer(IScannerInfoConsoleParser[] parsers) {
        this.parsers = parsers;
    }

    public ConsoleOutputSniffer(OutputStream outputStream, OutputStream errorStream, IScannerInfoConsoleParser[] parsers) {
        this(parsers);
        this.consoleOutputStream = outputStream;
        this.consoleErrorStream = errorStream;
    }

    public OutputStream getOutputStream() {
        this.incNOpens();
        return new ConsoleOutputStream(this.consoleOutputStream);
    }

    public OutputStream getErrorStream() {
        this.incNOpens();
        return new ConsoleOutputStream(this.consoleErrorStream);
    }

    private synchronized void incNOpens() {
        ++this.nOpens;
    }

    public synchronized void closeConsoleOutputStream() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            int i = 0;
            while (i < this.parsers.length) {
                this.parsers[i].shutdown();
                ++i;
            }
        }
    }

    private synchronized void processLine(String line) {
        int i = 0;
        while (i < this.parsers.length) {
            this.parsers[i].processLine(line);
            ++i;
        }
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private StringBuffer currentLine = new StringBuffer();
        private OutputStream outputStream = null;

        public ConsoleOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void write(int b) throws IOException {
            this.currentLine.append((char)b);
            this.checkLine(false);
            if (this.outputStream != null) {
                this.outputStream.write(b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off != 0 || len < 0 || len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.currentLine.append(new String(b, 0, len));
            this.checkLine(false);
            if (this.outputStream != null) {
                this.outputStream.write(b, off, len);
            }
        }

        public void close() throws IOException {
            this.checkLine(true);
            ConsoleOutputSniffer.this.closeConsoleOutputStream();
        }

        public void flush() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }

        private void checkLine(boolean flush) {
            String buffer = this.currentLine.toString();
            int i = 0;
            while ((i = buffer.indexOf(10)) != -1) {
                String line = buffer.substring(0, i).trim();
                if (line.length() > 0) {
                    ConsoleOutputSniffer.this.processLine(line);
                }
                buffer = buffer.substring(i + 1);
            }
            this.currentLine.setLength(0);
            if (flush) {
                if (buffer.length() > 0) {
                    ConsoleOutputSniffer.this.processLine(buffer);
                }
            } else {
                this.currentLine.append(buffer);
            }
        }
    }
}

