/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ScannerInfoCollector
implements IScannerInfoCollector {
    private static ScannerInfoCollector instance = new ScannerInfoCollector();
    private Map discoveredIncludes = new HashMap();
    private Map discoveredSymbols = new HashMap();
    private Map discoveredTSO = new HashMap();
    private Map sumDiscoveredIncludes = new HashMap();
    private Map sumDiscoveredSymbols = new HashMap();
    private IProject currentProject;

    private ScannerInfoCollector() {
    }

    public static ScannerInfoCollector getInstance() {
        return instance;
    }

    public void contributeToScannerConfig(IResource resource, List includes, List symbols, Map extraInfo) {
        IProject project;
        if (resource == null || (project = resource.getProject()) == null) {
            TraceUtil.outputError("IScannerInfoCollector.contributeToScannerConfig : ", "resource or project is null");
            return;
        }
        try {
            if (project.hasNature(MakeProjectNature.NATURE_ID) && (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature"))) {
                String projectName = project.getName();
                this.contribute(projectName, this.discoveredIncludes, includes, true);
                this.contribute(projectName, this.discoveredSymbols, symbols, false);
                this.contribute(projectName, this.discoveredTSO, extraInfo == null ? null : (List)extraInfo.get(IScannerInfoCollector.TARGET_SPECIFIC_OPTION), false);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean contribute(String projectName, Map discovered, List delta, boolean ordered) {
        if (delta == null || delta.isEmpty()) {
            return false;
        }
        ArrayList projectDiscovered = (ArrayList)discovered.get(projectName);
        if (projectDiscovered == null) {
            projectDiscovered = new ArrayList(delta);
            discovered.put(projectName, projectDiscovered);
            return true;
        }
        return this.addItemsWithOrder(delta, projectDiscovered, ordered);
    }

    private boolean addItemsWithOrder(List includes, List sumIncludes, boolean ordered) {
        boolean addedIncludes = false;
        int prev = sumIncludes.size() - 1;
        Iterator i = includes.iterator();
        while (i.hasNext()) {
            String item = (String)i.next();
            if (!sumIncludes.contains(item)) {
                sumIncludes.add(prev + 1, item);
                addedIncludes = true;
            }
            int n = prev = ordered ? sumIncludes.indexOf(item) : sumIncludes.size() - 1;
        }
        return addedIncludes;
    }

    private void updateScannerConfig(IProject project, IProgressMonitor monitor) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo pathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(project);
        monitor.beginTask(MakeMessages.getString("ScannerInfoCollector.Processing"), 100);
        if (pathInfo != null) {
            String projectName = project.getName();
            monitor.subTask(MakeMessages.getString("ScannerInfoCollector.Processing"));
            if (this.scannerConfigNeedsUpdate(pathInfo)) {
                monitor.worked(50);
                monitor.subTask(String.valueOf(MakeMessages.getString("ScannerInfoCollector.Updating")) + projectName);
                try {
                    MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(pathInfo);
                    monitor.worked(50);
                }
                catch (CoreException e) {
                    MakeCorePlugin.log(e);
                }
            }
        }
        monitor.done();
    }

    private boolean scannerConfigNeedsUpdate(IDiscoveredPathManager.IDiscoveredPathInfo discPathInfo) {
        List includes = (List)this.discoveredIncludes.get(discPathInfo.getProject().getName());
        List symbols = (List)this.discoveredSymbols.get(discPathInfo.getProject().getName());
        boolean addedIncludes = this.includePathsNeedUpdate(discPathInfo, includes);
        boolean addedSymbols = this.definedSymbolsNeedUpdate(discPathInfo, symbols);
        return addedIncludes | addedSymbols;
    }

    private boolean includePathsNeedUpdate(IDiscoveredPathManager.IDiscoveredPathInfo discPathInfo, List includes) {
        boolean addedIncludes = false;
        String projectName = discPathInfo.getProject().getName();
        if (includes != null) {
            LinkedHashMap newPersistedIncludes;
            ArrayList sumIncludes = (ArrayList)this.sumDiscoveredIncludes.get(projectName);
            if (sumIncludes == null) {
                sumIncludes = new ArrayList(includes);
                this.sumDiscoveredIncludes.put(projectName, sumIncludes);
                addedIncludes = true;
            } else {
                addedIncludes = this.addItemsWithOrder(includes, sumIncludes, true);
            }
            List finalSumIncludes = this.translateIncludePaths(sumIncludes);
            LinkedHashMap persistedIncludes = discPathInfo.getIncludeMap();
            ArrayList persistedKeyList = new ArrayList(persistedIncludes.keySet());
            addedIncludes = this.addItemsWithOrder(finalSumIncludes, persistedKeyList, true);
            if (addedIncludes) {
                newPersistedIncludes = new LinkedHashMap(persistedKeyList.size());
                Iterator i = persistedKeyList.iterator();
                while (i.hasNext()) {
                    String include = (String)i.next();
                    if (persistedIncludes.containsKey(include)) {
                        newPersistedIncludes.put(include, persistedIncludes.get(include));
                        continue;
                    }
                    newPersistedIncludes.put(include, new Path(include).toFile().exists() ? Boolean.FALSE : Boolean.TRUE);
                }
            } else {
                newPersistedIncludes = persistedIncludes;
            }
            discPathInfo.setIncludeMap(newPersistedIncludes);
            this.discoveredIncludes.put(projectName, null);
        }
        return addedIncludes;
    }

    private boolean definedSymbolsNeedUpdate(IDiscoveredPathManager.IDiscoveredPathInfo discPathInfo, List symbols) {
        boolean addedSymbols = false;
        String projectName = discPathInfo.getProject().getName();
        if (symbols != null) {
            LinkedHashMap sumSymbols = (LinkedHashMap)this.sumDiscoveredSymbols.get(projectName);
            if (sumSymbols == null) {
                sumSymbols = new LinkedHashMap();
                this.sumDiscoveredSymbols.put(projectName, sumSymbols);
            }
            addedSymbols = ScannerConfigUtil.scAddSymbolsList2SymbolEntryMap(sumSymbols, symbols, false);
            LinkedHashMap persistedSymbols = discPathInfo.getSymbolMap();
            LinkedHashMap candidateSymbols = new LinkedHashMap(persistedSymbols);
            addedSymbols |= ScannerConfigUtil.scAddSymbolEntryMap2SymbolEntryMap(candidateSymbols, sumSymbols);
            discPathInfo.setSymbolMap(candidateSymbols);
            this.discoveredSymbols.put(projectName, null);
        }
        return addedSymbols;
    }

    private List translateIncludePaths(List sumIncludes) {
        ArrayList<String> translatedIncludePaths = new ArrayList<String>();
        Iterator i = sumIncludes.iterator();
        while (i.hasNext()) {
            String includePath = (String)i.next();
            Path realPath = new Path(includePath);
            if (!realPath.toFile().exists()) {
                String translatedPath = includePath;
                if (Platform.getOS().equals("win32")) {
                    translatedPath = new CygpathTranslator(this.currentProject, includePath).run();
                }
                if (translatedPath != null) {
                    if (!translatedPath.equals(includePath)) {
                        Path transPath = new Path(translatedPath);
                        if (transPath.toFile().exists()) {
                            translatedIncludePaths.add(translatedPath);
                            continue;
                        }
                        translatedIncludePaths.add(translatedPath);
                        continue;
                    }
                    translatedIncludePaths.add(translatedPath);
                    continue;
                }
                TraceUtil.outputError("CygpathTranslator unable to translate path: ", includePath);
                continue;
            }
            translatedIncludePaths.add(includePath);
        }
        return translatedIncludePaths;
    }

    private void getProviderScannerInfo(final IProject project, final List tso, final IProgressMonitor monitor) {
        IScannerConfigBuilderInfo info;
        try {
            info = MakeCorePlugin.createScannerConfigBuildInfo(project, ScannerConfigBuilder.BUILDER_ID);
        }
        catch (CoreException coreException) {
            info = MakeCorePlugin.createScannerConfigBuildInfo(MakeCorePlugin.getDefault().getPluginPreferences(), ScannerConfigBuilder.BUILDER_ID, false);
        }
        if (info.isESIProviderCommandEnabled()) {
            final IScannerConfigBuilderInfo buildInfo = info;
            final IExternalScannerInfoProvider esiProvider = MakeCorePlugin.getDefault().getExternalScannerInfoProvider(MakeCorePlugin.DEFAULT_EXTERNAL_SI_PROVIDER_ID);
            if (esiProvider != null) {
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() {
                        esiProvider.invokeProvider(monitor, project, buildInfo, tso, ScannerInfoCollector.getInstance());
                    }

                    public void handleException(Throwable exception) {
                        MakeCorePlugin.log(exception);
                    }
                };
                Platform.run((ISafeRunnable)runnable);
            }
        }
    }

    public synchronized void updateScannerConfiguration(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.currentProject = project;
        String projectName = project.getName();
        monitor.beginTask("", 100);
        this.getProviderScannerInfo(project, (List)this.discoveredTSO.get(projectName), (IProgressMonitor)new SubProgressMonitor(monitor, 60));
        this.updateScannerConfig(project, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
        this.discoveredIncludes.put(projectName, null);
        this.discoveredSymbols.put(projectName, null);
        this.discoveredTSO.put(projectName, null);
    }

    public void deleteAllPaths(IProject project) {
        if (project != null) {
            this.sumDiscoveredIncludes.put(project.getName(), null);
        }
    }

    public void deleteAllSymbols(IProject project) {
        if (project != null) {
            this.sumDiscoveredSymbols.put(project.getName(), null);
        }
    }

    public void deletePath(IProject project, String path) {
        List sumIncludes;
        if (project != null && (sumIncludes = (List)this.sumDiscoveredIncludes.get(project.getName())) != null) {
            sumIncludes.remove(path);
        }
    }

    public void deleteSymbol(IProject project, String symbol) {
        Map sumSymbols;
        if (project != null && (sumSymbols = (Map)this.sumDiscoveredSymbols.get(project.getName())) != null) {
            ScannerConfigUtil.removeSymbolEntryValue(symbol, sumSymbols);
        }
    }
}

