/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.internal.filetype.ResolverModel;
import org.eclipse.core.resources.IContainer;

public abstract class CFileTypeResolver
implements ICFileTypeResolver {
    protected IContainer fContainer;
    protected List fAssocList;

    public CFileTypeResolver(IContainer container) {
        this.fContainer = container;
    }

    public IContainer getContainer() {
        return this.fContainer;
    }

    public boolean addAssociations(ICFileTypeAssociation[] assocs) {
        return this.adjustAssociations(assocs, null, false);
    }

    public ICFileType getFileType(String fileName) {
        ICFileTypeAssociation[] assocs = this.getFileTypeAssociations();
        int i = 0;
        while (i < assocs.length) {
            ICFileTypeAssociation element = assocs[i];
            if (element.matches(fileName)) {
                return element.getType();
            }
            ++i;
        }
        return ResolverModel.DEFAULT_FILE_TYPE;
    }

    public boolean removeAssociations(ICFileTypeAssociation[] assocs) {
        return this.adjustAssociations(null, assocs, false);
    }

    public synchronized ICFileTypeAssociation[] getFileTypeAssociations() {
        if (this.fAssocList == null) {
            this.loadAssociationList();
        }
        return this.fAssocList.toArray(new ICFileTypeAssociation[this.fAssocList.size()]);
    }

    public boolean adjustAssociations(ICFileTypeAssociation[] addAssocs, ICFileTypeAssociation[] delAssocs) {
        return this.adjustAssociations(addAssocs, delAssocs, true);
    }

    protected synchronized boolean adjustAssociations(ICFileTypeAssociation[] addAssocs, ICFileTypeAssociation[] delAssocs, boolean triggerEvent) {
        boolean changed;
        int i;
        ArrayList<ICFileTypeAssociation> addList = new ArrayList<ICFileTypeAssociation>();
        ArrayList<ICFileTypeAssociation> delList = new ArrayList<ICFileTypeAssociation>();
        this.loadAssociationList();
        if (addAssocs != null) {
            i = 0;
            while (i < addAssocs.length) {
                if (!this.fAssocList.contains(addAssocs[i])) {
                    this.fAssocList.add(addAssocs[i]);
                    addList.add(addAssocs[i]);
                }
                ++i;
            }
        }
        if (delAssocs != null) {
            i = 0;
            while (i < delAssocs.length) {
                if (this.fAssocList.remove(delAssocs[i])) {
                    delList.add(delAssocs[i]);
                }
                ++i;
            }
        }
        boolean bl = changed = !addList.isEmpty() || !delList.isEmpty();
        if (changed) {
            Collections.sort(this.fAssocList, ICFileTypeAssociation.Comparator);
            addAssocs = addList.toArray(new ICFileTypeAssociation[addList.size()]);
            delAssocs = delList.toArray(new ICFileTypeAssociation[delList.size()]);
            this.doAdjustAssociations(addAssocs, delAssocs, triggerEvent);
        }
        return changed;
    }

    public ICFileTypeResolver createWorkingCopy() {
        final ICFileTypeAssociation[] associations = this.getFileTypeAssociations();
        CFileTypeResolver copy = new CFileTypeResolver(this.fContainer){

            public void doAdjustAssociations(ICFileTypeAssociation[] add, ICFileTypeAssociation[] del, boolean triggerEvent) {
            }

            protected ICFileTypeAssociation[] loadAssociations() {
                return associations;
            }
        };
        return copy;
    }

    protected abstract void doAdjustAssociations(ICFileTypeAssociation[] var1, ICFileTypeAssociation[] var2, boolean var3);

    protected abstract ICFileTypeAssociation[] loadAssociations();

    private synchronized List loadAssociationList() {
        if (this.fAssocList == null) {
            this.fAssocList = new ArrayList();
            ICFileTypeAssociation[] assocs = this.loadAssociations();
            if (assocs != null) {
                this.fAssocList.addAll(Arrays.asList(assocs));
                Collections.sort(this.fAssocList, ICFileTypeAssociation.Comparator);
            }
        }
        return this.fAssocList;
    }
}

